/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.conf;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.enums.HandleSystemErrorStrategy;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.tsfile.fileSystem.FSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonConfig {
    public static final String CONFIG_NAME = "iotdb-common.properties";
    private static final Logger logger = LoggerFactory.getLogger(CommonConfig.class);
    private String openIdProviderUrl = "";
    private String authorizerProvider = "org.apache.iotdb.commons.auth.authorizer.LocalFileAuthorizer";
    private String encryptDecryptProvider = "org.apache.iotdb.commons.security.encrypt.MessageDigestEncrypt";
    private String encryptDecryptProviderParameter;
    private String adminName = "root";
    private String adminPassword = "root";
    private String userFolder = IoTDBConstant.DEFAULT_BASE_DIR + File.separator + "system" + File.separator + "users";
    private String roleFolder = IoTDBConstant.DEFAULT_BASE_DIR + File.separator + "system" + File.separator + "roles";
    private String procedureWalFolder = IoTDBConstant.DEFAULT_BASE_DIR + File.separator + "system" + File.separator + "procedure";
    private String syncDir = IoTDBConstant.DEFAULT_BASE_DIR + File.separator + "sync";
    private String[] walDirs = new String[]{IoTDBConstant.DEFAULT_BASE_DIR + File.separator + "wal"};
    private FSType systemFileStorageFs = FSType.LOCAL;
    private long[] tierTTLInMs = new long[]{Long.MAX_VALUE};
    private int connectionTimeoutInMS = (int)TimeUnit.SECONDS.toMillis(60L);
    private int selectorNumOfClientManager = 1;
    private boolean isRpcThriftCompressionEnabled = false;
    private int coreClientNumForEachNode = 200;
    private int maxClientNumForEachNode = 300;
    private HandleSystemErrorStrategy handleSystemErrorStrategy = HandleSystemErrorStrategy.CHANGE_TO_READ_ONLY;
    private volatile NodeStatus status = NodeStatus.Running;
    private volatile boolean isStopping = false;
    private volatile String statusReason = null;
    private final int TTimePartitionSlotTransmitLimit = 1000;
    private double diskSpaceWarningThreshold = 0.05;
    private TEndPoint targetMLNodeEndPoint = new TEndPoint("127.0.0.1", 10810);
    private long timePartitionInterval = 604800000L;
    private String timestampPrecision = "ms";
    private String pipeHardlinkBaseDirName = "pipe";
    private String pipeHardlinkTsFileDirName = "tsfile";
    private String pipeHardlinkWALDirName = "wal";
    private boolean pipeHardLinkWALEnabled = false;
    private int pipeSubtaskExecutorMaxThreadNum = Math.min(5, Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
    private int pipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount = 10000;
    private long pipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration = 10000L;
    private long pipeSubtaskExecutorPendingQueueMaxBlockingTimeMs = 1000L;
    private int pipeExtractorAssignerDisruptorRingBufferSize = 65536;
    private int pipeExtractorMatcherCacheSize = 1024;
    private int pipeExtractorPendingQueueCapacity = 256;
    private int pipeExtractorPendingQueueTabletLimit = this.pipeExtractorPendingQueueCapacity / 2;
    private int pipeDataStructureTabletRowSize = 2048;
    private long pipeConnectorTimeoutMs = 900000L;
    private int pipeConnectorReadFileBufferSize = 0x800000;
    private long pipeConnectorRetryIntervalMs = 1000L;
    private int pipeConnectorPendingQueueSize = 16;
    private boolean pipeConnectorRPCThriftCompressionEnabled = false;
    private int pipeAsyncConnectorSelectorNumber = 1;
    private int pipeAsyncConnectorCoreClientNumber = 8;
    private int pipeAsyncConnectorMaxClientNumber = 16;
    private boolean isSeperatedPipeHeartbeatEnabled = true;
    private int pipeHeartbeatIntervalSecondsForCollectingPipeMeta = 100;
    private long pipeMetaSyncerInitialSyncDelayMinutes = 3L;
    private long pipeMetaSyncerSyncIntervalMinutes = 3L;
    private long pipeMetaSyncerAutoRestartPipeCheckIntervalRound = 1L;
    private boolean pipeAutoRestartEnabled = true;
    private boolean pipeAirGapReceiverEnabled = false;
    private int pipeAirGapReceiverPort = 9780;
    private String schemaEngineMode = "Memory";
    private boolean lastCacheEnable = true;
    private int tagAttributeTotalSize = 700;
    private int databaseLimitThreshold = -1;

    CommonConfig() {
    }

    public void updatePath(String homeDir) {
        if (homeDir == null) {
            return;
        }
        File homeFile = new File(homeDir);
        try {
            homeDir = homeFile.getCanonicalPath();
        }
        catch (IOException e) {
            logger.error("Fail to get canonical path of {}", (Object)homeFile, (Object)e);
        }
        this.userFolder = FileUtils.addPrefix2FilePath(homeDir, this.userFolder);
        this.roleFolder = FileUtils.addPrefix2FilePath(homeDir, this.roleFolder);
        this.procedureWalFolder = FileUtils.addPrefix2FilePath(homeDir, this.procedureWalFolder);
        this.syncDir = FileUtils.addPrefix2FilePath(homeDir, this.syncDir);
        for (int i = 0; i < this.walDirs.length; ++i) {
            this.walDirs[i] = FileUtils.addPrefix2FilePath(homeDir, this.walDirs[i]);
        }
    }

    public String getEncryptDecryptProvider() {
        return this.encryptDecryptProvider;
    }

    public void setEncryptDecryptProvider(String encryptDecryptProvider) {
        this.encryptDecryptProvider = encryptDecryptProvider;
    }

    public String getEncryptDecryptProviderParameter() {
        return this.encryptDecryptProviderParameter;
    }

    public void setEncryptDecryptProviderParameter(String encryptDecryptProviderParameter) {
        this.encryptDecryptProviderParameter = encryptDecryptProviderParameter;
    }

    public String getOpenIdProviderUrl() {
        return this.openIdProviderUrl;
    }

    public void setOpenIdProviderUrl(String openIdProviderUrl) {
        this.openIdProviderUrl = openIdProviderUrl;
    }

    public String getAuthorizerProvider() {
        return this.authorizerProvider;
    }

    public void setAuthorizerProvider(String authorizerProvider) {
        this.authorizerProvider = authorizerProvider;
    }

    public String getAdminName() {
        return this.adminName;
    }

    public void setAdminName(String adminName) {
        this.adminName = adminName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getUserFolder() {
        return this.userFolder;
    }

    public void setUserFolder(String userFolder) {
        this.userFolder = userFolder;
    }

    public String getRoleFolder() {
        return this.roleFolder;
    }

    public void setRoleFolder(String roleFolder) {
        this.roleFolder = roleFolder;
    }

    public String getProcedureWalFolder() {
        return this.procedureWalFolder;
    }

    public void setProcedureWalFolder(String procedureWalFolder) {
        this.procedureWalFolder = procedureWalFolder;
    }

    public String getSyncDir() {
        return this.syncDir;
    }

    public void setSyncDir(String syncDir) {
        this.syncDir = syncDir;
    }

    public String[] getWalDirs() {
        return this.walDirs;
    }

    public void setWalDirs(String[] walDirs) {
        this.walDirs = walDirs;
    }

    public FSType getSystemFileStorageFs() {
        return this.systemFileStorageFs;
    }

    public void setSystemFileStorageFs(FSType systemFileStorageFs) {
        this.systemFileStorageFs = systemFileStorageFs;
    }

    public long getDefaultTTLInMs() {
        return this.tierTTLInMs[this.tierTTLInMs.length - 1];
    }

    public long[] getTierTTLInMs() {
        return this.tierTTLInMs;
    }

    public void setTierTTLInMs(long[] tierTTLInMs) {
        this.tierTTLInMs = tierTTLInMs;
    }

    public int getConnectionTimeoutInMS() {
        return this.connectionTimeoutInMS;
    }

    public void setConnectionTimeoutInMS(int connectionTimeoutInMS) {
        this.connectionTimeoutInMS = connectionTimeoutInMS;
    }

    public int getSelectorNumOfClientManager() {
        return this.selectorNumOfClientManager;
    }

    public void setSelectorNumOfClientManager(int selectorNumOfClientManager) {
        this.selectorNumOfClientManager = selectorNumOfClientManager;
    }

    public boolean isRpcThriftCompressionEnabled() {
        return this.isRpcThriftCompressionEnabled;
    }

    public void setRpcThriftCompressionEnabled(boolean rpcThriftCompressionEnabled) {
        this.isRpcThriftCompressionEnabled = rpcThriftCompressionEnabled;
    }

    public int getMaxClientNumForEachNode() {
        return this.maxClientNumForEachNode;
    }

    public void setMaxClientNumForEachNode(int maxClientNumForEachNode) {
        this.maxClientNumForEachNode = maxClientNumForEachNode;
    }

    public int getCoreClientNumForEachNode() {
        return this.coreClientNumForEachNode;
    }

    public void setCoreClientNumForEachNode(int coreClientNumForEachNode) {
        this.coreClientNumForEachNode = coreClientNumForEachNode;
    }

    HandleSystemErrorStrategy getHandleSystemErrorStrategy() {
        return this.handleSystemErrorStrategy;
    }

    void setHandleSystemErrorStrategy(HandleSystemErrorStrategy handleSystemErrorStrategy) {
        this.handleSystemErrorStrategy = handleSystemErrorStrategy;
    }

    public void handleUnrecoverableError() {
        this.handleSystemErrorStrategy.handle();
    }

    public double getDiskSpaceWarningThreshold() {
        return this.diskSpaceWarningThreshold;
    }

    public void setDiskSpaceWarningThreshold(double diskSpaceWarningThreshold) {
        this.diskSpaceWarningThreshold = diskSpaceWarningThreshold;
    }

    public boolean isReadOnly() {
        return this.status == NodeStatus.ReadOnly;
    }

    public NodeStatus getNodeStatus() {
        return this.status;
    }

    public void setNodeStatus(NodeStatus newStatus) {
        logger.info("Set system mode from {} to {}.", (Object)this.status, (Object)newStatus);
        this.status = newStatus;
        this.statusReason = null;
        switch (newStatus) {
            case ReadOnly: {
                logger.warn("Change system status to ReadOnly! Only query statements are permitted!");
                break;
            }
            case Removing: {
                logger.info("Change system status to Removing! The current Node is being removed from cluster!");
                break;
            }
        }
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public NodeStatus getStatus() {
        return this.status;
    }

    public void setStatus(NodeStatus status) {
        this.status = status;
    }

    public TEndPoint getTargetMLNodeEndPoint() {
        return this.targetMLNodeEndPoint;
    }

    public void setTargetMLNodeEndPoint(TEndPoint targetMLNodeEndPoint) {
        this.targetMLNodeEndPoint = targetMLNodeEndPoint;
    }

    public int getTTimePartitionSlotTransmitLimit() {
        return 1000;
    }

    public boolean isStopping() {
        return this.isStopping;
    }

    public void setStopping(boolean stopping) {
        this.isStopping = stopping;
    }

    public long getTimePartitionInterval() {
        return this.timePartitionInterval;
    }

    public void setTimePartitionInterval(long timePartitionInterval) {
        this.timePartitionInterval = timePartitionInterval;
    }

    public void setTimestampPrecision(String timestampPrecision) {
        if (!("ms".equals(timestampPrecision) || "us".equals(timestampPrecision) || "ns".equals(timestampPrecision))) {
            logger.error("Wrong timestamp precision, please set as: ms, us or ns ! Current is: {}", (Object)timestampPrecision);
            System.exit(-1);
        }
        this.timestampPrecision = timestampPrecision;
    }

    public String getTimestampPrecision() {
        return this.timestampPrecision;
    }

    public String getPipeHardlinkBaseDirName() {
        return this.pipeHardlinkBaseDirName;
    }

    public void setPipeHardlinkBaseDirName(String pipeHardlinkBaseDirName) {
        this.pipeHardlinkBaseDirName = pipeHardlinkBaseDirName;
    }

    public String getPipeHardlinkTsFileDirName() {
        return this.pipeHardlinkTsFileDirName;
    }

    public void setPipeHardlinkTsFileDirName(String pipeTsFileDirName) {
        this.pipeHardlinkTsFileDirName = pipeTsFileDirName;
    }

    public String getPipeHardlinkWALDirName() {
        return this.pipeHardlinkWALDirName;
    }

    public void setPipeHardlinkWALDirName(String pipeWALDirName) {
        this.pipeHardlinkWALDirName = pipeWALDirName;
    }

    public boolean getPipeHardLinkWALEnabled() {
        return this.pipeHardLinkWALEnabled;
    }

    public void setPipeHardLinkWALEnabled(boolean pipeHardLinkWALEnabled) {
        this.pipeHardLinkWALEnabled = pipeHardLinkWALEnabled;
    }

    public int getPipeDataStructureTabletRowSize() {
        return this.pipeDataStructureTabletRowSize;
    }

    public void setPipeDataStructureTabletRowSize(int pipeDataStructureTabletRowSize) {
        this.pipeDataStructureTabletRowSize = pipeDataStructureTabletRowSize;
    }

    public int getPipeExtractorAssignerDisruptorRingBufferSize() {
        return this.pipeExtractorAssignerDisruptorRingBufferSize;
    }

    public void setPipeExtractorAssignerDisruptorRingBufferSize(int pipeExtractorAssignerDisruptorRingBufferSize) {
        this.pipeExtractorAssignerDisruptorRingBufferSize = pipeExtractorAssignerDisruptorRingBufferSize;
    }

    public int getPipeExtractorMatcherCacheSize() {
        return this.pipeExtractorMatcherCacheSize;
    }

    public void setPipeExtractorMatcherCacheSize(int pipeExtractorMatcherCacheSize) {
        this.pipeExtractorMatcherCacheSize = pipeExtractorMatcherCacheSize;
    }

    public int getPipeExtractorPendingQueueCapacity() {
        return this.pipeExtractorPendingQueueCapacity;
    }

    public void setPipeExtractorPendingQueueCapacity(int pipeExtractorPendingQueueCapacity) {
        this.pipeExtractorPendingQueueCapacity = pipeExtractorPendingQueueCapacity;
    }

    public int getPipeExtractorPendingQueueTabletLimit() {
        return this.pipeExtractorPendingQueueTabletLimit;
    }

    public void setPipeExtractorPendingQueueTabletLimit(int pipeExtractorPendingQueueTabletLimit) {
        this.pipeExtractorPendingQueueTabletLimit = pipeExtractorPendingQueueTabletLimit;
    }

    public long getPipeConnectorTimeoutMs() {
        return this.pipeConnectorTimeoutMs;
    }

    public void setPipeConnectorTimeoutMs(long pipeConnectorTimeoutMs) {
        this.pipeConnectorTimeoutMs = pipeConnectorTimeoutMs;
    }

    public int getPipeConnectorReadFileBufferSize() {
        return this.pipeConnectorReadFileBufferSize;
    }

    public void setPipeConnectorReadFileBufferSize(int pipeConnectorReadFileBufferSize) {
        this.pipeConnectorReadFileBufferSize = pipeConnectorReadFileBufferSize;
    }

    public void setPipeConnectorRPCThriftCompressionEnabled(boolean pipeConnectorRPCThriftCompressionEnabled) {
        this.pipeConnectorRPCThriftCompressionEnabled = pipeConnectorRPCThriftCompressionEnabled;
    }

    public boolean isPipeConnectorRPCThriftCompressionEnabled() {
        return this.pipeConnectorRPCThriftCompressionEnabled;
    }

    public int getPipeAsyncConnectorSelectorNumber() {
        return this.pipeAsyncConnectorSelectorNumber;
    }

    public void setPipeAsyncConnectorSelectorNumber(int pipeAsyncConnectorSelectorNumber) {
        this.pipeAsyncConnectorSelectorNumber = pipeAsyncConnectorSelectorNumber;
    }

    public int getPipeAsyncConnectorCoreClientNumber() {
        return this.pipeAsyncConnectorCoreClientNumber;
    }

    public void setPipeAsyncConnectorCoreClientNumber(int pipeAsyncConnectorCoreClientNumber) {
        this.pipeAsyncConnectorCoreClientNumber = pipeAsyncConnectorCoreClientNumber;
    }

    public int getPipeAsyncConnectorMaxClientNumber() {
        return this.pipeAsyncConnectorMaxClientNumber;
    }

    public void setPipeAsyncConnectorMaxClientNumber(int pipeAsyncConnectorMaxClientNumber) {
        this.pipeAsyncConnectorMaxClientNumber = pipeAsyncConnectorMaxClientNumber;
    }

    public boolean isSeperatedPipeHeartbeatEnabled() {
        return this.isSeperatedPipeHeartbeatEnabled;
    }

    public void setSeperatedPipeHeartbeatEnabled(boolean isSeperatedPipeHeartbeatEnabled) {
        this.isSeperatedPipeHeartbeatEnabled = isSeperatedPipeHeartbeatEnabled;
    }

    public int getPipeHeartbeatIntervalSecondsForCollectingPipeMeta() {
        return this.pipeHeartbeatIntervalSecondsForCollectingPipeMeta;
    }

    public void setPipeHeartbeatIntervalSecondsForCollectingPipeMeta(int pipeHeartbeatIntervalSecondsForCollectingPipeMeta) {
        this.pipeHeartbeatIntervalSecondsForCollectingPipeMeta = pipeHeartbeatIntervalSecondsForCollectingPipeMeta;
    }

    public long getPipeMetaSyncerInitialSyncDelayMinutes() {
        return this.pipeMetaSyncerInitialSyncDelayMinutes;
    }

    public void setPipeMetaSyncerInitialSyncDelayMinutes(long pipeMetaSyncerInitialSyncDelayMinutes) {
        this.pipeMetaSyncerInitialSyncDelayMinutes = pipeMetaSyncerInitialSyncDelayMinutes;
    }

    public long getPipeMetaSyncerSyncIntervalMinutes() {
        return this.pipeMetaSyncerSyncIntervalMinutes;
    }

    public void setPipeMetaSyncerSyncIntervalMinutes(long pipeMetaSyncerSyncIntervalMinutes) {
        this.pipeMetaSyncerSyncIntervalMinutes = pipeMetaSyncerSyncIntervalMinutes;
    }

    public long getPipeMetaSyncerAutoRestartPipeCheckIntervalRound() {
        return this.pipeMetaSyncerAutoRestartPipeCheckIntervalRound;
    }

    public void setPipeMetaSyncerAutoRestartPipeCheckIntervalRound(long pipeMetaSyncerAutoRestartPipeCheckIntervalRound) {
        this.pipeMetaSyncerAutoRestartPipeCheckIntervalRound = pipeMetaSyncerAutoRestartPipeCheckIntervalRound;
    }

    public boolean getPipeAutoRestartEnabled() {
        return this.pipeAutoRestartEnabled;
    }

    public void setPipeAutoRestartEnabled(boolean pipeAutoRestartEnabled) {
        this.pipeAutoRestartEnabled = pipeAutoRestartEnabled;
    }

    public long getPipeConnectorRetryIntervalMs() {
        return this.pipeConnectorRetryIntervalMs;
    }

    public void setPipeConnectorRetryIntervalMs(long pipeConnectorRetryIntervalMs) {
        this.pipeConnectorRetryIntervalMs = pipeConnectorRetryIntervalMs;
    }

    public int getPipeConnectorPendingQueueSize() {
        return this.pipeConnectorPendingQueueSize;
    }

    public void setPipeConnectorPendingQueueSize(int pipeConnectorPendingQueueSize) {
        this.pipeConnectorPendingQueueSize = pipeConnectorPendingQueueSize;
    }

    public int getPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount() {
        return this.pipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount;
    }

    public void setPipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount(int pipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount) {
        this.pipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount = pipeSubtaskExecutorBasicCheckPointIntervalByConsumedEventCount;
    }

    public long getPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration() {
        return this.pipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration;
    }

    public void setPipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration(long pipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration) {
        this.pipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration = pipeSubtaskExecutorBasicCheckPointIntervalByTimeDuration;
    }

    public int getPipeSubtaskExecutorMaxThreadNum() {
        return this.pipeSubtaskExecutorMaxThreadNum;
    }

    public void setPipeSubtaskExecutorMaxThreadNum(int pipeSubtaskExecutorMaxThreadNum) {
        this.pipeSubtaskExecutorMaxThreadNum = Math.min(pipeSubtaskExecutorMaxThreadNum, Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
    }

    public long getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs() {
        return this.pipeSubtaskExecutorPendingQueueMaxBlockingTimeMs;
    }

    public void setPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs(long pipeSubtaskExecutorPendingQueueMaxBlockingTimeMs) {
        this.pipeSubtaskExecutorPendingQueueMaxBlockingTimeMs = pipeSubtaskExecutorPendingQueueMaxBlockingTimeMs;
    }

    public void setPipeAirGapReceiverEnabled(boolean pipeAirGapReceiverEnabled) {
        this.pipeAirGapReceiverEnabled = pipeAirGapReceiverEnabled;
    }

    public boolean getPipeAirGapReceiverEnabled() {
        return this.pipeAirGapReceiverEnabled;
    }

    public void setPipeAirGapReceiverPort(int pipeAirGapReceiverPort) {
        this.pipeAirGapReceiverPort = pipeAirGapReceiverPort;
    }

    public int getPipeAirGapReceiverPort() {
        return this.pipeAirGapReceiverPort;
    }

    public String getSchemaEngineMode() {
        return this.schemaEngineMode;
    }

    public void setSchemaEngineMode(String schemaEngineMode) {
        this.schemaEngineMode = schemaEngineMode;
    }

    public boolean isLastCacheEnable() {
        return this.lastCacheEnable;
    }

    public void setLastCacheEnable(boolean lastCacheEnable) {
        this.lastCacheEnable = lastCacheEnable;
    }

    public int getTagAttributeTotalSize() {
        return this.tagAttributeTotalSize;
    }

    public void setTagAttributeTotalSize(int tagAttributeTotalSize) {
        this.tagAttributeTotalSize = tagAttributeTotalSize;
    }

    public int getDatabaseLimitThreshold() {
        return this.databaseLimitThreshold;
    }

    public void setDatabaseLimitThreshold(int databaseLimitThreshold) {
        this.databaseLimitThreshold = databaseLimitThreshold;
    }
}

