/*
 * Decompiled with CFR 0.152.
 */
package com.github.ggalmazor.ltdownsampling;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;

public class Point {
    private static final MathContext MC = MathContext.UNLIMITED;
    private final BigDecimal x;
    private final BigDecimal y;

    public Point(BigDecimal x, BigDecimal y) {
        this.x = x;
        this.y = y;
    }

    public static Point of(Number x, Number y) {
        return new Point(Point.toBigDecimal(x), Point.toBigDecimal(y));
    }

    private static BigDecimal toBigDecimal(Number number) {
        return new BigDecimal(number.doubleValue(), MC);
    }

    public BigDecimal getX() {
        return this.x;
    }

    public BigDecimal getY() {
        return this.y;
    }

    protected Point add(Point other) {
        return new Point(this.x.add(other.x), this.y.add(other.y));
    }

    protected Point subtract(Point other) {
        return new Point(this.x.subtract(other.x), this.y.subtract(other.y));
    }

    protected Point divide(Number divisor) {
        return new Point(this.x.divide(Point.toBigDecimal(divisor), MC), this.y.divide(Point.toBigDecimal(divisor), MC));
    }

    public String toString() {
        return '(' + this.x.toString() + ',' + this.y.toString() + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Point point = (Point)o;
        return Objects.equals(this.x, point.x) && Objects.equals(this.y, point.y);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }
}

