/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.validator;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.validator.CompactionValidator;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class ResourceAndTsfileCompactionValidator
implements CompactionValidator {
    private ResourceAndTsfileCompactionValidator() {
    }

    public static ResourceAndTsfileCompactionValidator getInstance() {
        return ResourceAndTsfileCompactionValidatorHolder.INSTANCE;
    }

    @Override
    public boolean validateCompaction(TsFileManager manager, List<TsFileResource> targetTsFileList, String storageGroupName, long timePartition, boolean isInnerUnSequenceSpaceTask) throws IOException {
        if (isInnerUnSequenceSpaceTask) {
            return CompactionUtils.validateTsFiles(targetTsFileList);
        }
        return CompactionUtils.validateTsFileResources(manager, storageGroupName, timePartition) && CompactionUtils.validateTsFiles(targetTsFileList);
    }

    private static class ResourceAndTsfileCompactionValidatorHolder {
        private static final ResourceAndTsfileCompactionValidator INSTANCE = new ResourceAndTsfileCompactionValidator();

        private ResourceAndTsfileCompactionValidatorHolder() {
        }
    }
}

