/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.lang.reflect.InvocationTargetException;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.exception.runtime.RPCServiceException;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.service.ThriftService;
import org.apache.iotdb.commons.service.ThriftServiceThread;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.protocol.thrift.handler.MLNodeRPCServiceThriftHandler;
import org.apache.iotdb.db.protocol.thrift.impl.MLNodeRPCServiceImpl;
import org.apache.iotdb.db.service.MLNodeRPCServiceMBean;
import org.apache.iotdb.mpp.rpc.thrift.IMLNodeInternalRPCService;
import org.apache.thrift.server.TServerEventHandler;

public class MLNodeRPCService
extends ThriftService
implements MLNodeRPCServiceMBean {
    private MLNodeRPCServiceImpl impl;

    private MLNodeRPCService() {
    }

    public ServiceType getID() {
        return ServiceType.MLNode_RPC_SERVICE;
    }

    public void initTProcessor() throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        this.impl = new MLNodeRPCServiceImpl();
        this.initSyncedServiceImpl(null);
        this.processor = new IMLNodeInternalRPCService.Processor((IMLNodeInternalRPCService.Iface)this.impl);
    }

    public void initThriftServiceThread() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        try {
            IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
            this.thriftServiceThread = new ThriftServiceThread(this.processor, this.getID().getName(), ThreadName.MLNODE_RPC_SERVICE.getName(), this.getBindIP(), this.getBindPort(), config.getRpcMaxConcurrentClientNum(), config.getThriftServerAwaitTimeForStopService(), (TServerEventHandler)new MLNodeRPCServiceThriftHandler(this.impl), false);
        }
        catch (RPCServiceException e) {
            throw new IllegalAccessException(e.getMessage());
        }
        this.thriftServiceThread.setName(ThreadName.MLNODE_RPC_SERVICE.getName());
    }

    public String getBindIP() {
        return IoTDBDescriptor.getInstance().getConfig().getRpcAddress();
    }

    public int getBindPort() {
        return IoTDBDescriptor.getInstance().getConfig().getMLNodePort();
    }

    public static MLNodeRPCService getInstance() {
        return MLNodeRPCServiceHolder.INSTANCE;
    }

    private static class MLNodeRPCServiceHolder {
        private static final MLNodeRPCService INSTANCE = new MLNodeRPCService();

        private MLNodeRPCServiceHolder() {
        }
    }
}

