/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.process;

import com.google.common.base.Objects;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.OrderByParameter;

public class SortNode
extends SingleChildProcessNode {
    private final OrderByParameter orderByParameter;

    public SortNode(PlanNodeId id, PlanNode child, OrderByParameter orderByParameter) {
        super(id, child);
        this.orderByParameter = orderByParameter;
    }

    public SortNode(PlanNodeId id, OrderByParameter orderByParameter) {
        super(id);
        this.orderByParameter = orderByParameter;
    }

    public OrderByParameter getOrderByParameter() {
        return this.orderByParameter;
    }

    @Override
    public PlanNode clone() {
        return new SortNode(this.getPlanNodeId(), this.child, this.orderByParameter);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.child.getOutputColumnNames();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSort(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.SORT.serialize(byteBuffer);
        this.orderByParameter.serializeAttributes(byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.SORT.serialize(stream);
        this.orderByParameter.serializeAttributes(stream);
    }

    public static SortNode deserialize(ByteBuffer byteBuffer) {
        OrderByParameter orderByParameter = OrderByParameter.deserialize(byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new SortNode(planNodeId, orderByParameter);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SortNode sortNode = (SortNode)o;
        return Objects.equal((Object)this.orderByParameter, (Object)sortNode.orderByParameter);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.orderByParameter});
    }
}

