/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.executor;

import com.google.common.util.concurrent.SettableFuture;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSetSpaceQuotaReq;
import org.apache.iotdb.common.rpc.thrift.TSetTTLReq;
import org.apache.iotdb.common.rpc.thrift.TSetThrottleQuotaReq;
import org.apache.iotdb.common.rpc.thrift.TSpaceQuota;
import org.apache.iotdb.common.rpc.thrift.TThrottleQuota;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.executable.ExecutableManager;
import org.apache.iotdb.commons.executable.ExecutableResource;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.pipe.plugin.service.PipePluginClassLoader;
import org.apache.iotdb.commons.pipe.plugin.service.PipePluginExecutableManager;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.trigger.service.TriggerExecutableManager;
import org.apache.iotdb.commons.udf.service.UDFClassLoader;
import org.apache.iotdb.commons.udf.service.UDFExecutableManager;
import org.apache.iotdb.confignode.rpc.thrift.TAlterLogicalViewReq;
import org.apache.iotdb.confignode.rpc.thrift.TAlterSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TCountDatabaseResp;
import org.apache.iotdb.confignode.rpc.thrift.TCountTimeSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TCountTimeSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TCreateCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateModelReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipePluginReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchemaResp;
import org.apache.iotdb.confignode.rpc.thrift.TDeactivateSchemaTemplateReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteDatabasesReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteLogicalViewReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteTimeSeriesReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropModelReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropPipePluginReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropTriggerReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetPipePluginTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetRegionIdReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetRegionIdResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetSeriesSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetSeriesSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTimeSlotListReq;
import org.apache.iotdb.confignode.rpc.thrift.TGetTimeSlotListResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTriggerTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetUDFTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TMigrateRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowCQResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowClusterResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowConfigNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowDataNodesResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowDatabaseResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowModelReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowModelResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowThrottleReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowTrailReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowTrailResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowVariablesResp;
import org.apache.iotdb.confignode.rpc.thrift.TSpaceQuotaResp;
import org.apache.iotdb.confignode.rpc.thrift.TThrottleQuotaResp;
import org.apache.iotdb.confignode.rpc.thrift.TUnsetSchemaTemplateReq;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.BatchProcessException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.protocol.client.DataNodeClientPoolFactory;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.Analyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.CountDatabaseTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.CountTimeSlotListTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.DatabaseSchemaTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.GetRegionIdTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.GetSeriesSlotListTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.GetTimeSlotListTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowClusterDetailsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowClusterTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowConfigNodesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowContinuousQueriesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowDataNodesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowFunctionsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowPipePluginsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowRegionTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowTTLTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowTriggersTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ShowVariablesTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.model.ShowModelsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.model.ShowTrailsTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.template.ShowNodesInSchemaTemplateTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.template.ShowPathSetTemplateTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.template.ShowSchemaTemplateTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.pipe.ShowPipeTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.quota.ShowSpaceQuotaTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.sys.quota.ShowThrottleQuotaTask;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.TransformToViewExpressionVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountDatabaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountTimeSlotListStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateContinuousQueryStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateFunctionStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreatePipePluginStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateTriggerStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DatabaseSchemaStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DeleteDatabaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DeleteTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.GetRegionIdStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.GetSeriesSlotListStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.GetTimeSlotListStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.MigrateRegionStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.SetTTLStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowClusterStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowDataNodesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowDatabaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowRegionStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowTTLStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.model.CreateModelStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.AlterSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.CreateSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.DeactivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.DropSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.SetSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowNodesInSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowPathSetTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ShowSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.UnsetSchemaTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.AlterLogicalViewStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.CreateLogicalViewStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.DeleteLogicalViewStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.RenameLogicalViewStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.KillQueryStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.pipe.CreatePipeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.pipe.DropPipeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.pipe.ShowPipesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.pipe.StartPipeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.pipe.StopPipeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.quota.SetSpaceQuotaStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.quota.SetThrottleQuotaStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.quota.ShowSpaceQuotaStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.quota.ShowThrottleQuotaStatement;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.schemaengine.template.TemplateAlterOperationType;
import org.apache.iotdb.db.schemaengine.template.alter.TemplateAlterOperationUtil;
import org.apache.iotdb.db.schemaengine.template.alter.TemplateExtendInfo;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.trigger.service.TriggerClassLoader;
import org.apache.iotdb.pipe.api.PipePlugin;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.trigger.api.Trigger;
import org.apache.iotdb.trigger.api.enums.FailureStrategy;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConfigTaskExecutor
implements IConfigTaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterConfigTaskExecutor.class);
    private static final IClientManager<ConfigRegionId, ConfigNodeClient> CONFIG_NODE_CLIENT_MANAGER = ConfigNodeClientManager.getInstance();
    private static final IClientManager<ConfigRegionId, ConfigNodeClient> CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER = new IClientManager.Factory().createClientManager((IClientPoolFactory)new DataNodeClientPoolFactory.ClusterDeletionConfigNodeClientPoolFactory());

    public static ClusterConfigTaskExecutor getInstance() {
        return ClusterConfigTaskExecutorHolder.INSTANCE;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setDatabase(DatabaseSchemaStatement databaseSchemaStatement) {
        SettableFuture future = SettableFuture.create();
        TDatabaseSchema databaseSchema = DatabaseSchemaTask.constructDatabaseSchema(databaseSchemaStatement);
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = configNodeClient.setDatabase(databaseSchema);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                if (TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode() == tsStatus.getCode() && !databaseSchemaStatement.getEnablePrintExceptionLog()) {
                    future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
                } else {
                    LOGGER.warn("Failed to execute create database {} in config node, status is {}.", (Object)databaseSchemaStatement.getDatabasePath(), (Object)tsStatus);
                    future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
                }
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> alterDatabase(DatabaseSchemaStatement databaseSchemaStatement) {
        SettableFuture future = SettableFuture.create();
        TDatabaseSchema databaseSchema = DatabaseSchemaTask.constructDatabaseSchema(databaseSchemaStatement);
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = configNodeClient.alterDatabase(databaseSchema);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                if (databaseSchemaStatement.getEnablePrintExceptionLog()) {
                    LOGGER.warn("Failed to execute alter database {} in config node, status is {}.", (Object)databaseSchemaStatement.getDatabasePath(), (Object)tsStatus);
                }
                future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showDatabase(ShowDatabaseStatement showDatabaseStatement) {
        SettableFuture future = SettableFuture.create();
        List<String> databasePathPattern = Arrays.asList(showDatabaseStatement.getPathPattern().getNodes());
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TShowDatabaseResp resp = client.showDatabase(databasePathPattern);
            showDatabaseStatement.buildTSBlock(resp.getDatabaseInfoMap(), (SettableFuture<ConfigTaskResult>)future);
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> countDatabase(CountDatabaseStatement countDatabaseStatement) {
        SettableFuture future = SettableFuture.create();
        List<String> databasePathPattern = Arrays.asList(countDatabaseStatement.getPathPattern().getNodes());
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TCountDatabaseResp resp = client.countMatchedDatabases(databasePathPattern);
            int databaseNum = resp.getCount();
            CountDatabaseTask.buildTSBlock(databaseNum, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> deleteDatabase(DeleteDatabaseStatement deleteDatabaseStatement) {
        SettableFuture future = SettableFuture.create();
        TDeleteDatabasesReq req = new TDeleteDatabasesReq(deleteDatabaseStatement.getPrefixPath());
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = client.deleteDatabases(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute delete database {} in config node, status is {}.", deleteDatabaseStatement.getPrefixPath(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> createFunction(CreateFunctionStatement createFunctionStatement) {
        SettableFuture future = SettableFuture.create();
        String udfName = createFunctionStatement.getUdfName();
        String className = createFunctionStatement.getClassName();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TCreateFunctionReq tCreateFunctionReq = new TCreateFunctionReq(udfName, className, false);
            String libRoot = UDFExecutableManager.getInstance().getLibRoot();
            if (createFunctionStatement.isUsingURI()) {
                String jarMd5;
                ByteBuffer jarFile;
                String jarFileName;
                block27: {
                    URI uri;
                    String uriString = createFunctionStatement.getUriString();
                    if (uriString == null || uriString.isEmpty()) {
                        future.setException((Throwable)new IoTDBException("URI is empty, please specify the URI.", TSStatusCode.UDF_DOWNLOAD_ERROR.getStatusCode()));
                        SettableFuture settableFuture = future;
                        return settableFuture;
                    }
                    jarFileName = new File(uriString).getName();
                    try {
                        uri = new URI(uriString);
                        if (uri.getScheme() == null) {
                            future.setException((Throwable)new IoTDBException("The scheme of URI is not set, please specify the scheme of URI.", TSStatusCode.UDF_DOWNLOAD_ERROR.getStatusCode()));
                            SettableFuture settableFuture = future;
                            return settableFuture;
                        }
                    }
                    catch (IOException | URISyntaxException e) {
                        LOGGER.warn("Failed to get executable for UDF({}) using URI: {}, the cause is: {}", new Object[]{createFunctionStatement.getUdfName(), createFunctionStatement.getUriString(), e});
                        future.setException((Throwable)new IoTDBException("Failed to get executable for UDF '" + createFunctionStatement.getUdfName() + "', please check the URI.", TSStatusCode.TRIGGER_DOWNLOAD_ERROR.getStatusCode()));
                        SettableFuture settableFuture = future;
                        if (client == null) return settableFuture;
                        client.close();
                        return settableFuture;
                    }
                    {
                        if (!uri.getScheme().equals("file")) {
                            String jarFilePathUnderTempDir;
                            ExecutableResource resource = UDFExecutableManager.getInstance().request(Collections.singletonList(uriString));
                            libRoot = jarFilePathUnderTempDir = UDFExecutableManager.getInstance().getDirStringUnderTempRootByRequestId(resource.getRequestId()) + File.separator + jarFileName;
                            jarFile = ExecutableManager.transferToBytebuffer((String)jarFilePathUnderTempDir);
                            jarMd5 = DigestUtils.md5Hex((InputStream)Files.newInputStream(Paths.get(jarFilePathUnderTempDir, new String[0]), new OpenOption[0]));
                            break block27;
                        }
                        libRoot = new File(new URI(uriString)).getAbsolutePath();
                        jarFile = ExecutableManager.transferToBytebuffer((String)libRoot);
                        jarMd5 = DigestUtils.md5Hex((InputStream)Files.newInputStream(Paths.get(libRoot, new String[0]), new OpenOption[0]));
                    }
                }
                tCreateFunctionReq.setJarFile(jarFile);
                tCreateFunctionReq.setJarMD5(jarMd5);
                tCreateFunctionReq.setIsUsingURI(true);
                tCreateFunctionReq.setJarName(String.format("%s-%s.%s", jarFileName.substring(0, jarFileName.lastIndexOf(".")), jarMd5, jarFileName.substring(jarFileName.lastIndexOf(".") + 1)));
            }
            try (UDFClassLoader classLoader = new UDFClassLoader(libRoot);){
                Class<?> clazz = Class.forName(createFunctionStatement.getClassName(), true, (ClassLoader)classLoader);
                UDTF uDTF = (UDTF)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.warn("Failed to create function when try to create UDF({}) instance first, the cause is: {}", (Object)createFunctionStatement.getUdfName(), (Object)e);
                future.setException((Throwable)new IoTDBException("Failed to load class '" + createFunctionStatement.getClassName() + "', because it's not found in jar file: " + createFunctionStatement.getUriString(), TSStatusCode.UDF_LOAD_CLASS_ERROR.getStatusCode()));
                SettableFuture settableFuture = future;
                if (client == null) return settableFuture;
                client.close();
                return settableFuture;
            }
            TSStatus executionStatus = client.createFunction(tCreateFunctionReq);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("Failed to create function {}({}) because {}", new Object[]{udfName, className, executionStatus.getMessage()});
                future.setException((Throwable)new IoTDBException(executionStatus.message, executionStatus.code));
                return future;
            }
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            return future;
        }
        catch (IOException | ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropFunction(String udfName) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus executionStatus = client.dropFunction(new TDropFunctionReq(udfName));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("[{}] Failed to drop function {}.", (Object)executionStatus, (Object)udfName);
                future.setException((Throwable)new IoTDBException(executionStatus.message, executionStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showFunctions() {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetUDFTableResp getUDFTableResp = client.getUDFTable();
            if (getUDFTableResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(getUDFTableResp.getStatus().message, getUDFTableResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            ShowFunctionsTask.buildTsBlock(getUDFTableResp.getAllUDFInformation(), (SettableFuture<ConfigTaskResult>)future);
            return future;
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> createTrigger(CreateTriggerStatement createTriggerStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TCreateTriggerReq tCreateTriggerReq = new TCreateTriggerReq(createTriggerStatement.getTriggerName(), createTriggerStatement.getClassName(), createTriggerStatement.getTriggerEvent().getId(), createTriggerStatement.getTriggerType().getId(), createTriggerStatement.getPathPattern().serialize(), createTriggerStatement.getAttributes(), FailureStrategy.OPTIMISTIC.getId(), createTriggerStatement.isUsingURI());
            String libRoot = TriggerExecutableManager.getInstance().getLibRoot();
            if (createTriggerStatement.isUsingURI()) {
                String jarMd5;
                ByteBuffer jarFile;
                String jarFileName;
                block27: {
                    URI uri;
                    String uriString = createTriggerStatement.getUriString();
                    if (uriString == null || uriString.isEmpty()) {
                        future.setException((Throwable)new IoTDBException("URI is empty, please specify the URI.", TSStatusCode.TRIGGER_DOWNLOAD_ERROR.getStatusCode()));
                        SettableFuture settableFuture = future;
                        return settableFuture;
                    }
                    jarFileName = new File(uriString).getName();
                    try {
                        uri = new URI(uriString);
                        if (uri.getScheme() == null) {
                            future.setException((Throwable)new IoTDBException("The scheme of URI is not set, please specify the scheme of URI.", TSStatusCode.TRIGGER_DOWNLOAD_ERROR.getStatusCode()));
                            SettableFuture settableFuture = future;
                            return settableFuture;
                        }
                    }
                    catch (IOException | URISyntaxException e) {
                        LOGGER.warn("Failed to get executable for Trigger({}) using URI: {}, the cause is: {}", new Object[]{createTriggerStatement.getTriggerName(), createTriggerStatement.getUriString(), e});
                        future.setException((Throwable)new IoTDBException("Failed to get executable for Trigger '" + createTriggerStatement.getUriString() + "', please check the URI.", TSStatusCode.TRIGGER_DOWNLOAD_ERROR.getStatusCode()));
                        SettableFuture resource = future;
                        if (client == null) return resource;
                        client.close();
                        return resource;
                    }
                    {
                        if (!uri.getScheme().equals("file")) {
                            String jarFilePathUnderTempDir;
                            ExecutableResource resource = TriggerExecutableManager.getInstance().request(Collections.singletonList(uriString));
                            libRoot = jarFilePathUnderTempDir = TriggerExecutableManager.getInstance().getDirStringUnderTempRootByRequestId(resource.getRequestId()) + File.separator + jarFileName;
                            jarFile = ExecutableManager.transferToBytebuffer((String)jarFilePathUnderTempDir);
                            jarMd5 = DigestUtils.md5Hex((InputStream)Files.newInputStream(Paths.get(jarFilePathUnderTempDir, new String[0]), new OpenOption[0]));
                            break block27;
                        }
                        libRoot = new File(new URI(uriString)).getAbsolutePath();
                        jarFile = ExecutableManager.transferToBytebuffer((String)libRoot);
                        jarMd5 = DigestUtils.md5Hex((InputStream)Files.newInputStream(Paths.get(libRoot, new String[0]), new OpenOption[0]));
                    }
                }
                tCreateTriggerReq.setJarFile(jarFile);
                tCreateTriggerReq.setJarMD5(jarMd5);
                tCreateTriggerReq.setIsUsingURI(true);
                tCreateTriggerReq.setJarName(String.format("%s-%s.%s", jarFileName.substring(0, jarFileName.lastIndexOf(".")), jarMd5, jarFileName.substring(jarFileName.lastIndexOf(".") + 1)));
            }
            try (TriggerClassLoader classLoader = new TriggerClassLoader(libRoot);){
                Class<?> triggerClass = Class.forName(createTriggerStatement.getClassName(), true, classLoader);
                Trigger trigger = (Trigger)triggerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                tCreateTriggerReq.setFailureStrategy(trigger.getFailureStrategy().getId());
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.warn("Failed to create trigger when try to create trigger({}) instance first, the cause is: {}", (Object)createTriggerStatement.getTriggerName(), (Object)e);
                future.setException((Throwable)new IoTDBException("Failed to load class '" + createTriggerStatement.getClassName() + "', because it's not found in jar file: " + createTriggerStatement.getUriString(), TSStatusCode.TRIGGER_LOAD_CLASS_ERROR.getStatusCode()));
                SettableFuture settableFuture = future;
                if (client == null) return settableFuture;
                client.close();
                return settableFuture;
            }
            TSStatus executionStatus = client.createTrigger(tCreateTriggerReq);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("[{}] Failed to create trigger {}. TSStatus is {}", new Object[]{executionStatus, createTriggerStatement.getTriggerName(), executionStatus.message});
                future.setException((Throwable)new IoTDBException(executionStatus.message, executionStatus.code));
                return future;
            }
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            return future;
        }
        catch (IOException | ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropTrigger(String triggerName) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus executionStatus = client.dropTrigger(new TDropTriggerReq(triggerName));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("[{}] Failed to drop trigger {}.", (Object)executionStatus, (Object)triggerName);
                future.setException((Throwable)new IoTDBException(executionStatus.message, executionStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showTriggers() {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetTriggerTableResp getTriggerTableResp = client.getTriggerTable();
            if (getTriggerTableResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(getTriggerTableResp.getStatus().message, getTriggerTableResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            ShowTriggersTask.buildTsBlock(getTriggerTableResp.getAllTriggerInformation(), (SettableFuture<ConfigTaskResult>)future);
            return future;
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> createPipePlugin(CreatePipePluginStatement createPipePluginStatement) {
        SettableFuture future = SettableFuture.create();
        String pluginName = createPipePluginStatement.getPluginName();
        String className = createPipePluginStatement.getClassName();
        String uriString = createPipePluginStatement.getUriString();
        if (uriString == null || uriString.isEmpty()) {
            future.setException((Throwable)new IoTDBException("Failed to create pipe plugin, because the URI is empty.", TSStatusCode.PIPE_PLUGIN_DOWNLOAD_ERROR.getStatusCode()));
            return future;
        }
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            String jarMd5;
            ByteBuffer jarFile;
            String libRoot;
            String jarFileName;
            block25: {
                URI uri;
                jarFileName = new File(uriString).getName();
                try {
                    uri = new URI(uriString);
                    if (uri.getScheme() == null) {
                        future.setException((Throwable)new IoTDBException("The scheme of URI is not set, please specify the scheme of URI.", TSStatusCode.PIPE_PLUGIN_DOWNLOAD_ERROR.getStatusCode()));
                        SettableFuture settableFuture = future;
                        return settableFuture;
                    }
                }
                catch (IOException | URISyntaxException e) {
                    LOGGER.warn("Failed to get executable for PipePlugin({}) using URI: {}, the cause is: {}", new Object[]{createPipePluginStatement.getPluginName(), createPipePluginStatement.getUriString(), e});
                    future.setException((Throwable)new IoTDBException("Failed to get executable for PipePlugin" + createPipePluginStatement.getPluginName() + "', please check the URI.", TSStatusCode.PIPE_PLUGIN_DOWNLOAD_ERROR.getStatusCode()));
                    SettableFuture resource = future;
                    if (client == null) return resource;
                    client.close();
                    return resource;
                }
                {
                    if (!uri.getScheme().equals("file")) {
                        String jarFilePathUnderTempDir;
                        ExecutableResource resource = PipePluginExecutableManager.getInstance().request(Collections.singletonList(uriString));
                        libRoot = jarFilePathUnderTempDir = PipePluginExecutableManager.getInstance().getDirStringUnderTempRootByRequestId(resource.getRequestId()) + File.separator + jarFileName;
                        jarFile = ExecutableManager.transferToBytebuffer((String)jarFilePathUnderTempDir);
                        jarMd5 = DigestUtils.md5Hex((InputStream)Files.newInputStream(Paths.get(jarFilePathUnderTempDir, new String[0]), new OpenOption[0]));
                        break block25;
                    }
                    libRoot = new File(new URI(uriString)).getAbsolutePath();
                    jarFile = ExecutableManager.transferToBytebuffer((String)libRoot);
                    jarMd5 = DigestUtils.md5Hex((InputStream)Files.newInputStream(Paths.get(libRoot, new String[0]), new OpenOption[0]));
                }
            }
            try (PipePluginClassLoader classLoader = new PipePluginClassLoader(libRoot);){
                Class<?> clazz = Class.forName(createPipePluginStatement.getClassName(), true, (ClassLoader)classLoader);
                PipePlugin pipePlugin = (PipePlugin)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.warn("Failed to create function when try to create PipePlugin({}) instance first, the cause is: {}", (Object)createPipePluginStatement.getPluginName(), (Object)e);
                future.setException((Throwable)new IoTDBException("Failed to load class '" + createPipePluginStatement.getClassName() + "', because it's not found in jar file: " + createPipePluginStatement.getUriString(), TSStatusCode.PIPE_PLUGIN_LOAD_CLASS_ERROR.getStatusCode()));
                SettableFuture settableFuture = future;
                if (client == null) return settableFuture;
                client.close();
                return settableFuture;
            }
            TSStatus executionStatus = client.createPipePlugin(new TCreatePipePluginReq().setPluginName(pluginName).setClassName(className).setJarFile(jarFile).setJarMD5(jarMd5).setJarName(String.format("%s-%s.%s", jarFileName.substring(0, jarFileName.lastIndexOf(".")), jarMd5, jarFileName.substring(jarFileName.lastIndexOf(".") + 1))));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("Failed to create PipePlugin {}({}) because {}", new Object[]{pluginName, className, executionStatus.getMessage()});
                future.setException((Throwable)new IoTDBException(executionStatus.message, executionStatus.code));
                return future;
            }
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            return future;
        }
        catch (IOException | ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropPipePlugin(String pluginName) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus executionStatus = client.dropPipePlugin(new TDropPipePluginReq(pluginName));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("[{}] Failed to drop pipe plugin {}.", (Object)executionStatus, (Object)pluginName);
                future.setException((Throwable)new IoTDBException(executionStatus.message, executionStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showPipePlugins() {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetPipePluginTableResp getPipePluginTableResp = client.getPipePluginTable();
            if (getPipePluginTableResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(getPipePluginTableResp.getStatus().message, getPipePluginTableResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            ShowPipePluginsTask.buildTsBlock(getPipePluginTableResp.getAllPipePluginMeta(), (SettableFuture<ConfigTaskResult>)future);
            return future;
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setTTL(SetTTLStatement setTTLStatement, String taskName) {
        SettableFuture future = SettableFuture.create();
        List<String> databasePathPattern = Arrays.asList(setTTLStatement.getDatabasePath().getNodes());
        TSetTTLReq setTTLReq = new TSetTTLReq(databasePathPattern, setTTLStatement.getTTL());
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = configNodeClient.setTTL(setTTLReq);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute {} {} in config node, status is {}.", new Object[]{taskName, setTTLStatement.getDatabasePath(), tsStatus});
                future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> merge(boolean onCluster) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                tsStatus = client.merge();
            }
            catch (ClientManagerException | TException e) {
                future.setException(e);
            }
        } else {
            try {
                StorageEngine.getInstance().mergeAll();
                tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            catch (StorageEngineException e) {
                tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
            }
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> flush(TFlushReq tFlushReq, boolean onCluster) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                tsStatus = client.flush(tFlushReq);
            }
            catch (ClientManagerException | TException e) {
                future.setException(e);
            }
        } else {
            try {
                StorageEngine.getInstance().operateFlush(tFlushReq);
                tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            catch (Exception e) {
                tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
            }
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> clearCache(boolean onCluster) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                tsStatus = client.clearCache();
            }
            catch (ClientManagerException | TException e) {
                future.setException(e);
            }
        } else {
            try {
                StorageEngine.getInstance().clearCache();
                tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            catch (Exception e) {
                tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
            }
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> loadConfiguration(boolean onCluster) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                tsStatus = client.loadConfiguration();
            }
            catch (ClientManagerException | TException e) {
                future.setException(e);
            }
        } else {
            try {
                IoTDBDescriptor.getInstance().loadHotModifiedProps();
                tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            catch (Exception e) {
                tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
            }
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new StatementExecutionException(tsStatus));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setSystemStatus(boolean onCluster, NodeStatus status) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        if (onCluster) {
            try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
                tsStatus = client.setSystemStatus(status.getStatus());
            }
            catch (ClientManagerException | TException e) {
                future.setException(e);
            }
        } else {
            try {
                CommonDescriptor.getInstance().getConfig().setNodeStatus(status);
                tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            catch (Exception e) {
                tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
            }
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new StatementExecutionException(tsStatus));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> killQuery(KillQueryStatement killQueryStatement) {
        int dataNodeId = -1;
        String queryId = killQueryStatement.getQueryId();
        if (!killQueryStatement.isKillAll()) {
            String[] splits = queryId.split("_");
            try {
                if (splits.length != 4 || (dataNodeId = Integer.parseInt(splits[3])) < 0) {
                    throw new SemanticException("Please ensure your input <queryId> is correct");
                }
            }
            catch (NumberFormatException e) {
                throw new SemanticException("Please ensure your input <queryId> is correct");
            }
        }
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus executionStatus = client.killQuery(queryId, dataNodeId);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("Failed to kill query [{}], because {}", (Object)queryId, (Object)executionStatus.message);
                future.setException((Throwable)new IoTDBException(executionStatus.message, executionStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showCluster(ShowClusterStatement showClusterStatement) {
        SettableFuture future = SettableFuture.create();
        TShowClusterResp showClusterResp = new TShowClusterResp();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            showClusterResp = client.showCluster();
        }
        catch (ClientManagerException | TException e) {
            if (showClusterResp.getConfigNodeList() == null) {
                future.setException((Throwable)new TException("Fail to connect to any config node. Please check status of ConfigNodes or logs of connected DataNode"));
            } else {
                future.setException(e);
            }
            return future;
        }
        if (showClusterStatement.isDetails()) {
            ShowClusterDetailsTask.buildTSBlock(showClusterResp, (SettableFuture<ConfigTaskResult>)future);
        } else {
            ShowClusterTask.buildTsBlock(showClusterResp, (SettableFuture<ConfigTaskResult>)future);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showClusterParameters() {
        SettableFuture future = SettableFuture.create();
        TShowVariablesResp showVariablesResp = new TShowVariablesResp();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            showVariablesResp = client.showVariables();
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        ShowVariablesTask.buildTSBlock(showVariablesResp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showTTL(ShowTTLStatement showTTLStatement) {
        SettableFuture future = SettableFuture.create();
        List<PartialPath> databasePaths = showTTLStatement.getPaths();
        HashMap<String, Long> databaseToTTL = new HashMap<String, Long>();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            if (showTTLStatement.isAll()) {
                List<String> allStorageGroupPathPattern = Arrays.asList("root", "**");
                TDatabaseSchemaResp resp = client.getMatchedDatabaseSchemas(allStorageGroupPathPattern);
                for (Map.Entry entry : resp.getDatabaseSchemaMap().entrySet()) {
                    databaseToTTL.put((String)entry.getKey(), ((TDatabaseSchema)entry.getValue()).getTTL());
                }
            } else {
                for (PartialPath databasePath : databasePaths) {
                    List<String> databasePathPattern = Arrays.asList(databasePath.getNodes());
                    TDatabaseSchemaResp resp = client.getMatchedDatabaseSchemas(databasePathPattern);
                    for (Map.Entry entry : resp.getDatabaseSchemaMap().entrySet()) {
                        if (databaseToTTL.containsKey(entry.getKey())) continue;
                        databaseToTTL.put((String)entry.getKey(), ((TDatabaseSchema)entry.getValue()).getTTL());
                    }
                }
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        ShowTTLTask.buildTSBlock(databaseToTTL, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showRegion(ShowRegionStatement showRegionStatement) {
        SettableFuture future = SettableFuture.create();
        TShowRegionResp showRegionResp = new TShowRegionResp();
        TShowRegionReq showRegionReq = new TShowRegionReq();
        showRegionReq.setConsensusGroupType(showRegionStatement.getRegionType());
        if (showRegionStatement.getStorageGroups() == null) {
            showRegionReq.setDatabases(null);
        } else {
            showRegionReq.setDatabases(showRegionStatement.getStorageGroups().stream().map(PartialPath::getFullPath).collect(Collectors.toList()));
        }
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            showRegionResp = client.showRegion(showRegionReq);
            if (showRegionResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(showRegionResp.getStatus().message, showRegionResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        if (showRegionStatement.getNodeIds() != null) {
            List regionInfos = showRegionResp.getRegionInfoList();
            regionInfos = regionInfos.stream().filter(regionInfo -> showRegionStatement.getNodeIds().contains(regionInfo.getDataNodeId())).collect(Collectors.toList());
            showRegionResp.setRegionInfoList(regionInfos);
        }
        ShowRegionTask.buildTSBlock(showRegionResp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showDataNodes(ShowDataNodesStatement showDataNodesStatement) {
        SettableFuture future = SettableFuture.create();
        TShowDataNodesResp showDataNodesResp = new TShowDataNodesResp();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            showDataNodesResp = client.showDataNodes();
            if (showDataNodesResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(showDataNodesResp.getStatus().message, showDataNodesResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        ShowDataNodesTask.buildTSBlock(showDataNodesResp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showConfigNodes() {
        SettableFuture future = SettableFuture.create();
        TShowConfigNodesResp showConfigNodesResp = new TShowConfigNodesResp();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            showConfigNodesResp = client.showConfigNodes();
            if (showConfigNodesResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(showConfigNodesResp.getStatus().message, showConfigNodesResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        ShowConfigNodesTask.buildTSBlock(showConfigNodesResp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createSchemaTemplate(CreateSchemaTemplateStatement createSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        try {
            TSStatus tsStatus = ClusterTemplateManager.getInstance().createSchemaTemplate(createSchemaTemplateStatement);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute create schema template {} in config node, status is {}.", (Object)createSchemaTemplateStatement.getName(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException(e.getCause());
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showSchemaTemplate(ShowSchemaTemplateStatement showSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        try {
            List<Template> templateList = ClusterTemplateManager.getInstance().getAllTemplates();
            ShowSchemaTemplateTask.buildTSBlock(templateList, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showNodesInSchemaTemplate(ShowNodesInSchemaTemplateStatement showNodesInSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        String req = showNodesInSchemaTemplateStatement.getTemplateName();
        try {
            Template template = ClusterTemplateManager.getInstance().getTemplate(req);
            ShowNodesInSchemaTemplateTask.buildTSBlock(template, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setSchemaTemplate(String queryId, SetSchemaTemplateStatement setSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        String templateName = setSchemaTemplateStatement.getTemplateName();
        PartialPath path = setSchemaTemplateStatement.getPath();
        try {
            ClusterTemplateManager.getInstance().setSchemaTemplate(queryId, templateName, path);
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        }
        catch (Throwable e) {
            if (e.getCause() instanceof IoTDBException) {
                future.setException(e.getCause());
            }
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showPathSetTemplate(ShowPathSetTemplateStatement showPathSetTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        String templateName = showPathSetTemplateStatement.getTemplateName();
        try {
            List<PartialPath> listPath = ClusterTemplateManager.getInstance().getPathsSetTemplate(templateName);
            ShowPathSetTemplateTask.buildTSBlock(listPath, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> deactivateSchemaTemplate(String queryId, DeactivateTemplateStatement deactivateTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        TDeactivateSchemaTemplateReq req = new TDeactivateSchemaTemplateReq();
        req.setQueryId(queryId);
        req.setTemplateName(deactivateTemplateStatement.getTemplateName());
        req.setPathPatternTree(this.serializePatternListToByteBuffer(deactivateTemplateStatement.getPathPatternList()));
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus;
            do {
                try {
                    tsStatus = client.deactivateSchemaTemplate(req);
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute deactivate schema template {} from {} in config node, status is {}.", new Object[]{deactivateTemplateStatement.getTemplateName(), deactivateTemplateStatement.getPathPatternList(), tsStatus});
                future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropSchemaTemplate(DropSchemaTemplateStatement dropSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = configNodeClient.dropSchemaTemplate(dropSchemaTemplateStatement.getTemplateName());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute drop schema template {} in config node, status is {}.", (Object)dropSchemaTemplateStatement.getTemplateName(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> alterSchemaTemplate(String queryId, AlterSchemaTemplateStatement alterSchemaTemplateStatement) {
        TemplateExtendInfo templateExtendInfo;
        String duplicateMeasurement;
        SettableFuture future = SettableFuture.create();
        if (alterSchemaTemplateStatement.getOperationType().equals((Object)TemplateAlterOperationType.EXTEND_TEMPLATE) && (duplicateMeasurement = (templateExtendInfo = (TemplateExtendInfo)alterSchemaTemplateStatement.getTemplateAlterInfo()).getFirstDuplicateMeasurement()) != null) {
            future.setException((Throwable)new MetadataException(String.format("Duplicated measurement [%s] in schema template alter request", duplicateMeasurement)));
            return future;
        }
        TAlterSchemaTemplateReq req = new TAlterSchemaTemplateReq();
        req.setQueryId(queryId);
        req.setTemplateAlterInfo(TemplateAlterOperationUtil.generateExtendTemplateReqInfo(alterSchemaTemplateStatement.getOperationType(), alterSchemaTemplateStatement.getTemplateAlterInfo()));
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus;
            do {
                try {
                    tsStatus = client.alterSchemaTemplate(req);
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to alter schema template {} in config node, status is {}.", (Object)alterSchemaTemplateStatement.getTemplateAlterInfo().getTemplateName(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    private ByteBuffer serializePatternListToByteBuffer(List<PartialPath> patternList) {
        PathPatternTree patternTree = new PathPatternTree();
        for (PartialPath pathPattern : patternList) {
            patternTree.appendPathPattern(pathPattern);
        }
        patternTree.constructTree();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            patternTree.serialize(dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    @Override
    public SettableFuture<ConfigTaskResult> unsetSchemaTemplate(String queryId, UnsetSchemaTemplateStatement unsetSchemaTemplateStatement) {
        SettableFuture future = SettableFuture.create();
        TUnsetSchemaTemplateReq req = new TUnsetSchemaTemplateReq();
        req.setQueryId(queryId);
        req.setTemplateName(unsetSchemaTemplateStatement.getTemplateName());
        req.setPath(unsetSchemaTemplateStatement.getPath().getFullPath());
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus;
            do {
                try {
                    tsStatus = client.unsetSchemaTemplate(req);
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute unset schema template {} from {} in config node, status is {}.", new Object[]{unsetSchemaTemplateStatement.getTemplateName(), unsetSchemaTemplateStatement.getPath(), tsStatus});
                future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createPipe(CreatePipeStatement createPipeStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TCreatePipeReq req = new TCreatePipeReq().setPipeName(createPipeStatement.getPipeName()).setExtractorAttributes(createPipeStatement.getExtractorAttributes()).setProcessorAttributes(createPipeStatement.getProcessorAttributes()).setConnectorAttributes(createPipeStatement.getConnectorAttributes());
            TSStatus tsStatus = configNodeClient.createPipe(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to create PIPE {} in config node, status is {}.", (Object)createPipeStatement.getPipeName(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> startPipe(StartPipeStatement startPipeStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = configNodeClient.startPipe(startPipeStatement.getPipeName());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to start PIPE {}, status is {}.", (Object)startPipeStatement.getPipeName(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropPipe(DropPipeStatement dropPipeStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = configNodeClient.dropPipe(dropPipeStatement.getPipeName());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to drop PIPE {}, status is {}.", (Object)dropPipeStatement.getPipeName(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> stopPipe(StopPipeStatement stopPipeStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus = configNodeClient.stopPipe(stopPipeStatement.getPipeName());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to stop PIPE {}, status is {}.", (Object)stopPipeStatement.getPipeName(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showPipes(ShowPipesStatement showPipesStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TShowPipeReq tShowPipeReq = new TShowPipeReq();
            if (!StringUtils.isEmpty((CharSequence)showPipesStatement.getPipeName())) {
                tShowPipeReq.setPipeName(showPipesStatement.getPipeName());
            }
            if (showPipesStatement.getWhereClause()) {
                tShowPipeReq.setWhereClause(true);
            }
            List tShowPipeInfoList = configNodeClient.showPipe(tShowPipeReq).getPipeInfoList();
            ShowPipeTask.buildTSBlock(tShowPipeInfoList, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> deleteTimeSeries(String queryId, DeleteTimeSeriesStatement deleteTimeSeriesStatement) {
        SettableFuture future = SettableFuture.create();
        TDeleteTimeSeriesReq req = new TDeleteTimeSeriesReq(queryId, this.serializePatternListToByteBuffer(deleteTimeSeriesStatement.getPathPatternList()));
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus;
            do {
                try {
                    tsStatus = client.deleteTimeSeries(req);
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute delete timeseries {} in config node, status is {}.", deleteTimeSeriesStatement.getPathPatternList(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> deleteLogicalView(String queryId, DeleteLogicalViewStatement deleteLogicalViewStatement) {
        SettableFuture future = SettableFuture.create();
        TDeleteLogicalViewReq req = new TDeleteLogicalViewReq(queryId, this.serializePatternListToByteBuffer(deleteLogicalViewStatement.getPathPatternList()));
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus;
            do {
                try {
                    tsStatus = client.deleteLogicalView(req);
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute delete view {}, status is {}.", deleteLogicalViewStatement.getPathPatternList(), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> renameLogicalView(String queryId, RenameLogicalViewStatement renameLogicalViewStatement) {
        SettableFuture future = SettableFuture.create();
        PartialPath oldName = renameLogicalViewStatement.getOldName();
        if (oldName.hasWildcard()) {
            future.setException((Throwable)new MetadataException("Rename view doesn't support path pattern with wildcard."));
            return future;
        }
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendFullPath(oldName);
        patternTree.constructTree();
        ClusterSchemaTree schemaTree = ClusterSchemaFetcher.getInstance().fetchSchema(patternTree, null);
        List measurementPathList = (List)schemaTree.searchMeasurementPaths((PartialPath)oldName).left;
        if (measurementPathList.isEmpty()) {
            future.setException((Throwable)((Object)new PathNotExistException(oldName.getFullPath())));
            return future;
        }
        LogicalViewSchema logicalViewSchema = (LogicalViewSchema)((MeasurementPath)measurementPathList.get(0)).getMeasurementSchema();
        ViewExpression viewExpression = logicalViewSchema.getExpression();
        CreateLogicalViewStatement createLogicalViewStatement = new CreateLogicalViewStatement();
        createLogicalViewStatement.setTargetFullPaths(Collections.singletonList(renameLogicalViewStatement.getNewName()));
        createLogicalViewStatement.setViewExpression(viewExpression);
        ExecutionResult executionResult = Coordinator.getInstance().execute(createLogicalViewStatement, 0L, null, "", ClusterPartitionFetcher.getInstance(), ClusterSchemaFetcher.getInstance(), IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold());
        if (executionResult.status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.setException((Throwable)new IoTDBException(executionResult.status.getMessage(), executionResult.status.getCode()));
            return future;
        }
        TDeleteLogicalViewReq req = new TDeleteLogicalViewReq(queryId, this.serializePatternListToByteBuffer(Collections.singletonList(oldName)));
        try (ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus tsStatus;
            do {
                try {
                    tsStatus = client.deleteLogicalView(req);
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute delete view {}, status is {}.", (Object)oldName, (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> alterLogicalView(String queryId, AlterLogicalViewStatement alterLogicalViewStatement) {
        SettableFuture future = SettableFuture.create();
        CreateLogicalViewStatement createLogicalViewStatement = new CreateLogicalViewStatement();
        createLogicalViewStatement.setTargetPaths(alterLogicalViewStatement.getTargetPaths());
        createLogicalViewStatement.setSourcePaths(alterLogicalViewStatement.getSourcePaths());
        createLogicalViewStatement.setQueryStatement(alterLogicalViewStatement.getQueryStatement());
        Analyzer.validate(createLogicalViewStatement);
        TransformToViewExpressionVisitor transformToViewExpressionVisitor = new TransformToViewExpressionVisitor();
        List<Expression> expressionList = createLogicalViewStatement.getSourceExpressionList();
        ArrayList<ViewExpression> viewExpressionList = new ArrayList<ViewExpression>();
        for (Expression expression : expressionList) {
            viewExpressionList.add(transformToViewExpressionVisitor.process(expression, null));
        }
        List<PartialPath> viewPathList = createLogicalViewStatement.getTargetPathList();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ReadWriteIOUtils.write((int)viewPathList.size(), (OutputStream)stream);
            for (int i = 0; i < viewPathList.size(); ++i) {
                viewPathList.get(i).serialize((OutputStream)stream);
                ViewExpression.serialize((ViewExpression)((ViewExpression)viewExpressionList.get(i)), (OutputStream)stream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        TAlterLogicalViewReq req = new TAlterLogicalViewReq(queryId, ByteBuffer.wrap(stream.toByteArray()));
        ConfigNodeClient client = (ConfigNodeClient)CLUSTER_DELETION_CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);
        try {
            TSStatus tsStatus;
            do {
                try {
                    tsStatus = client.alterLogicalView(req);
                }
                catch (TTransportException e) {
                    if (e.getType() == 3 || e.getCause() instanceof SocketTimeoutException) {
                        tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK);
                        continue;
                    }
                    throw e;
                }
            } while (TSStatusCode.OVERLAP_WITH_EXISTING_TASK.getStatusCode() == tsStatus.getCode());
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute alter view {}, status is {}.", alterLogicalViewStatement.getTargetPathList(), (Object)tsStatus);
                if (tsStatus.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    future.setException((Throwable)((Object)new BatchProcessException(tsStatus.subStatus.toArray(new TSStatus[0]))));
                } else {
                    future.setException((Throwable)new IoTDBException(tsStatus.getMessage(), tsStatus.getCode()));
                }
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
            SettableFuture settableFuture = future;
            if (client != null) {
                client.close();
            }
            return settableFuture;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClientManagerException | TException e) {
                future.setException(e);
                return future;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> getRegionId(GetRegionIdStatement getRegionIdStatement) {
        SettableFuture future = SettableFuture.create();
        TGetRegionIdResp resp = new TGetRegionIdResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetRegionIdReq tGetRegionIdReq = new TGetRegionIdReq(getRegionIdStatement.getPartitionType());
            if (getRegionIdStatement.getDevice() != null) {
                tGetRegionIdReq.setDevice(getRegionIdStatement.getDevice());
            } else {
                tGetRegionIdReq.setDatabase(getRegionIdStatement.getDatabase());
            }
            if (getRegionIdStatement.getTimeStamp() >= 0L) {
                tGetRegionIdReq.setTimeStamp(getRegionIdStatement.getTimeStamp());
            }
            if ((resp = configNodeClient.getRegionId(tGetRegionIdReq)).getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(resp.getStatus().message, resp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        GetRegionIdTask.buildTsBlock(resp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> getSeriesSlotList(GetSeriesSlotListStatement getSeriesSlotListStatement) {
        SettableFuture future = SettableFuture.create();
        TGetSeriesSlotListResp resp = new TGetSeriesSlotListResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetSeriesSlotListReq tGetSeriesSlotListReq = new TGetSeriesSlotListReq(getSeriesSlotListStatement.getDatabase(), getSeriesSlotListStatement.getPartitionType());
            resp = configNodeClient.getSeriesSlotList(tGetSeriesSlotListReq);
            if (resp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(resp.getStatus().message, resp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        GetSeriesSlotListTask.buildTsBlock(resp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> getTimeSlotList(GetTimeSlotListStatement getTimeSlotListStatement) {
        SettableFuture future = SettableFuture.create();
        TGetTimeSlotListResp resp = new TGetTimeSlotListResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TGetTimeSlotListReq tGetTimeSlotListReq = new TGetTimeSlotListReq();
            if (getTimeSlotListStatement.getDatabase() != null) {
                tGetTimeSlotListReq.setDatabase(getTimeSlotListStatement.getDatabase());
            } else if (getTimeSlotListStatement.getDevice() != null) {
                tGetTimeSlotListReq.setDevice(getTimeSlotListStatement.getDevice());
            } else if (getTimeSlotListStatement.getRegionId() != -1L) {
                tGetTimeSlotListReq.setRegionId(getTimeSlotListStatement.getRegionId());
            }
            if (getTimeSlotListStatement.getStartTime() != -1L) {
                tGetTimeSlotListReq.setStartTime(getTimeSlotListStatement.getStartTime());
            }
            if (getTimeSlotListStatement.getEndTime() != -1L) {
                tGetTimeSlotListReq.setEndTime(getTimeSlotListStatement.getEndTime());
            }
            if ((resp = configNodeClient.getTimeSlotList(tGetTimeSlotListReq)).getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(resp.getStatus().message, resp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        GetTimeSlotListTask.buildTSBlock(resp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> countTimeSlotList(CountTimeSlotListStatement countTimeSlotListStatement) {
        SettableFuture future = SettableFuture.create();
        TCountTimeSlotListResp resp = new TCountTimeSlotListResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TCountTimeSlotListReq tCountTimeSlotListReq = new TCountTimeSlotListReq();
            if (countTimeSlotListStatement.getDatabase() != null) {
                tCountTimeSlotListReq.setDatabase(countTimeSlotListStatement.getDatabase());
            } else if (countTimeSlotListStatement.getDevice() != null) {
                tCountTimeSlotListReq.setDevice(countTimeSlotListStatement.getDevice());
            } else if (countTimeSlotListStatement.getRegionId() != -1L) {
                tCountTimeSlotListReq.setRegionId(countTimeSlotListStatement.getRegionId());
            }
            if (countTimeSlotListStatement.getStartTime() != -1L) {
                tCountTimeSlotListReq.setStartTime(countTimeSlotListStatement.getStartTime());
            }
            if (countTimeSlotListStatement.getEndTime() != -1L) {
                tCountTimeSlotListReq.setEndTime(countTimeSlotListStatement.getEndTime());
            }
            if ((resp = configNodeClient.countTimeSlotList(tCountTimeSlotListReq)).getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(resp.getStatus().message, resp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        CountTimeSlotListTask.buildTSBlock(resp, (SettableFuture<ConfigTaskResult>)future);
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> migrateRegion(MigrateRegionStatement migrateRegionStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TMigrateRegionReq tMigrateRegionReq = new TMigrateRegionReq(migrateRegionStatement.getRegionId(), migrateRegionStatement.getFromId(), migrateRegionStatement.getToId());
            TSStatus status = configNodeClient.migrateRegion(tMigrateRegionReq);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(status.message, status.code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            return future;
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createContinuousQuery(CreateContinuousQueryStatement createContinuousQueryStatement, String sql, String username) {
        createContinuousQueryStatement.semanticCheck();
        String queryBody = createContinuousQueryStatement.getQueryBody();
        Analyzer.validate(createContinuousQueryStatement.getQueryBodyStatement());
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TCreateCQReq tCreateCQReq = new TCreateCQReq(createContinuousQueryStatement.getCqId(), createContinuousQueryStatement.getEveryInterval(), createContinuousQueryStatement.getBoundaryTime(), createContinuousQueryStatement.getStartTimeOffset(), createContinuousQueryStatement.getEndTimeOffset(), createContinuousQueryStatement.getTimeoutPolicy().getType(), queryBody, sql, createContinuousQueryStatement.getZoneId(), username);
            TSStatus executionStatus = client.createCQ(tCreateCQReq);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("[{}] Failed to create continuous query {}. TSStatus is {}", new Object[]{executionStatus, createContinuousQueryStatement.getCqId(), executionStatus.message});
                future.setException((Throwable)new IoTDBException(executionStatus.message, executionStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropContinuousQuery(String cqId) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus executionStatus = client.dropCQ(new TDropCQReq(cqId));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("[{}] Failed to drop continuous query {}.", (Object)executionStatus, (Object)cqId);
                future.setException((Throwable)new IoTDBException(executionStatus.message, executionStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showContinuousQueries() {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TShowCQResp showCQResp = client.showCQ();
            if (showCQResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(showCQResp.getStatus().message, showCQResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            ShowContinuousQueriesTask.buildTsBlock(showCQResp.getCqList(), (SettableFuture<ConfigTaskResult>)future);
            return future;
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setSpaceQuota(SetSpaceQuotaStatement setSpaceQuotaStatement) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        TSetSpaceQuotaReq req = new TSetSpaceQuotaReq();
        req.setDatabase(setSpaceQuotaStatement.getPrefixPathList());
        TSpaceQuota spaceQuota = new TSpaceQuota();
        spaceQuota.setDeviceNum(setSpaceQuotaStatement.getDeviceNum());
        spaceQuota.setTimeserieNum(setSpaceQuotaStatement.getTimeSeriesNum());
        spaceQuota.setDiskSize(setSpaceQuotaStatement.getDiskSize());
        req.setSpaceLimit(spaceQuota);
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            tsStatus = client.setSpaceQuota(req);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> createModel(CreateModelStatement createModelStatement) {
        createModelStatement.semanticCheck();
        Analyzer analyzer = Analyzer.getAnalyzer();
        Analysis analysis = analyzer.analyze(createModelStatement.getQueryStatement());
        ArrayList<String> queryExpressions = new ArrayList<String>();
        for (Expression expression : analysis.getSelectExpressions()) {
            queryExpressions.add(expression.getExpressionString());
        }
        Expression whereExpression = analysis.getWhereExpression();
        String queryFilter = whereExpression == null ? null : whereExpression.getExpressionString();
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TCreateModelReq createModelReq = new TCreateModelReq();
            createModelReq.setModelId(createModelStatement.getModelId());
            createModelReq.setModelTask(createModelStatement.getModelTask());
            createModelReq.setModelType(createModelStatement.getModelType());
            createModelReq.setIsAuto(createModelStatement.isAuto());
            createModelReq.setQueryExpressions(queryExpressions);
            createModelReq.setQueryFilter(queryFilter);
            createModelReq.setModelConfigs(createModelStatement.getAttributes());
            TSStatus executionStatus = client.createModel(createModelReq);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("[{}] Failed to create model {}. TSStatus is {}", new Object[]{executionStatus, createModelStatement.getModelId(), executionStatus.message});
                future.setException((Throwable)new IoTDBException(executionStatus.message, executionStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showSpaceQuota(ShowSpaceQuotaStatement showSpaceQuotaStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            ArrayList<String> databases = new ArrayList<String>();
            if (showSpaceQuotaStatement.getDatabases() != null) {
                showSpaceQuotaStatement.getDatabases().forEach(database -> databases.add(database.toString()));
            }
            TSpaceQuotaResp showSpaceQuotaResp = configNodeClient.showSpaceQuota(databases);
            ShowSpaceQuotaTask.buildTsBlock(showSpaceQuotaResp, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> setThrottleQuota(SetThrottleQuotaStatement setThrottleQuotaStatement) {
        SettableFuture future = SettableFuture.create();
        TSStatus tsStatus = new TSStatus();
        TSetThrottleQuotaReq req = new TSetThrottleQuotaReq();
        req.setUserName(setThrottleQuotaStatement.getUserName());
        TThrottleQuota throttleQuota = new TThrottleQuota();
        throttleQuota.setThrottleLimit(setThrottleQuotaStatement.getThrottleLimit());
        throttleQuota.setMemLimit(setThrottleQuotaStatement.getMemLimit());
        throttleQuota.setCpuLimit(setThrottleQuotaStatement.getCpuLimit());
        req.setThrottleQuota(throttleQuota);
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            tsStatus = client.setThrottleQuota(req);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        } else {
            future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> showThrottleQuota(ShowThrottleQuotaStatement showThrottleQuotaStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TShowThrottleReq req = new TShowThrottleReq();
            req.setUserName(showThrottleQuotaStatement.getUserName());
            TThrottleQuotaResp throttleQuotaResp = configNodeClient.showThrottleQuota(req);
            ShowThrottleQuotaTask.buildTSBlock(throttleQuotaResp, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (Exception e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public TThrottleQuotaResp getThrottleQuota() {
        TThrottleQuotaResp throttleQuotaResp = new TThrottleQuotaResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            throttleQuotaResp = configNodeClient.getThrottleQuota();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return throttleQuotaResp;
    }

    @Override
    public SettableFuture<ConfigTaskResult> dropModel(String modelId) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSStatus executionStatus = client.dropModel(new TDropModelReq(modelId));
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != executionStatus.getCode()) {
                LOGGER.warn("[{}] Failed to drop model {}.", (Object)executionStatus, (Object)modelId);
                future.setException((Throwable)new IoTDBException(executionStatus.message, executionStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showModels() {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TShowModelResp showModelResp = client.showModel(new TShowModelReq());
            if (showModelResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(showModelResp.getStatus().message, showModelResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            ShowModelsTask.buildTsBlock(showModelResp.getModelInfoList(), (SettableFuture<ConfigTaskResult>)future);
            return future;
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    @Override
    public TSpaceQuotaResp getSpaceQuota() {
        TSpaceQuotaResp spaceQuotaResp = new TSpaceQuotaResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            spaceQuotaResp = configNodeClient.getSpaceQuota();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return spaceQuotaResp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SettableFuture<ConfigTaskResult> showTrails(String modelId) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient client = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TShowTrailResp showTrailResp = client.showTrail(new TShowTrailReq(modelId));
            if (showTrailResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                future.setException((Throwable)new IoTDBException(showTrailResp.getStatus().message, showTrailResp.getStatus().code));
                SettableFuture settableFuture = future;
                return settableFuture;
            }
            ShowTrailsTask.buildTsBlock(showTrailResp.getTrailInfoList(), (SettableFuture<ConfigTaskResult>)future);
            return future;
        }
        catch (ClientManagerException | TException e) {
            future.setException(e);
        }
        return future;
    }

    private static final class ClusterConfigTaskExecutorHolder {
        private static final ClusterConfigTaskExecutor INSTANCE = new ClusterConfigTaskExecutor();

        private ClusterConfigTaskExecutorHolder() {
        }
    }
}

