/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema.source;

import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.exception.runtime.SchemaExecutionException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.IShowNodesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.SchemaRegionReadPlanFactory;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.INodeSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.ISchemaReader;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class NodeSchemaSource
implements ISchemaSource<INodeSchemaInfo> {
    private final PartialPath pathPattern;
    private final int level;

    NodeSchemaSource(PartialPath pathPattern, int level) {
        this.pathPattern = pathPattern;
        this.level = level;
    }

    @Override
    public ISchemaReader<INodeSchemaInfo> getSchemaReader(ISchemaRegion schemaRegion) {
        IShowNodesPlan showNodesPlan = -1 == this.level ? SchemaRegionReadPlanFactory.getShowNodesPlan(this.pathPattern.concatNode("*")) : SchemaRegionReadPlanFactory.getShowNodesPlan(this.pathPattern, this.level, false);
        try {
            return schemaRegion.getNodeReader(showNodesPlan);
        }
        catch (MetadataException e) {
            throw new SchemaExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<ColumnHeader> getInfoQueryColumnHeaders() {
        return ColumnHeaderConstant.showChildPathsColumnHeaders;
    }

    @Override
    public void transformToTsBlockColumns(INodeSchemaInfo nodeSchemaInfo, TsBlockBuilder tsBlockBuilder, String database) {
        tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
        tsBlockBuilder.getColumnBuilder(0).writeBinary(new Binary(nodeSchemaInfo.getFullPath()));
        tsBlockBuilder.getColumnBuilder(1).writeBinary(new Binary(String.valueOf(nodeSchemaInfo.getNodeType().getNodeType())));
        tsBlockBuilder.declarePosition();
    }

    @Override
    public boolean hasSchemaStatistic(ISchemaRegion schemaRegion) {
        return false;
    }

    @Override
    public long getSchemaStatistic(ISchemaRegion schemaRegion) {
        return 0L;
    }
}

