/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.fragment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.utils.datastructure.PatternTreeMapFactory;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;

public class QueryContext {
    private final Map<String, Map<String, List<Modification>>> filePathModCache = new ConcurrentHashMap<String, Map<String, List<Modification>>>();
    private final Map<String, PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer>> fileModCache = new HashMap<String, PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer>>();
    protected long queryId;
    private long queryTimeLowerBound = Long.MIN_VALUE;
    private boolean debug;
    private long startTime;
    private long timeout;
    private volatile boolean isInterrupted = false;

    public QueryContext() {
    }

    public QueryContext(long queryId) {
        this(queryId, false, System.currentTimeMillis(), "", 0L);
    }

    public QueryContext(long queryId, boolean debug, long startTime, String statement, long timeout) {
        this.queryId = queryId;
        this.debug = debug;
        this.startTime = startTime;
        this.timeout = timeout;
    }

    public List<Modification> getPathModifications(ModificationFile modFile, PartialPath path) {
        if (!modFile.exists()) {
            return Collections.emptyList();
        }
        Map fileModifications = this.filePathModCache.computeIfAbsent(modFile.getFilePath(), k -> new ConcurrentHashMap());
        return fileModifications.computeIfAbsent(path.getFullPath(), k -> {
            PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer> allModifications = this.fileModCache.get(modFile.getFilePath());
            if (allModifications == null) {
                allModifications = PatternTreeMapFactory.getModsPatternTreeMap();
                for (Modification modification : modFile.getModificationsIter()) {
                    allModifications.append(modification.getPath(), (Object)modification);
                }
                this.fileModCache.put(modFile.getFilePath(), allModifications);
            }
            return ModificationFile.sortAndMerge(allModifications.getOverlapped(path));
        });
    }

    public List<List<Modification>> getPathModifications(ModificationFile modFile, AlignedPath path) {
        int n = path.getMeasurementList().size();
        ArrayList<List<Modification>> ans = new ArrayList<List<Modification>>(n);
        for (int i = 0; i < n; ++i) {
            ans.add(this.getPathModifications(modFile, path.getPathWithMeasurement(i)));
        }
        return ans;
    }

    public long getQueryId() {
        return this.queryId;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public long getQueryTimeLowerBound() {
        return this.queryTimeLowerBound;
    }

    public void setQueryTimeLowerBound(long queryTimeLowerBound) {
        this.queryTimeLowerBound = queryTimeLowerBound;
    }

    public boolean chunkNotSatisfy(IChunkMetadata chunkMetaData) {
        return chunkMetaData.getEndTime() < this.queryTimeLowerBound;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public QueryContext setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public QueryContext setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public void setInterrupted(boolean interrupted) {
        this.isInterrupted = interrupted;
    }

    public boolean isInterrupted() {
        return this.isInterrupted;
    }
}

