/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.realtime.assigner;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.ThreadFactory;
import org.apache.iotdb.commons.concurrent.IoTDBDaemonThreadFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.extractor.realtime.assigner.DisruptorQueueExceptionHandler;

public class DisruptorQueue {
    private static final IoTDBDaemonThreadFactory THREAD_FACTORY = new IoTDBDaemonThreadFactory(ThreadName.PIPE_EXTRACTOR_DISRUPTOR.getName());
    private final Disruptor<EventContainer> disruptor = new Disruptor(() -> new EventContainer(), PipeConfig.getInstance().getPipeExtractorAssignerDisruptorRingBufferSize(), (ThreadFactory)THREAD_FACTORY, ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
    private final RingBuffer<EventContainer> ringBuffer;

    public DisruptorQueue(EventHandler<PipeRealtimeEvent> eventHandler) {
        this.disruptor.handleEventsWith(new EventHandler[]{(container, sequence, endOfBatch) -> eventHandler.onEvent((Object)container.getEvent(), sequence, endOfBatch)});
        this.disruptor.setDefaultExceptionHandler((ExceptionHandler)new DisruptorQueueExceptionHandler());
        this.ringBuffer = this.disruptor.start();
    }

    public void publish(PipeRealtimeEvent event) {
        this.ringBuffer.publishEvent((container, sequence, o) -> container.setEvent(event), (Object)event);
    }

    public void clear() {
        this.disruptor.halt();
    }

    private static class EventContainer {
        private PipeRealtimeEvent event;

        private EventContainer() {
        }

        public PipeRealtimeEvent getEvent() {
            return this.event;
        }

        public void setEvent(PipeRealtimeEvent event) {
            this.event = event;
        }
    }
}

