/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tablet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.IntStream;
import org.apache.iotdb.db.pipe.event.common.row.PipeRow;
import org.apache.iotdb.db.pipe.event.common.row.PipeRowCollector;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class TabletInsertionDataContainer {
    private String deviceId;
    private boolean isAligned;
    private MeasurementSchema[] measurementSchemaList;
    private String[] columnNameStringList;
    private long[] timestampColumn;
    private TSDataType[] valueColumnTypes;
    private Object[] valueColumns;
    private BitMap[] nullValueColumnBitmaps;
    private int rowCount;
    private Tablet tablet;

    public TabletInsertionDataContainer(InsertNode insertNode, String pattern) {
        if (insertNode instanceof InsertRowNode) {
            this.parse((InsertRowNode)insertNode, pattern);
        } else if (insertNode instanceof InsertTabletNode) {
            this.parse((InsertTabletNode)insertNode, pattern);
        } else {
            throw new UnSupportedDataTypeException(String.format("InsertNode type %s is not supported.", insertNode.getClass().getName()));
        }
    }

    public TabletInsertionDataContainer(Tablet tablet, boolean isAligned, String pattern) {
        this.parse(tablet, isAligned, pattern);
    }

    private void parse(InsertRowNode insertRowNode, String pattern) {
        int originColumnSize = insertRowNode.getMeasurements().length;
        Integer[] originColumnIndex2FilteredColumnIndexMapperList = new Integer[originColumnSize];
        this.deviceId = insertRowNode.getDevicePath().getFullPath();
        this.isAligned = insertRowNode.isAligned();
        this.timestampColumn = new long[]{insertRowNode.getTime()};
        this.generateColumnIndexMapper(insertRowNode.getMeasurements(), pattern, originColumnIndex2FilteredColumnIndexMapperList);
        int filteredColumnSize = Arrays.stream(originColumnIndex2FilteredColumnIndexMapperList).filter(Objects::nonNull).toArray().length;
        this.measurementSchemaList = new MeasurementSchema[filteredColumnSize];
        this.columnNameStringList = new String[filteredColumnSize];
        this.valueColumnTypes = new TSDataType[filteredColumnSize];
        this.valueColumns = new Object[filteredColumnSize];
        this.nullValueColumnBitmaps = new BitMap[filteredColumnSize];
        MeasurementSchema[] originMeasurementSchemaList = insertRowNode.getMeasurementSchemas();
        String[] originColumnNameStringList = insertRowNode.getMeasurements();
        TSDataType[] originValueColumnTypes = insertRowNode.getDataTypes();
        Object[] originValueColumns = insertRowNode.getValues();
        for (int i = 0; i < originColumnIndex2FilteredColumnIndexMapperList.length; ++i) {
            if (originColumnIndex2FilteredColumnIndexMapperList[i] == null) continue;
            int filteredColumnIndex = originColumnIndex2FilteredColumnIndexMapperList[i];
            this.measurementSchemaList[filteredColumnIndex] = originMeasurementSchemaList[i];
            this.columnNameStringList[filteredColumnIndex] = originColumnNameStringList[i];
            this.valueColumnTypes[filteredColumnIndex] = originValueColumnTypes[i];
            switch (originValueColumnTypes[i]) {
                case INT32: {
                    this.valueColumns[filteredColumnIndex] = new int[]{(Integer)originValueColumns[i]};
                    break;
                }
                case INT64: {
                    this.valueColumns[filteredColumnIndex] = new long[]{(Long)originValueColumns[i]};
                    break;
                }
                case FLOAT: {
                    this.valueColumns[filteredColumnIndex] = new float[]{((Float)originValueColumns[i]).floatValue()};
                    break;
                }
                case DOUBLE: {
                    this.valueColumns[filteredColumnIndex] = new double[]{(Double)originValueColumns[i]};
                    break;
                }
                case BOOLEAN: {
                    this.valueColumns[filteredColumnIndex] = new boolean[]{(Boolean)originValueColumns[i]};
                    break;
                }
                case TEXT: {
                    this.valueColumns[filteredColumnIndex] = new Binary[]{(Binary)originValueColumns[i]};
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", originValueColumnTypes[i].toString()));
                }
            }
            this.nullValueColumnBitmaps[filteredColumnIndex] = new BitMap(1);
        }
        this.rowCount = 1;
    }

    private void parse(InsertTabletNode insertTabletNode, String pattern) {
        int i;
        int originColumnSize = insertTabletNode.getMeasurements().length;
        Integer[] originColumnIndex2FilteredColumnIndexMapperList = new Integer[originColumnSize];
        this.deviceId = insertTabletNode.getDevicePath().getFullPath();
        this.isAligned = insertTabletNode.isAligned();
        this.timestampColumn = insertTabletNode.getTimes();
        this.generateColumnIndexMapper(insertTabletNode.getMeasurements(), pattern, originColumnIndex2FilteredColumnIndexMapperList);
        int filteredColumnSize = Arrays.stream(originColumnIndex2FilteredColumnIndexMapperList).filter(Objects::nonNull).toArray().length;
        this.measurementSchemaList = new MeasurementSchema[filteredColumnSize];
        this.columnNameStringList = new String[filteredColumnSize];
        this.valueColumnTypes = new TSDataType[filteredColumnSize];
        this.valueColumns = new Object[filteredColumnSize];
        this.nullValueColumnBitmaps = new BitMap[filteredColumnSize];
        MeasurementSchema[] originMeasurementSchemaList = insertTabletNode.getMeasurementSchemas();
        String[] originColumnNameStringList = insertTabletNode.getMeasurements();
        TSDataType[] originValueColumnTypes = insertTabletNode.getDataTypes();
        Object[] originValueColumns = insertTabletNode.getColumns();
        BitMap[] originBitMapList = insertTabletNode.getBitMaps() == null ? (BitMap[])IntStream.range(0, originColumnSize).boxed().map(o -> new BitMap(this.timestampColumn.length)).toArray(BitMap[]::new) : insertTabletNode.getBitMaps();
        for (i = 0; i < originBitMapList.length; ++i) {
            if (originBitMapList[i] != null) continue;
            originBitMapList[i] = new BitMap(this.timestampColumn.length);
        }
        for (i = 0; i < originColumnIndex2FilteredColumnIndexMapperList.length; ++i) {
            if (originColumnIndex2FilteredColumnIndexMapperList[i] == null) continue;
            int filteredColumnIndex = originColumnIndex2FilteredColumnIndexMapperList[i];
            this.measurementSchemaList[filteredColumnIndex] = originMeasurementSchemaList[i];
            this.columnNameStringList[filteredColumnIndex] = originColumnNameStringList[i];
            this.valueColumnTypes[filteredColumnIndex] = originValueColumnTypes[i];
            this.valueColumns[filteredColumnIndex] = originValueColumns[i];
            this.nullValueColumnBitmaps[filteredColumnIndex] = originBitMapList[i];
        }
        this.rowCount = this.timestampColumn.length;
    }

    private void parse(Tablet tablet, boolean isAligned, String pattern) {
        int i;
        int originColumnSize = tablet.getSchemas().size();
        Integer[] originColumnIndex2FilteredColumnIndexMapperList = new Integer[originColumnSize];
        this.deviceId = tablet.deviceId;
        this.isAligned = isAligned;
        this.timestampColumn = tablet.timestamps;
        List originMeasurementSchemaList = tablet.getSchemas();
        String[] originMeasurementList = new String[originMeasurementSchemaList.size()];
        for (int i2 = 0; i2 < originMeasurementSchemaList.size(); ++i2) {
            originMeasurementList[i2] = ((MeasurementSchema)originMeasurementSchemaList.get(i2)).getMeasurementId();
        }
        this.generateColumnIndexMapper(originMeasurementList, pattern, originColumnIndex2FilteredColumnIndexMapperList);
        int filteredColumnSize = Arrays.stream(originColumnIndex2FilteredColumnIndexMapperList).filter(Objects::nonNull).toArray().length;
        this.measurementSchemaList = new MeasurementSchema[filteredColumnSize];
        this.columnNameStringList = new String[filteredColumnSize];
        this.valueColumnTypes = new TSDataType[filteredColumnSize];
        this.valueColumns = new Object[filteredColumnSize];
        this.nullValueColumnBitmaps = new BitMap[filteredColumnSize];
        String[] originColumnNameStringList = new String[originColumnSize];
        TSDataType[] originValueColumnTypes = new TSDataType[originColumnSize];
        for (int i3 = 0; i3 < originColumnSize; ++i3) {
            originColumnNameStringList[i3] = ((MeasurementSchema)originMeasurementSchemaList.get(i3)).getMeasurementId();
            originValueColumnTypes[i3] = ((MeasurementSchema)originMeasurementSchemaList.get(i3)).getType();
        }
        Object[] originValueColumns = tablet.values;
        BitMap[] originBitMapList = tablet.bitMaps == null ? (BitMap[])IntStream.range(0, originColumnSize).boxed().map(o -> new BitMap(this.timestampColumn.length)).toArray(BitMap[]::new) : tablet.bitMaps;
        for (i = 0; i < originBitMapList.length; ++i) {
            if (originBitMapList[i] != null) continue;
            originBitMapList[i] = new BitMap(this.timestampColumn.length);
        }
        for (i = 0; i < originColumnIndex2FilteredColumnIndexMapperList.length; ++i) {
            if (originColumnIndex2FilteredColumnIndexMapperList[i] == null) continue;
            int filteredColumnIndex = originColumnIndex2FilteredColumnIndexMapperList[i];
            this.measurementSchemaList[filteredColumnIndex] = (MeasurementSchema)originMeasurementSchemaList.get(i);
            this.columnNameStringList[filteredColumnIndex] = originColumnNameStringList[i];
            this.valueColumnTypes[filteredColumnIndex] = originValueColumnTypes[i];
            this.valueColumns[filteredColumnIndex] = originValueColumns[i];
            this.nullValueColumnBitmaps[filteredColumnIndex] = originBitMapList[i];
        }
        this.rowCount = tablet.rowSize;
    }

    private void generateColumnIndexMapper(String[] originMeasurementList, String pattern, Integer[] originColumnIndex2FilteredColumnIndexMapperList) {
        block3: {
            int originColumnSize;
            block2: {
                originColumnSize = originMeasurementList.length;
                if (pattern != null && (pattern.length() > this.deviceId.length() || !this.deviceId.startsWith(pattern))) break block2;
                for (int i = 0; i < originColumnSize; ++i) {
                    originColumnIndex2FilteredColumnIndexMapperList[i] = i;
                }
                break block3;
            }
            if (pattern.length() <= this.deviceId.length() || !pattern.startsWith(this.deviceId)) break block3;
            int filteredCount = 0;
            for (int i = 0; i < originColumnSize; ++i) {
                String measurement = originMeasurementList[i];
                if (measurement == null || pattern.length() != this.deviceId.length() + measurement.length() + 1 || !pattern.endsWith("." + measurement)) continue;
                originColumnIndex2FilteredColumnIndexMapperList[i] = filteredCount++;
            }
        }
    }

    public Iterable<TabletInsertionEvent> processRowByRow(BiConsumer<Row, RowCollector> consumer) {
        if (this.valueColumns.length == 0 || this.timestampColumn.length == 0) {
            return Collections.emptyList();
        }
        PipeRowCollector rowCollector = new PipeRowCollector();
        for (int i = 0; i < this.rowCount; ++i) {
            consumer.accept(new PipeRow(i, this.deviceId, this.isAligned, this.measurementSchemaList, this.timestampColumn, this.valueColumnTypes, this.valueColumns, this.nullValueColumnBitmaps, this.columnNameStringList), rowCollector);
        }
        return rowCollector.convertToTabletInsertionEvents();
    }

    public Iterable<TabletInsertionEvent> processTablet(BiConsumer<Tablet, RowCollector> consumer) {
        PipeRowCollector rowCollector = new PipeRowCollector();
        consumer.accept(this.convertToTablet(), rowCollector);
        return rowCollector.convertToTabletInsertionEvents();
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public Tablet convertToTablet() {
        if (this.tablet != null) {
            return this.tablet;
        }
        int columnSize = this.measurementSchemaList.length;
        ArrayList<MeasurementSchema> measurementSchemaArrayList = new ArrayList<MeasurementSchema>(Arrays.asList(this.measurementSchemaList).subList(0, columnSize));
        Tablet newTablet = new Tablet(this.deviceId, measurementSchemaArrayList, this.rowCount);
        newTablet.timestamps = this.timestampColumn;
        newTablet.bitMaps = this.nullValueColumnBitmaps;
        newTablet.values = this.valueColumns;
        newTablet.rowSize = this.rowCount;
        this.tablet = newTablet;
        return this.tablet;
    }
}

