/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.session.util.SessionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IoTDBThriftConnector
implements PipeConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBThriftConnector.class);
    protected final List<TEndPoint> nodeUrls = new ArrayList<TEndPoint>();

    public void validate(PipeParameterValidator validator) throws Exception {
        PipeParameters parameters = validator.getParameters();
        validator.validate(args -> (Boolean)args[0] != false || (Boolean)args[1] != false && (Boolean)args[2] != false, String.format("Either %s or %s:%s must be specified", "connector.node-urls", "connector.ip", "connector.port"), new Object[]{parameters.hasAttribute("connector.node-urls"), parameters.hasAttribute("connector.ip"), parameters.hasAttribute("connector.port")});
    }

    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        HashSet<TEndPoint> givenNodeUrls = new HashSet<TEndPoint>(this.nodeUrls);
        if (parameters.hasAttribute("connector.ip") && parameters.hasAttribute("connector.port")) {
            givenNodeUrls.add(new TEndPoint(parameters.getString("connector.ip"), parameters.getInt("connector.port").intValue()));
        }
        if (parameters.hasAttribute("connector.node-urls")) {
            givenNodeUrls.addAll(SessionUtils.parseSeedNodeUrls(Arrays.asList(parameters.getString("connector.node-urls").split(","))));
        }
        this.nodeUrls.clear();
        this.nodeUrls.addAll(givenNodeUrls);
        LOGGER.info("IoTDBThriftConnector nodeUrls: {}", this.nodeUrls);
    }
}

