/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.receiver;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.IoTDBThriftConnectorRequestVersion;
import org.apache.iotdb.db.pipe.receiver.thrift.IoTDBThriftReceiver;
import org.apache.iotdb.db.pipe.receiver.thrift.IoTDBThriftReceiverV1;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeReceiverAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeReceiverAgent.class);
    private final ThreadLocal<IoTDBThriftReceiver> receiverThreadLocal = new ThreadLocal();

    public TPipeTransferResp receive(TPipeTransferReq req, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        byte reqVersion = req.getVersion();
        if (reqVersion == IoTDBThriftConnectorRequestVersion.VERSION_1.getVersion()) {
            return this.getReceiver(reqVersion).receive(req, partitionFetcher, schemaFetcher);
        }
        return new TPipeTransferResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_VERSION_ERROR, (String)String.format("Unsupported pipe version %d", reqVersion)));
    }

    private IoTDBThriftReceiver getReceiver(byte reqVersion) {
        if (this.receiverThreadLocal.get() == null) {
            return this.setAndGetReceiver(reqVersion);
        }
        byte receiverThreadLocalVersion = this.receiverThreadLocal.get().getVersion().getVersion();
        if (receiverThreadLocalVersion != reqVersion) {
            LOGGER.warn("The receiver version {} is different from the sender version {}, the receiver will be reset to the sender version.", (Object)receiverThreadLocalVersion, (Object)reqVersion);
            this.receiverThreadLocal.get().handleExit();
            this.receiverThreadLocal.remove();
            return this.setAndGetReceiver(reqVersion);
        }
        return this.receiverThreadLocal.get();
    }

    private IoTDBThriftReceiver setAndGetReceiver(byte reqVersion) {
        if (reqVersion != IoTDBThriftConnectorRequestVersion.VERSION_1.getVersion()) {
            throw new UnsupportedOperationException(String.format("Unsupported pipe version %d", reqVersion));
        }
        this.receiverThreadLocal.set(new IoTDBThriftReceiverV1());
        return this.receiverThreadLocal.get();
    }

    public void handleClientExit() {
        IoTDBThriftReceiver receiver = this.receiverThreadLocal.get();
        if (receiver != null) {
            receiver.handleExit();
            this.receiverThreadLocal.remove();
        }
    }

    public void cleanPipeReceiverDir() {
        File receiverFileDir = new File(IoTDBDescriptor.getInstance().getConfig().getPipeReceiverFileDir());
        try {
            FileUtils.deleteDirectory((File)receiverFileDir);
            LOGGER.info("Clean pipe receiver dir {} successfully.", (Object)receiverFileDir);
        }
        catch (Exception e) {
            LOGGER.warn("Clean pipe receiver dir {} failed.", (Object)receiverFileDir, (Object)e);
        }
        try {
            FileUtils.forceMkdir((File)receiverFileDir);
            LOGGER.info("Create pipe receiver dir {} successfully.", (Object)receiverFileDir);
        }
        catch (IOException e) {
            LOGGER.warn("Create pipe receiver dir {} failed.", (Object)receiverFileDir, (Object)e);
        }
    }
}

