/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.plugin.meta;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.pipe.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.plugin.meta.PipePluginMeta;
import org.apache.iotdb.commons.pipe.plugin.meta.PipePluginMetaKeeper;
import org.apache.iotdb.commons.pipe.plugin.service.PipePluginClassLoader;

public class DataNodePipePluginMetaKeeper
extends PipePluginMetaKeeper {
    private final Map<String, Class<?>> pipePluginNameToClassMap = new ConcurrentHashMap();

    public DataNodePipePluginMetaKeeper() {
        this.loadBuiltInPlugins();
    }

    @Override
    protected void loadBuiltInPlugins() {
        super.loadBuiltInPlugins();
        for (BuiltinPipePlugin builtinPipePlugin : BuiltinPipePlugin.values()) {
            this.addPluginAndClass(builtinPipePlugin.getPipePluginName(), builtinPipePlugin.getPipePluginClass());
        }
    }

    public void addPluginAndClass(String pluginName, Class<?> clazz) {
        this.pipePluginNameToClassMap.put(pluginName.toUpperCase(), clazz);
    }

    public Class<?> getPluginClass(String pluginName) {
        return this.pipePluginNameToClassMap.get(pluginName.toUpperCase());
    }

    public void removePluginClass(String pluginName) {
        this.pipePluginNameToClassMap.remove(pluginName.toUpperCase());
    }

    public void updatePluginClass(PipePluginMeta pipePluginMeta, PipePluginClassLoader classLoader) throws ClassNotFoundException {
        Class<?> functionClass = Class.forName(pipePluginMeta.getClassName(), true, classLoader);
        this.pipePluginNameToClassMap.put(pipePluginMeta.getPluginName().toUpperCase(), functionClass);
    }
}

