/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.config;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;

public class RatisConfig {
    private final Rpc rpc;
    private final LeaderElection leaderElection;
    private final Snapshot snapshot;
    private final ThreadPool threadPool;
    private final Log log;
    private final Grpc grpc;
    private final Client client;
    private final Impl impl;
    private final LeaderLogAppender leaderLogAppender;
    private final Read read;

    private RatisConfig(Rpc rpc, LeaderElection leaderElection, Snapshot snapshot, ThreadPool threadPool, Log log, Grpc grpc, Client client, Impl impl, LeaderLogAppender leaderLogAppender, Read read) {
        this.rpc = rpc;
        this.leaderElection = leaderElection;
        this.snapshot = snapshot;
        this.threadPool = threadPool;
        this.log = log;
        this.grpc = grpc;
        this.client = client;
        this.impl = impl;
        this.leaderLogAppender = leaderLogAppender;
        this.read = read;
    }

    public Rpc getRpc() {
        return this.rpc;
    }

    public LeaderElection getLeaderElection() {
        return this.leaderElection;
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public Log getLog() {
        return this.log;
    }

    public Grpc getGrpc() {
        return this.grpc;
    }

    public Client getClient() {
        return this.client;
    }

    public Impl getImpl() {
        return this.impl;
    }

    public LeaderLogAppender getLeaderLogAppender() {
        return this.leaderLogAppender;
    }

    public Read getRead() {
        return this.read;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Read {
        private final Option readOption;
        private final TimeDuration readTimeout;

        private Read(Option readOption, TimeDuration readTimeout) {
            this.readOption = readOption;
            this.readTimeout = readTimeout;
        }

        public Option getReadOption() {
            return this.readOption;
        }

        public TimeDuration getReadTimeout() {
            return this.readTimeout;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private Option readOption = Option.LINEARIZABLE;
            private TimeDuration readTimeout = TimeDuration.valueOf((long)10L, (TimeUnit)TimeUnit.SECONDS);

            public Builder setReadOption(Option readOption) {
                this.readOption = readOption;
                return this;
            }

            public Builder setReadTimeout(TimeDuration timeout) {
                this.readTimeout = timeout;
                return this;
            }

            public Read build() {
                return new Read(this.readOption, this.readTimeout);
            }
        }

        public static enum Option {
            DEFAULT,
            LINEARIZABLE;

        }
    }

    public static class LeaderLogAppender {
        private final SizeInBytes bufferByteLimit;
        private final SizeInBytes snapshotChunkSizeMax;
        private final boolean installSnapshotEnabled;

        private LeaderLogAppender(SizeInBytes bufferByteLimit, SizeInBytes snapshotChunkSizeMax, boolean installSnapshotEnabled) {
            this.bufferByteLimit = bufferByteLimit;
            this.snapshotChunkSizeMax = snapshotChunkSizeMax;
            this.installSnapshotEnabled = installSnapshotEnabled;
        }

        public SizeInBytes getBufferByteLimit() {
            return this.bufferByteLimit;
        }

        public SizeInBytes getSnapshotChunkSizeMax() {
            return this.snapshotChunkSizeMax;
        }

        public boolean isInstallSnapshotEnabled() {
            return this.installSnapshotEnabled;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private SizeInBytes bufferByteLimit = RaftServerConfigKeys.Log.Appender.BUFFER_BYTE_LIMIT_DEFAULT;
            private SizeInBytes snapshotChunkSizeMax = RaftServerConfigKeys.Log.Appender.SNAPSHOT_CHUNK_SIZE_MAX_DEFAULT;
            private boolean installSnapshotEnabled = true;

            public LeaderLogAppender build() {
                return new LeaderLogAppender(this.bufferByteLimit, this.snapshotChunkSizeMax, this.installSnapshotEnabled);
            }

            public Builder setBufferByteLimit(long bufferByteLimit) {
                this.bufferByteLimit = SizeInBytes.valueOf((long)bufferByteLimit);
                return this;
            }

            public Builder setSnapshotChunkSizeMax(long snapshotChunkSizeMax) {
                this.snapshotChunkSizeMax = SizeInBytes.valueOf((long)snapshotChunkSizeMax);
                return this;
            }

            public Builder setInstallSnapshotEnabled(boolean installSnapshotEnabled) {
                this.installSnapshotEnabled = installSnapshotEnabled;
                return this;
            }
        }
    }

    public static class Impl {
        private final int retryTimesMax;
        private final long retryWaitMillis;
        private final long triggerSnapshotTime;
        private final long triggerSnapshotFileSize;

        public Impl(int retryTimesMax, long retryWaitMillis, long triggerSnapshotTime, long triggerSnapshotFileSize) {
            this.retryTimesMax = retryTimesMax;
            this.retryWaitMillis = retryWaitMillis;
            this.triggerSnapshotTime = triggerSnapshotTime;
            this.triggerSnapshotFileSize = triggerSnapshotFileSize;
        }

        public int getRetryTimesMax() {
            return this.retryTimesMax;
        }

        public long getRetryWaitMillis() {
            return this.retryWaitMillis;
        }

        public long getTriggerSnapshotTime() {
            return this.triggerSnapshotTime;
        }

        public long getTriggerSnapshotFileSize() {
            return this.triggerSnapshotFileSize;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private int retryTimesMax = 3;
            private long retryWaitMillis = 500L;
            private long triggerSnapshotTime = 120L;
            private long triggerSnapshotFileSize = 0x500000000L;

            public Impl build() {
                return new Impl(this.retryTimesMax, this.retryWaitMillis, this.triggerSnapshotTime, this.triggerSnapshotFileSize);
            }

            public Builder setRetryTimesMax(int retryTimesMax) {
                this.retryTimesMax = retryTimesMax;
                return this;
            }

            public Builder setRetryWaitMillis(long retryWaitMillis) {
                this.retryWaitMillis = retryWaitMillis;
                return this;
            }

            public Builder setTriggerSnapshotTime(long triggerSnapshotTime) {
                this.triggerSnapshotTime = triggerSnapshotTime;
                return this;
            }

            public Builder setTriggerSnapshotFileSize(long triggerSnapshotFileSize) {
                this.triggerSnapshotFileSize = triggerSnapshotFileSize;
                return this;
            }
        }
    }

    public static class Client {
        private final long clientRequestTimeoutMillis;
        private final int clientMaxRetryAttempt;
        private final long clientRetryInitialSleepTimeMs;
        private final long clientRetryMaxSleepTimeMs;
        private final int coreClientNumForEachNode;
        private final int maxClientNumForEachNode;

        public Client(long clientRequestTimeoutMillis, int clientMaxRetryAttempt, long clientRetryInitialSleepTimeMs, long clientRetryMaxSleepTimeMs, int coreClientNumForEachNode, int maxClientNumForEachNode) {
            this.clientRequestTimeoutMillis = clientRequestTimeoutMillis;
            this.clientMaxRetryAttempt = clientMaxRetryAttempt;
            this.clientRetryInitialSleepTimeMs = clientRetryInitialSleepTimeMs;
            this.clientRetryMaxSleepTimeMs = clientRetryMaxSleepTimeMs;
            this.coreClientNumForEachNode = coreClientNumForEachNode;
            this.maxClientNumForEachNode = maxClientNumForEachNode;
        }

        public long getClientRequestTimeoutMillis() {
            return this.clientRequestTimeoutMillis;
        }

        public int getClientMaxRetryAttempt() {
            return this.clientMaxRetryAttempt;
        }

        public long getClientRetryInitialSleepTimeMs() {
            return this.clientRetryInitialSleepTimeMs;
        }

        public long getClientRetryMaxSleepTimeMs() {
            return this.clientRetryMaxSleepTimeMs;
        }

        public int getCoreClientNumForEachNode() {
            return this.coreClientNumForEachNode;
        }

        public int getMaxClientNumForEachNode() {
            return this.maxClientNumForEachNode;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private long clientRequestTimeoutMillis = 10000L;
            private int clientMaxRetryAttempt = 10;
            private long clientRetryInitialSleepTimeMs = 100L;
            private long clientRetryMaxSleepTimeMs = 10000L;
            private int coreClientNumForEachNode = 200;
            private int maxClientNumForEachNode = 300;

            public Client build() {
                return new Client(this.clientRequestTimeoutMillis, this.clientMaxRetryAttempt, this.clientRetryInitialSleepTimeMs, this.clientRetryMaxSleepTimeMs, this.coreClientNumForEachNode, this.maxClientNumForEachNode);
            }

            public Builder setClientRequestTimeoutMillis(long clientRequestTimeoutMillis) {
                this.clientRequestTimeoutMillis = clientRequestTimeoutMillis;
                return this;
            }

            public Builder setClientMaxRetryAttempt(int clientMaxRetryAttempt) {
                this.clientMaxRetryAttempt = clientMaxRetryAttempt;
                return this;
            }

            public Builder setClientRetryInitialSleepTimeMs(long clientRetryInitialSleepTimeMs) {
                this.clientRetryInitialSleepTimeMs = clientRetryInitialSleepTimeMs;
                return this;
            }

            public Builder setClientRetryMaxSleepTimeMs(long clientRetryMaxSleepTimeMs) {
                this.clientRetryMaxSleepTimeMs = clientRetryMaxSleepTimeMs;
                return this;
            }

            public Builder setCoreClientNumForEachNode(int coreClientNumForEachNode) {
                this.coreClientNumForEachNode = coreClientNumForEachNode;
                return this;
            }

            public Builder setMaxClientNumForEachNode(int maxClientNumForEachNode) {
                this.maxClientNumForEachNode = maxClientNumForEachNode;
                return this;
            }
        }
    }

    public static class Grpc {
        private final SizeInBytes messageSizeMax;
        private final SizeInBytes flowControlWindow;
        private final boolean asyncRequestThreadPoolCached;
        private final int asyncRequestThreadPoolSize;
        private final int leaderOutstandingAppendsMax;

        private Grpc(SizeInBytes messageSizeMax, SizeInBytes flowControlWindow, boolean asyncRequestThreadPoolCached, int asyncRequestThreadPoolSize, int leaderOutstandingAppendsMax) {
            this.messageSizeMax = messageSizeMax;
            this.flowControlWindow = flowControlWindow;
            this.asyncRequestThreadPoolCached = asyncRequestThreadPoolCached;
            this.asyncRequestThreadPoolSize = asyncRequestThreadPoolSize;
            this.leaderOutstandingAppendsMax = leaderOutstandingAppendsMax;
        }

        public SizeInBytes getMessageSizeMax() {
            return this.messageSizeMax;
        }

        public SizeInBytes getFlowControlWindow() {
            return this.flowControlWindow;
        }

        public boolean isAsyncRequestThreadPoolCached() {
            return this.asyncRequestThreadPoolCached;
        }

        public int getAsyncRequestThreadPoolSize() {
            return this.asyncRequestThreadPoolSize;
        }

        public int getLeaderOutstandingAppendsMax() {
            return this.leaderOutstandingAppendsMax;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private SizeInBytes messageSizeMax = SizeInBytes.valueOf((String)"512MB");
            private SizeInBytes flowControlWindow = SizeInBytes.valueOf((String)"4MB");
            private boolean asyncRequestThreadPoolCached = true;
            private int asyncRequestThreadPoolSize = 32;
            private int leaderOutstandingAppendsMax = 128;

            public Grpc build() {
                return new Grpc(this.messageSizeMax, this.flowControlWindow, this.asyncRequestThreadPoolCached, this.asyncRequestThreadPoolSize, this.leaderOutstandingAppendsMax);
            }

            public Builder setMessageSizeMax(SizeInBytes messageSizeMax) {
                this.messageSizeMax = messageSizeMax;
                return this;
            }

            public Builder setFlowControlWindow(SizeInBytes flowControlWindow) {
                this.flowControlWindow = flowControlWindow;
                return this;
            }

            public Builder setAsyncRequestThreadPoolCached(boolean asyncRequestThreadPoolCached) {
                this.asyncRequestThreadPoolCached = asyncRequestThreadPoolCached;
                return this;
            }

            public Builder setAsyncRequestThreadPoolSize(int asyncRequestThreadPoolSize) {
                this.asyncRequestThreadPoolSize = asyncRequestThreadPoolSize;
                return this;
            }

            public Builder setLeaderOutstandingAppendsMax(int leaderOutstandingAppendsMax) {
                this.leaderOutstandingAppendsMax = leaderOutstandingAppendsMax;
                return this;
            }
        }
    }

    public static class Log {
        private final boolean useMemory;
        private final int queueElementLimit;
        private final SizeInBytes queueByteLimit;
        private final int purgeGap;
        private final boolean purgeUptoSnapshotIndex;
        private final long preserveNumsWhenPurge;
        private final SizeInBytes segmentSizeMax;
        private final int segmentCacheNumMax;
        private final SizeInBytes segmentCacheSizeMax;
        private final SizeInBytes preallocatedSize;
        private final SizeInBytes writeBufferSize;
        private final int forceSyncNum;
        private final boolean unsafeFlushEnabled;

        private Log(boolean useMemory, int queueElementLimit, SizeInBytes queueByteLimit, int purgeGap, boolean purgeUptoSnapshotIndex, long preserveNumsWhenPurge, SizeInBytes segmentSizeMax, int segmentCacheNumMax, SizeInBytes segmentCacheSizeMax, SizeInBytes preallocatedSize, SizeInBytes writeBufferSize, int forceSyncNum, boolean unsafeFlushEnabled) {
            this.useMemory = useMemory;
            this.queueElementLimit = queueElementLimit;
            this.queueByteLimit = queueByteLimit;
            this.purgeGap = purgeGap;
            this.purgeUptoSnapshotIndex = purgeUptoSnapshotIndex;
            this.preserveNumsWhenPurge = preserveNumsWhenPurge;
            this.segmentSizeMax = segmentSizeMax;
            this.segmentCacheNumMax = segmentCacheNumMax;
            this.segmentCacheSizeMax = segmentCacheSizeMax;
            this.preallocatedSize = preallocatedSize;
            this.writeBufferSize = writeBufferSize;
            this.forceSyncNum = forceSyncNum;
            this.unsafeFlushEnabled = unsafeFlushEnabled;
        }

        public boolean isUseMemory() {
            return this.useMemory;
        }

        public int getQueueElementLimit() {
            return this.queueElementLimit;
        }

        public SizeInBytes getQueueByteLimit() {
            return this.queueByteLimit;
        }

        public int getPurgeGap() {
            return this.purgeGap;
        }

        public boolean isPurgeUptoSnapshotIndex() {
            return this.purgeUptoSnapshotIndex;
        }

        public SizeInBytes getSegmentSizeMax() {
            return this.segmentSizeMax;
        }

        public int getSegmentCacheNumMax() {
            return this.segmentCacheNumMax;
        }

        public SizeInBytes getSegmentCacheSizeMax() {
            return this.segmentCacheSizeMax;
        }

        public SizeInBytes getPreallocatedSize() {
            return this.preallocatedSize;
        }

        public SizeInBytes getWriteBufferSize() {
            return this.writeBufferSize;
        }

        public int getForceSyncNum() {
            return this.forceSyncNum;
        }

        public boolean isUnsafeFlushEnabled() {
            return this.unsafeFlushEnabled;
        }

        public long getPreserveNumsWhenPurge() {
            return this.preserveNumsWhenPurge;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private boolean useMemory = false;
            private int queueElementLimit = 4096;
            private SizeInBytes queueByteLimit = SizeInBytes.valueOf((String)"64MB");
            private int purgeGap = 1024;
            private boolean purgeUptoSnapshotIndex = true;
            private long preserveNumsWhenPurge = 1000L;
            private SizeInBytes segmentSizeMax = SizeInBytes.valueOf((String)"24MB");
            private int segmentCacheNumMax = 2;
            private SizeInBytes segmentCacheSizeMax = SizeInBytes.valueOf((String)"200MB");
            private SizeInBytes preallocatedSize = SizeInBytes.valueOf((String)"4MB");
            private SizeInBytes writeBufferSize = SizeInBytes.valueOf((String)"64KB");
            private int forceSyncNum = 128;
            private boolean unsafeFlushEnabled = true;

            public Log build() {
                return new Log(this.useMemory, this.queueElementLimit, this.queueByteLimit, this.purgeGap, this.purgeUptoSnapshotIndex, this.preserveNumsWhenPurge, this.segmentSizeMax, this.segmentCacheNumMax, this.segmentCacheSizeMax, this.preallocatedSize, this.writeBufferSize, this.forceSyncNum, this.unsafeFlushEnabled);
            }

            public Builder setUseMemory(boolean useMemory) {
                this.useMemory = useMemory;
                return this;
            }

            public Builder setQueueElementLimit(int queueElementLimit) {
                this.queueElementLimit = queueElementLimit;
                return this;
            }

            public Builder setQueueByteLimit(SizeInBytes queueByteLimit) {
                this.queueByteLimit = queueByteLimit;
                return this;
            }

            public Builder setPurgeGap(int purgeGap) {
                this.purgeGap = purgeGap;
                return this;
            }

            public Builder setPurgeUptoSnapshotIndex(boolean purgeUptoSnapshotIndex) {
                this.purgeUptoSnapshotIndex = purgeUptoSnapshotIndex;
                return this;
            }

            public Builder setPreserveNumsWhenPurge(long preserveNumsWhenPurge) {
                this.preserveNumsWhenPurge = preserveNumsWhenPurge;
                return this;
            }

            public Builder setSegmentSizeMax(SizeInBytes segmentSizeMax) {
                this.segmentSizeMax = segmentSizeMax;
                return this;
            }

            public Builder setSegmentCacheNumMax(int segmentCacheNumMax) {
                this.segmentCacheNumMax = segmentCacheNumMax;
                return this;
            }

            public Builder setSegmentCacheSizeMax(SizeInBytes segmentCacheSizeMax) {
                this.segmentCacheSizeMax = segmentCacheSizeMax;
                return this;
            }

            public Builder setPreallocatedSize(SizeInBytes preallocatedSize) {
                this.preallocatedSize = preallocatedSize;
                return this;
            }

            public Builder setWriteBufferSize(SizeInBytes writeBufferSize) {
                this.writeBufferSize = writeBufferSize;
                return this;
            }

            public Builder setForceSyncNum(int forceSyncNum) {
                this.forceSyncNum = forceSyncNum;
                return this;
            }

            public Builder setUnsafeFlushEnabled(boolean unsafeFlushEnabled) {
                this.unsafeFlushEnabled = unsafeFlushEnabled;
                return this;
            }
        }
    }

    public static class ThreadPool {
        private final boolean proxyCached;
        private final int proxySize;
        private final boolean serverCached;
        private final int serverSize;
        private final boolean clientCached;
        private final int clientSize;

        private ThreadPool(boolean proxyCached, int proxySize, boolean serverCached, int serverSize, boolean clientCached, int clientSize) {
            this.proxyCached = proxyCached;
            this.proxySize = proxySize;
            this.serverCached = serverCached;
            this.serverSize = serverSize;
            this.clientCached = clientCached;
            this.clientSize = clientSize;
        }

        public boolean isProxyCached() {
            return this.proxyCached;
        }

        public int getProxySize() {
            return this.proxySize;
        }

        public boolean isServerCached() {
            return this.serverCached;
        }

        public int getServerSize() {
            return this.serverSize;
        }

        public boolean isClientCached() {
            return this.clientCached;
        }

        public int getClientSize() {
            return this.clientSize;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private boolean proxyCached = true;
            private int proxySize = 0;
            private boolean serverCached = true;
            private int serverSize = 0;
            private boolean clientCached = true;
            private int clientSize = 0;

            public ThreadPool build() {
                return new ThreadPool(this.proxyCached, this.proxySize, this.serverCached, this.serverSize, this.clientCached, this.clientSize);
            }

            public Builder setProxyCached(boolean proxyCached) {
                this.proxyCached = proxyCached;
                return this;
            }

            public Builder setProxySize(int proxySize) {
                this.proxySize = proxySize;
                return this;
            }

            public Builder setServerCached(boolean serverCached) {
                this.serverCached = serverCached;
                return this;
            }

            public Builder setServerSize(int serverSize) {
                this.serverSize = serverSize;
                return this;
            }

            public Builder setClientCached(boolean clientCached) {
                this.clientCached = clientCached;
                return this;
            }

            public Builder setClientSize(int clientSize) {
                this.clientSize = clientSize;
                return this;
            }
        }
    }

    public static class Snapshot {
        private final boolean autoTriggerEnabled;
        private final long creationGap;
        private final long autoTriggerThreshold;
        private final int retentionFileNum;

        private Snapshot(boolean autoTriggerEnabled, long creationGap, long autoTriggerThreshold, int retentionFileNum) {
            this.autoTriggerEnabled = autoTriggerEnabled;
            this.creationGap = creationGap;
            this.autoTriggerThreshold = autoTriggerThreshold;
            this.retentionFileNum = retentionFileNum;
        }

        public boolean isAutoTriggerEnabled() {
            return this.autoTriggerEnabled;
        }

        public long getCreationGap() {
            return this.creationGap;
        }

        public long getAutoTriggerThreshold() {
            return this.autoTriggerThreshold;
        }

        public int getRetentionFileNum() {
            return this.retentionFileNum;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private boolean autoTriggerEnabled = true;
            private long creationGap = 1024L;
            private long autoTriggerThreshold = 400000L;
            private int retentionFileNum = -1;

            public Snapshot build() {
                return new Snapshot(this.autoTriggerEnabled, this.creationGap, this.autoTriggerThreshold, this.retentionFileNum);
            }

            public Builder setAutoTriggerEnabled(boolean autoTriggerEnabled) {
                this.autoTriggerEnabled = autoTriggerEnabled;
                return this;
            }

            public Builder setCreationGap(long creationGap) {
                this.creationGap = creationGap;
                return this;
            }

            public Builder setAutoTriggerThreshold(long autoTriggerThreshold) {
                this.autoTriggerThreshold = autoTriggerThreshold;
                return this;
            }

            public Builder setRetentionFileNum(int retentionFileNum) {
                this.retentionFileNum = retentionFileNum;
                return this;
            }
        }
    }

    public static class LeaderElection {
        private final TimeDuration leaderStepDownWaitTimeKey;
        private final boolean preVote;

        private LeaderElection(TimeDuration leaderStepDownWaitTimeKey, boolean preVote) {
            this.leaderStepDownWaitTimeKey = leaderStepDownWaitTimeKey;
            this.preVote = preVote;
        }

        public TimeDuration getLeaderStepDownWaitTimeKey() {
            return this.leaderStepDownWaitTimeKey;
        }

        public boolean isPreVote() {
            return this.preVote;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private TimeDuration leaderStepDownWaitTimeKey = TimeDuration.valueOf((long)30L, (TimeUnit)TimeUnit.SECONDS);
            private boolean preVote = true;

            public LeaderElection build() {
                return new LeaderElection(this.leaderStepDownWaitTimeKey, this.preVote);
            }

            public Builder setLeaderStepDownWaitTimeKey(TimeDuration leaderStepDownWaitTimeKey) {
                this.leaderStepDownWaitTimeKey = leaderStepDownWaitTimeKey;
                return this;
            }

            public Builder setPreVote(boolean preVote) {
                this.preVote = preVote;
                return this;
            }
        }
    }

    public static class Rpc {
        private final TimeDuration timeoutMin;
        private final TimeDuration timeoutMax;
        private final TimeDuration requestTimeout;
        private final TimeDuration sleepTime;
        private final TimeDuration slownessTimeout;
        private final TimeDuration firstElectionTimeoutMin;
        private final TimeDuration firstElectionTimeoutMax;

        private Rpc(TimeDuration timeoutMin, TimeDuration timeoutMax, TimeDuration requestTimeout, TimeDuration sleepTime, TimeDuration slownessTimeout, TimeDuration firstElectionTimeoutMin, TimeDuration firstElectionTimeoutMax) {
            this.timeoutMin = timeoutMin;
            this.timeoutMax = timeoutMax;
            this.requestTimeout = requestTimeout;
            this.sleepTime = sleepTime;
            this.slownessTimeout = slownessTimeout;
            this.firstElectionTimeoutMin = firstElectionTimeoutMin;
            this.firstElectionTimeoutMax = firstElectionTimeoutMax;
        }

        public TimeDuration getTimeoutMin() {
            return this.timeoutMin;
        }

        public TimeDuration getTimeoutMax() {
            return this.timeoutMax;
        }

        public TimeDuration getRequestTimeout() {
            return this.requestTimeout;
        }

        public TimeDuration getSleepTime() {
            return this.sleepTime;
        }

        public TimeDuration getSlownessTimeout() {
            return this.slownessTimeout;
        }

        public TimeDuration getFirstElectionTimeoutMin() {
            return this.firstElectionTimeoutMin;
        }

        public TimeDuration getFirstElectionTimeoutMax() {
            return this.firstElectionTimeoutMax;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            private TimeDuration timeoutMin = TimeDuration.valueOf((long)2L, (TimeUnit)TimeUnit.SECONDS);
            private TimeDuration timeoutMax = TimeDuration.valueOf((long)4L, (TimeUnit)TimeUnit.SECONDS);
            private TimeDuration requestTimeout = TimeDuration.valueOf((long)20L, (TimeUnit)TimeUnit.SECONDS);
            private TimeDuration sleepTime = TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS);
            private TimeDuration slownessTimeout = TimeDuration.valueOf((long)10L, (TimeUnit)TimeUnit.MINUTES);
            private TimeDuration firstElectionTimeoutMin = TimeDuration.valueOf((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
            private TimeDuration firstElectionTimeoutMax = TimeDuration.valueOf((long)150L, (TimeUnit)TimeUnit.MILLISECONDS);

            public Rpc build() {
                return new Rpc(this.timeoutMin, this.timeoutMax, this.requestTimeout, this.sleepTime, this.slownessTimeout, this.firstElectionTimeoutMin, this.firstElectionTimeoutMax);
            }

            public Builder setTimeoutMin(TimeDuration timeoutMin) {
                this.timeoutMin = timeoutMin;
                return this;
            }

            public Builder setTimeoutMax(TimeDuration timeoutMax) {
                this.timeoutMax = timeoutMax;
                return this;
            }

            public Builder setRequestTimeout(TimeDuration requestTimeout) {
                this.requestTimeout = requestTimeout;
                return this;
            }

            public Builder setSleepTime(TimeDuration sleepTime) {
                this.sleepTime = sleepTime;
                return this;
            }

            public Builder setSlownessTimeout(TimeDuration slownessTimeout) {
                this.slownessTimeout = slownessTimeout;
                return this;
            }

            public Builder setFirstElectionTimeoutMax(TimeDuration firstElectionTimeoutMax) {
                this.firstElectionTimeoutMax = firstElectionTimeoutMax;
                return this;
            }

            public Builder setFirstElectionTimeoutMin(TimeDuration firstElectionTimeoutMin) {
                this.firstElectionTimeoutMin = firstElectionTimeoutMin;
                return this;
            }
        }
    }

    public static class Builder {
        private Rpc rpc;
        private LeaderElection leaderElection;
        private Snapshot snapshot;
        private ThreadPool threadPool;
        private Log log;
        private Grpc grpc;
        private Client client;
        private Impl impl;
        private LeaderLogAppender leaderLogAppender;
        private Read read;

        public RatisConfig build() {
            return new RatisConfig(Optional.ofNullable(this.rpc).orElseGet(() -> Rpc.newBuilder().build()), Optional.ofNullable(this.leaderElection).orElseGet(() -> LeaderElection.newBuilder().build()), Optional.ofNullable(this.snapshot).orElseGet(() -> Snapshot.newBuilder().build()), Optional.ofNullable(this.threadPool).orElseGet(() -> ThreadPool.newBuilder().build()), Optional.ofNullable(this.log).orElseGet(() -> Log.newBuilder().build()), Optional.ofNullable(this.grpc).orElseGet(() -> Grpc.newBuilder().build()), Optional.ofNullable(this.client).orElseGet(() -> Client.newBuilder().build()), Optional.ofNullable(this.impl).orElseGet(() -> Impl.newBuilder().build()), Optional.ofNullable(this.leaderLogAppender).orElseGet(() -> LeaderLogAppender.newBuilder().build()), Optional.ofNullable(this.read).orElseGet(() -> Read.newBuilder().build()));
        }

        public Builder setRpc(Rpc rpc) {
            this.rpc = rpc;
            return this;
        }

        public Builder setLeaderElection(LeaderElection leaderElection) {
            this.leaderElection = leaderElection;
            return this;
        }

        public Builder setSnapshot(Snapshot snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public Builder setThreadPool(ThreadPool threadPool) {
            this.threadPool = threadPool;
            return this;
        }

        public Builder setLog(Log log) {
            this.log = log;
            return this;
        }

        public Builder setGrpc(Grpc grpc) {
            this.grpc = grpc;
            return this;
        }

        public Builder setClient(Client client) {
            this.client = client;
            return this;
        }

        public Builder setImpl(Impl impl) {
            this.impl = impl;
            return this;
        }

        public Builder setLeaderLogAppender(LeaderLogAppender leaderLogAppender) {
            this.leaderLogAppender = leaderLogAppender;
            return this;
        }

        public Builder setRead(Read read) {
            this.read = read;
            return this;
        }
    }
}

