/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.service;

import java.lang.reflect.InvocationTargetException;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.exception.runtime.RPCServiceException;
import org.apache.iotdb.commons.service.AbstractThriftServiceThread;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.service.ThriftService;
import org.apache.iotdb.commons.service.ThriftServiceThread;
import org.apache.iotdb.consensus.config.IoTConsensusConfig;
import org.apache.iotdb.consensus.iot.service.IoTConsensusRPCServiceHandler;
import org.apache.iotdb.consensus.iot.service.IoTConsensusRPCServiceMBean;
import org.apache.iotdb.consensus.iot.service.IoTConsensusRPCServiceProcessor;
import org.apache.iotdb.consensus.iot.thrift.IoTConsensusIService;
import org.apache.thrift.TBaseAsyncProcessor;
import org.apache.thrift.server.TServerEventHandler;

public class IoTConsensusRPCService
extends ThriftService
implements IoTConsensusRPCServiceMBean {
    private final TEndPoint thisNode;
    private final IoTConsensusConfig config;
    private IoTConsensusRPCServiceProcessor iotConsensusRPCServiceProcessor;

    public IoTConsensusRPCService(TEndPoint thisNode, IoTConsensusConfig config) {
        this.thisNode = thisNode;
        this.config = config;
    }

    public ServiceType getID() {
        return ServiceType.IOT_CONSENSUS_SERVICE;
    }

    public void initAsyncedServiceImpl(Object iotConsensusRPCServiceProcessor) {
        this.iotConsensusRPCServiceProcessor = (IoTConsensusRPCServiceProcessor)iotConsensusRPCServiceProcessor;
        this.mbeanName = String.format("%s:%s=%s", this.getClass().getPackage(), "type", this.getID().getJmxName());
        super.initAsyncedServiceImpl((Object)this.iotConsensusRPCServiceProcessor);
    }

    public void initTProcessor() throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        this.processor = new IoTConsensusIService.AsyncProcessor((IoTConsensusIService.AsyncIface)this.iotConsensusRPCServiceProcessor);
    }

    public void initThriftServiceThread() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        try {
            this.thriftServiceThread = new ThriftServiceThread((TBaseAsyncProcessor)this.processor, this.getID().getName(), ThreadName.IOT_CONSENSUS_RPC_PROCESSOR.getName(), this.getBindIP(), this.getBindPort(), this.config.getRpc().getRpcSelectorThreadNum(), this.config.getRpc().getRpcMinConcurrentClientNum(), this.config.getRpc().getRpcMaxConcurrentClientNum(), this.config.getRpc().getThriftServerAwaitTimeForStopService(), (TServerEventHandler)new IoTConsensusRPCServiceHandler(this.iotConsensusRPCServiceProcessor), this.config.getRpc().isRpcThriftCompressionEnabled(), this.config.getRpc().getConnectionTimeoutInMs(), this.config.getRpc().getThriftMaxFrameSize(), AbstractThriftServiceThread.ServerType.SELECTOR);
        }
        catch (RPCServiceException e) {
            throw new IllegalAccessException(e.getMessage());
        }
        this.thriftServiceThread.setName(ThreadName.IOT_CONSENSUS_RPC_SERVICE.getName());
    }

    public String getBindIP() {
        return this.thisNode.getIp();
    }

    public int getBindPort() {
        return this.thisNode.getPort();
    }
}

