/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics.client;

import com.librato.metrics.client.HttpResponse;
import com.librato.metrics.client.Json;
import com.librato.metrics.client.MDResponse;

public class PostResult {
    public final boolean md;
    public final byte[] payload;
    public final Exception exception;
    public final HttpResponse response;

    public PostResult(boolean md, byte[] payload, HttpResponse response) {
        this.md = md;
        this.payload = payload;
        this.response = response;
        this.exception = null;
    }

    public PostResult(boolean md, byte[] payload, Exception exception) {
        this.md = md;
        this.payload = payload;
        this.exception = exception;
        this.response = null;
    }

    public boolean isError() {
        MDResponse response;
        if (this.exception != null) {
            return true;
        }
        if (this.response == null) {
            return true;
        }
        int code = this.response.getResponseCode();
        if (!this.md && code == 200) {
            return false;
        }
        return !this.md || code / 100 != 2 || (response = Json.deserialize(this.response.getResponseBody(), MDResponse.class)).isFailed();
    }

    public String toString() {
        if (this.exception != null) {
            return this.exception.toString();
        }
        if (this.response != null) {
            int code = this.response.getResponseCode();
            byte[] body = this.response.getResponseBody();
            return "code:" + code + " response:" + new String(body);
        }
        return "invalid post result";
    }
}

