/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.schema.mnode.impl;

import org.apache.iotdb.commons.schema.node.utils.IMNodeContainer;
import org.apache.iotdb.confignode.persistence.schema.mnode.IConfigMNode;
import org.apache.iotdb.confignode.persistence.schema.mnode.basic.ConfigBasicMNode;
import org.apache.iotdb.confignode.persistence.schema.mnode.container.ConfigMNodeContainer;

public class ConfigBasicInternalMNode
extends ConfigBasicMNode {
    private volatile transient IMNodeContainer<IConfigMNode> children = null;

    public ConfigBasicInternalMNode(IConfigMNode parent, String name) {
        super(parent, name);
    }

    @Override
    public boolean hasChild(String name) {
        return this.children != null && this.children.containsKey((Object)name);
    }

    @Override
    public IConfigMNode getChild(String name) {
        IConfigMNode child = null;
        if (this.children != null) {
            child = (IConfigMNode)this.children.get((Object)name);
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IConfigMNode addChild(String name, IConfigMNode child) {
        if (this.children == null) {
            ConfigBasicInternalMNode configBasicInternalMNode = this;
            synchronized (configBasicInternalMNode) {
                if (this.children == null) {
                    this.children = new ConfigMNodeContainer();
                }
            }
        }
        child.setParent(this);
        IConfigMNode existingChild = (IConfigMNode)this.children.putIfAbsent((Object)name, (Object)child);
        return existingChild == null ? child : existingChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IConfigMNode addChild(IConfigMNode child) {
        if (this.children == null) {
            ConfigBasicInternalMNode configBasicInternalMNode = this;
            synchronized (configBasicInternalMNode) {
                if (this.children == null) {
                    this.children = new ConfigMNodeContainer();
                }
            }
        }
        child.setParent(this);
        this.children.putIfAbsent((Object)child.getName(), (Object)child);
        return child;
    }

    @Override
    public IConfigMNode deleteChild(String name) {
        if (this.children != null) {
            return (IConfigMNode)this.children.remove((Object)name);
        }
        return null;
    }

    @Override
    public synchronized void replaceChild(String oldChildName, IConfigMNode newChildNode) {
        if (!oldChildName.equals(newChildNode.getName())) {
            throw new RuntimeException("New child's name must be the same as old child's name!");
        }
        IConfigMNode oldChildNode = this.getChild(oldChildName);
        if (oldChildNode == null) {
            return;
        }
        oldChildNode.moveDataToNewMNode(newChildNode);
        this.children.replace((Object)newChildNode.getName(), (Object)newChildNode);
    }

    @Override
    public void moveDataToNewMNode(IConfigMNode newMNode) {
        super.moveDataToNewMNode(newMNode);
        if (this.children != null) {
            newMNode.setChildren(this.children);
            this.children.forEach((childName, childNode) -> childNode.setParent(newMNode));
        }
    }

    @Override
    public IMNodeContainer<IConfigMNode> getChildren() {
        if (this.children == null) {
            return ConfigMNodeContainer.emptyMNodeContainer();
        }
        return this.children;
    }

    @Override
    public void setChildren(IMNodeContainer<IConfigMNode> children) {
        this.children = children;
    }

    @Override
    public int estimateSize() {
        return 88 + super.estimateSize();
    }

    @Override
    public IConfigMNode getAsMNode() {
        return this;
    }
}

