/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.pipe;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.persistence.pipe.PipePluginInfo;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeInfo.class);
    private final PipePluginInfo pipePluginInfo = new PipePluginInfo();
    private final PipeTaskInfo pipeTaskInfo = new PipeTaskInfo();

    public PipePluginInfo getPipePluginInfo() {
        return this.pipePluginInfo;
    }

    public PipeTaskInfo getPipeTaskInfo() {
        return this.pipeTaskInfo;
    }

    public boolean processTakeSnapshot(File snapshotDir) throws IOException {
        return this.pipeTaskInfo.processTakeSnapshot(snapshotDir) && this.pipePluginInfo.processTakeSnapshot(snapshotDir);
    }

    public void processLoadSnapshot(File snapshotDir) throws IOException {
        Exception loadPipeTaskInfoException = null;
        Exception loadPipePluginInfoException = null;
        try {
            this.pipeTaskInfo.processLoadSnapshot(snapshotDir);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to load pipe task info from snapshot", (Throwable)ex);
            loadPipeTaskInfoException = ex;
        }
        try {
            this.pipePluginInfo.processLoadSnapshot(snapshotDir);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to load pipe plugin info from snapshot", (Throwable)ex);
            loadPipePluginInfoException = ex;
        }
        if (loadPipeTaskInfoException != null || loadPipePluginInfoException != null) {
            throw new IOException("Failed to load pipe info from snapshot, loadPipeTaskInfoException=" + loadPipeTaskInfoException + ", loadPipePluginInfoException=" + loadPipePluginInfoException);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipeInfo pipeInfo = (PipeInfo)o;
        return Objects.equals(this.pipePluginInfo, pipeInfo.pipePluginInfo) && Objects.equals(this.pipeTaskInfo, pipeInfo.pipeTaskInfo);
    }

    public int hashCode() {
        return Objects.hash(this.pipePluginInfo, this.pipeTaskInfo);
    }

    public String toString() {
        return "PipeInfo{pipePluginInfo=" + this.pipePluginInfo + ", pipeTaskInfo=" + this.pipeTaskInfo + '}';
    }
}

