/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.commons.partition.SeriesPartitionTable;
import org.apache.iotdb.commons.structure.BalanceTreeMap;
import org.apache.iotdb.confignode.exception.DatabaseNotExistsException;
import org.apache.iotdb.confignode.exception.NoAvailableRegionGroupException;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.balancer.partition.DataPartitionPolicyTable;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.manager.schema.ClusterSchemaManager;
import org.apache.iotdb.confignode.rpc.thrift.TTimeSlotList;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionBalancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionBalancer.class);
    private final IManager configManager;
    private final Map<String, DataPartitionPolicyTable> dataPartitionPolicyTableMap;

    public PartitionBalancer(IManager configManager) {
        this.configManager = configManager;
        this.dataPartitionPolicyTableMap = new ConcurrentHashMap<String, DataPartitionPolicyTable>();
    }

    public Map<String, SchemaPartitionTable> allocateSchemaPartition(Map<String, List<TSeriesPartitionSlot>> unassignedSchemaPartitionSlotsMap) throws NoAvailableRegionGroupException {
        HashMap<String, SchemaPartitionTable> result = new HashMap<String, SchemaPartitionTable>();
        for (Map.Entry<String, List<TSeriesPartitionSlot>> slotsMapEntry : unassignedSchemaPartitionSlotsMap.entrySet()) {
            String database = slotsMapEntry.getKey();
            List<TSeriesPartitionSlot> unassignedPartitionSlots = slotsMapEntry.getValue();
            BalanceTreeMap counter = new BalanceTreeMap();
            List<Pair<Long, TConsensusGroupId>> regionSlotsCounter = this.getPartitionManager().getSortedRegionGroupSlotsCounter(database, TConsensusGroupType.SchemaRegion);
            for (Pair<Long, TConsensusGroupId> pair : regionSlotsCounter) {
                counter.put((Object)((TConsensusGroupId)pair.getRight()), (Comparable)Integer.valueOf(((Long)pair.getLeft()).intValue()));
            }
            HashMap<TSeriesPartitionSlot, TConsensusGroupId> schemaPartitionMap = new HashMap<TSeriesPartitionSlot, TConsensusGroupId>();
            for (TSeriesPartitionSlot seriesPartitionSlot : unassignedPartitionSlots) {
                TConsensusGroupId consensusGroupId = (TConsensusGroupId)counter.getKeyWithMinValue();
                schemaPartitionMap.put(seriesPartitionSlot, consensusGroupId);
                counter.put((Object)consensusGroupId, (Comparable)Integer.valueOf((Integer)counter.get((Object)consensusGroupId) + 1));
            }
            result.put(database, new SchemaPartitionTable(schemaPartitionMap));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, DataPartitionTable> allocateDataPartition(Map<String, Map<TSeriesPartitionSlot, TTimeSlotList>> unassignedDataPartitionSlotsMap) throws NoAvailableRegionGroupException {
        HashMap<String, DataPartitionTable> result = new HashMap<String, DataPartitionTable>();
        for (Map.Entry<String, Map<TSeriesPartitionSlot, TTimeSlotList>> slotsMapEntry : unassignedDataPartitionSlotsMap.entrySet()) {
            String database = slotsMapEntry.getKey();
            Map<TSeriesPartitionSlot, TTimeSlotList> unassignedPartitionSlotsMap = slotsMapEntry.getValue();
            BalanceTreeMap counter = new BalanceTreeMap();
            List<Pair<Long, TConsensusGroupId>> regionSlotsCounter = this.getPartitionManager().getSortedRegionGroupSlotsCounter(database, TConsensusGroupType.DataRegion);
            for (Pair<Long, TConsensusGroupId> pair : regionSlotsCounter) {
                counter.put((Object)((TConsensusGroupId)pair.getRight()), (Comparable)Integer.valueOf(((Long)pair.getLeft()).intValue()));
            }
            DataPartitionTable dataPartitionTable = new DataPartitionTable();
            DataPartitionPolicyTable allotTable = this.dataPartitionPolicyTableMap.get(database);
            try {
                allotTable.acquireLock();
                for (Map.Entry<TSeriesPartitionSlot, TTimeSlotList> seriesPartitionEntry : unassignedPartitionSlotsMap.entrySet()) {
                    SeriesPartitionTable seriesPartitionTable = new SeriesPartitionTable();
                    TSeriesPartitionSlot seriesPartitionSlot = seriesPartitionEntry.getKey();
                    List timePartitionSlots = seriesPartitionEntry.getValue().getTimePartitionSlots();
                    timePartitionSlots.sort(Comparator.comparingLong(TTimePartitionSlot::getStartTime));
                    for (TTimePartitionSlot timePartitionSlot : timePartitionSlots) {
                        TConsensusGroupId successor = this.getPartitionManager().getSuccessorDataPartition(database, seriesPartitionSlot, timePartitionSlot);
                        if (successor != null && counter.containsKey((Object)successor)) {
                            seriesPartitionTable.putDataPartition(timePartitionSlot, successor);
                            counter.put((Object)successor, (Comparable)Integer.valueOf((Integer)counter.get((Object)successor) + 1));
                            continue;
                        }
                        TConsensusGroupId allotGroupId = allotTable.getRegionGroupIdOrActivateIfNecessary(seriesPartitionSlot);
                        if (counter.containsKey((Object)allotGroupId)) {
                            seriesPartitionTable.putDataPartition(timePartitionSlot, allotGroupId);
                            counter.put((Object)allotGroupId, (Comparable)Integer.valueOf((Integer)counter.get((Object)allotGroupId) + 1));
                            continue;
                        }
                        TConsensusGroupId predecessor = this.getPartitionManager().getPredecessorDataPartition(database, seriesPartitionSlot, timePartitionSlot);
                        if (predecessor != null && counter.containsKey((Object)predecessor)) {
                            seriesPartitionTable.putDataPartition(timePartitionSlot, predecessor);
                            counter.put((Object)predecessor, (Comparable)Integer.valueOf((Integer)counter.get((Object)predecessor) + 1));
                            continue;
                        }
                        TConsensusGroupId greedyGroupId = (TConsensusGroupId)counter.getKeyWithMinValue();
                        seriesPartitionTable.putDataPartition(timePartitionSlot, greedyGroupId);
                        counter.put((Object)greedyGroupId, (Comparable)Integer.valueOf((Integer)counter.get((Object)greedyGroupId) + 1));
                    }
                    dataPartitionTable.getDataPartitionMap().put(seriesPartitionEntry.getKey(), seriesPartitionTable);
                }
            }
            finally {
                allotTable.releaseLock();
            }
            result.put(database, dataPartitionTable);
        }
        return result;
    }

    public void reBalanceDataPartitionPolicy(String database) {
        try {
            this.dataPartitionPolicyTableMap.computeIfAbsent(database, empty -> new DataPartitionPolicyTable()).reBalanceDataPartitionPolicy(this.getPartitionManager().getAllRegionGroupIds(database, TConsensusGroupType.DataRegion));
        }
        catch (DatabaseNotExistsException e) {
            LOGGER.error("Database {} not exists when updateDataAllotTable", (Object)database);
        }
    }

    public void setupPartitionBalancer() {
        this.dataPartitionPolicyTableMap.clear();
        this.getClusterSchemaManager().getDatabaseNames().forEach(database -> {
            DataPartitionPolicyTable dataPartitionPolicyTable = new DataPartitionPolicyTable();
            this.dataPartitionPolicyTableMap.put((String)database, dataPartitionPolicyTable);
            try {
                dataPartitionPolicyTable.reBalanceDataPartitionPolicy(this.getPartitionManager().getAllRegionGroupIds((String)database, TConsensusGroupType.DataRegion));
                dataPartitionPolicyTable.setDataAllotMap(this.getPartitionManager().getLastDataAllotTable((String)database));
            }
            catch (DatabaseNotExistsException e) {
                LOGGER.error("Database {} not exists when setupPartitionBalancer", database);
            }
        });
    }

    public void clearPartitionBalancer() {
        this.dataPartitionPolicyTableMap.clear();
    }

    public void clearDataPartitionPolicyTable(String database) {
        this.dataPartitionPolicyTableMap.remove(database);
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }
}

