/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.rescon.quotas;

import org.apache.iotdb.db.storageengine.rescon.quotas.RateLimiter;

public class AverageIntervalRateLimiter
extends RateLimiter {
    private long nextRefillTime = -1L;

    @Override
    public long refill(long limit) {
        long now = System.currentTimeMillis();
        if (this.nextRefillTime == -1L) {
            this.nextRefillTime = System.currentTimeMillis();
            return limit;
        }
        long timeInterval = now - this.nextRefillTime;
        long delta = 0L;
        long timeUnitInMillis = super.getTimeUnitInMillis();
        if (timeInterval >= timeUnitInMillis) {
            delta = limit;
        } else if (timeInterval > 0L) {
            double r = (double)timeInterval / (double)timeUnitInMillis * (double)limit;
            delta = (long)r;
        }
        if (delta > 0L) {
            this.nextRefillTime = now;
        }
        return delta;
    }

    @Override
    public long getWaitInterval(long limit, long available, long amount) {
        if (this.nextRefillTime == -1L) {
            return 0L;
        }
        double r = (double)(amount - available) * (double)super.getTimeUnitInMillis() / (double)limit;
        return (long)r;
    }

    public void setNextRefillTime(long nextRefillTime) {
        this.nextRefillTime = nextRefillTime;
    }

    public long getNextRefillTime() {
        return this.nextRefillTime;
    }
}

