/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.recover.file;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.storageengine.dataregion.memtable.DeviceIDFactory;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class TsFilePlanRedoer {
    private final TsFileResource tsFileResource;
    private final boolean sequence;
    private IMemTable recoveryMemTable = new PrimitiveMemTable();

    public TsFilePlanRedoer(TsFileResource tsFileResource, boolean sequence) {
        this.tsFileResource = tsFileResource;
        this.sequence = sequence;
    }

    void redoDelete(DeleteDataNode deleteDataNode) throws IOException {
        List<PartialPath> paths = deleteDataNode.getPathList();
        for (PartialPath path : paths) {
            this.recoveryMemTable.delete(path, path.getDevicePath(), deleteDataNode.getDeleteStartTime(), deleteDataNode.getDeleteEndTime());
            this.tsFileResource.getModFile().write(new Deletion(path, this.tsFileResource.getTsFileSize(), deleteDataNode.getDeleteStartTime(), deleteDataNode.getDeleteEndTime()));
        }
    }

    void redoInsert(InsertNode node) throws WriteProcessException {
        if (!node.hasValidMeasurements()) {
            return;
        }
        if (this.tsFileResource != null) {
            String deviceId = node.isAligned() ? node.getDevicePath().getDevicePath().getFullPath() : node.getDevicePath().getFullPath();
            long lastEndTime = this.tsFileResource.getEndTime(deviceId);
            long minTimeInNode = node instanceof InsertRowNode ? ((InsertRowNode)node).getTime() : ((InsertTabletNode)node).getTimes()[0];
            if (lastEndTime != Long.MIN_VALUE && lastEndTime >= minTimeInNode && this.sequence) {
                return;
            }
        }
        node.setDeviceID(DeviceIDFactory.getInstance().getDeviceID(node.getDevicePath()));
        if (node instanceof InsertRowNode) {
            if (node.isAligned()) {
                this.recoveryMemTable.insertAlignedRow((InsertRowNode)node);
            } else {
                this.recoveryMemTable.insert((InsertRowNode)node);
            }
        } else if (node.isAligned()) {
            this.recoveryMemTable.insertAlignedTablet((InsertTabletNode)node, 0, ((InsertTabletNode)node).getRowCount());
        } else {
            this.recoveryMemTable.insertTablet((InsertTabletNode)node, 0, ((InsertTabletNode)node).getRowCount());
        }
    }

    void resetRecoveryMemTable(IMemTable memTable) {
        this.recoveryMemTable = memTable;
    }

    IMemTable getRecoveryMemTable() {
        return this.recoveryMemTable;
    }
}

