/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALMetaData;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALWriter;

public class WALByteBufReader
implements Closeable {
    private final File logFile;
    private final FileChannel channel;
    private final WALMetaData metaData;
    private final Iterator<Integer> sizeIterator;

    public WALByteBufReader(File logFile) throws IOException {
        this(logFile, FileChannel.open(logFile.toPath(), StandardOpenOption.READ));
    }

    public WALByteBufReader(File logFile, FileChannel channel) throws IOException {
        this.logFile = logFile;
        this.channel = channel;
        if (channel.size() < (long)WALWriter.MAGIC_STRING_BYTES || !this.readTailMagic().equals("WAL")) {
            throw new IOException(String.format("Broken wal file %s", logFile));
        }
        ByteBuffer metadataSizeBuf = ByteBuffer.allocate(4);
        long position = channel.size() - (long)WALWriter.MAGIC_STRING_BYTES - 4L;
        channel.read(metadataSizeBuf, position);
        metadataSizeBuf.flip();
        int metadataSize = metadataSizeBuf.getInt();
        ByteBuffer metadataBuf = ByteBuffer.allocate(metadataSize);
        channel.read(metadataBuf, position - (long)metadataSize);
        metadataBuf.flip();
        this.metaData = WALMetaData.deserialize(metadataBuf);
        this.sizeIterator = this.metaData.getBuffersSize().iterator();
        channel.position(0L);
    }

    public boolean hasNext() {
        return this.sizeIterator.hasNext();
    }

    public ByteBuffer next() throws IOException {
        int size = this.sizeIterator.next();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        this.channel.read(buffer);
        buffer.clear();
        return buffer;
    }

    private String readTailMagic() throws IOException {
        ByteBuffer magicStringBytes = ByteBuffer.allocate(WALWriter.MAGIC_STRING_BYTES);
        this.channel.read(magicStringBytes, this.channel.size() - (long)WALWriter.MAGIC_STRING_BYTES);
        magicStringBytes.flip();
        return new String(magicStringBytes.array());
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public long getFirstSearchIndex() {
        return this.metaData.getFirstSearchIndex();
    }
}

