/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.comparator;

import java.util.List;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CrossSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.InnerSpaceCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.comparator.ICompactionTaskComparator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionPriority;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class DefaultCompactionTaskComparatorImpl
implements ICompactionTaskComparator {
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    @Override
    public int compare(AbstractCompactionTask o1, AbstractCompactionTask o2) {
        if (o1 instanceof InnerSpaceCompactionTask && o2 instanceof CrossSpaceCompactionTask || o2 instanceof InnerSpaceCompactionTask && o1 instanceof CrossSpaceCompactionTask) {
            if (this.config.getCompactionPriority() == CompactionPriority.CROSS_INNER) {
                return o1 instanceof CrossSpaceCompactionTask ? -1 : 1;
            }
            if (this.config.getCompactionPriority() == CompactionPriority.INNER_CROSS) {
                return o1 instanceof InnerSpaceCompactionTask ? -1 : 1;
            }
            if (o1.getSerialId() != o2.getSerialId()) {
                return o1.getSerialId() < o2.getSerialId() ? -1 : 1;
            }
            return o1 instanceof CrossSpaceCompactionTask ? -1 : 1;
        }
        if (o1 instanceof InnerSpaceCompactionTask) {
            return this.compareInnerSpaceCompactionTask((InnerSpaceCompactionTask)o1, (InnerSpaceCompactionTask)o2);
        }
        return this.compareCrossSpaceCompactionTask((CrossSpaceCompactionTask)o1, (CrossSpaceCompactionTask)o2);
    }

    @Override
    public int compareInnerSpaceCompactionTask(InnerSpaceCompactionTask o1, InnerSpaceCompactionTask o2) {
        if (o1.getMaxModsFileSize() != o2.getMaxModsFileSize()) {
            return o2.getMaxModsFileSize() > o1.getMaxModsFileSize() ? 1 : -1;
        }
        if ((double)o1.getSumOfCompactionCount() / (double)o1.getSelectedTsFileResourceList().size() != (double)o2.getSumOfCompactionCount() / (double)o2.getSelectedTsFileResourceList().size()) {
            return o1.getSumOfCompactionCount() / o1.getSelectedTsFileResourceList().size() - o2.getSumOfCompactionCount() / o2.getSelectedTsFileResourceList().size();
        }
        if (o1.getTimePartition() != o2.getTimePartition()) {
            return o2.getTimePartition() > o1.getTimePartition() ? 1 : -1;
        }
        if (o1.getMaxFileVersion() != o2.getMaxFileVersion()) {
            return o2.getMaxFileVersion() > o1.getMaxFileVersion() ? 1 : -1;
        }
        List<TsFileResource> selectedFilesOfO1 = o1.getSelectedTsFileResourceList();
        List<TsFileResource> selectedFilesOfO2 = o2.getSelectedTsFileResourceList();
        if (selectedFilesOfO1.size() != selectedFilesOfO2.size()) {
            return selectedFilesOfO2.size() - selectedFilesOfO1.size();
        }
        if (o1.getSerialId() != o2.getSerialId()) {
            return o1.getSerialId() > o2.getSerialId() ? 1 : -1;
        }
        if (o1.getSelectedFileSize() != o2.getSelectedFileSize()) {
            return (int)(o1.getSelectedFileSize() - o2.getSelectedFileSize());
        }
        return 0;
    }

    @Override
    public int compareCrossSpaceCompactionTask(CrossSpaceCompactionTask o1, CrossSpaceCompactionTask o2) {
        if (o1.getTimePartition() != o2.getTimePartition()) {
            return o2.getTimePartition() > o1.getTimePartition() ? 1 : -1;
        }
        if (o1.getSelectedSequenceFiles().size() != o2.getSelectedSequenceFiles().size()) {
            return o1.getSelectedSequenceFiles().size() - o2.getSelectedSequenceFiles().size();
        }
        if (o1.getSerialId() != o2.getSerialId()) {
            return o1.getSerialId() > o2.getSerialId() ? 1 : -1;
        }
        return o2.getSelectedUnsequenceFiles().size() - o1.getSelectedUnsequenceFiles().size();
    }
}

