/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.TsFileAlignedSeriesReaderIterator;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.reader.chunk.AlignedChunkReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class AlignedSeriesCompactionExecutor {
    private final String device;
    private final LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> readerAndChunkMetadataList;
    private final TsFileResource targetResource;
    private final CompactionTsFileWriter writer;
    private final AlignedChunkWriterImpl chunkWriter;
    private final List<IMeasurementSchema> schemaList;
    private long remainingPointInChunkWriter = 0L;
    private final CompactionTaskSummary summary;
    private final long chunkSizeThreshold = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
    private final long chunkPointNumThreshold = IoTDBDescriptor.getInstance().getConfig().getTargetChunkPointNum();

    public AlignedSeriesCompactionExecutor(String device, TsFileResource targetResource, LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> readerAndChunkMetadataList, CompactionTsFileWriter writer, CompactionTaskSummary summary) throws IOException {
        this.device = device;
        this.readerAndChunkMetadataList = readerAndChunkMetadataList;
        this.writer = writer;
        this.targetResource = targetResource;
        this.schemaList = this.collectSchemaFromAlignedChunkMetadataList(readerAndChunkMetadataList);
        this.chunkWriter = new AlignedChunkWriterImpl(this.schemaList);
        this.summary = summary;
    }

    private List<IMeasurementSchema> collectSchemaFromAlignedChunkMetadataList(LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> readerAndChunkMetadataList) throws IOException {
        HashSet<MeasurementSchema> schemaSet = new HashSet<MeasurementSchema>();
        HashSet<String> measurementSet = new HashSet<String>();
        for (Pair pair : readerAndChunkMetadataList) {
            TsFileSequenceReader reader = (TsFileSequenceReader)pair.left;
            if (reader instanceof CompactionTsFileReader) {
                ((CompactionTsFileReader)reader).markStartOfAlignedSeries();
            }
            List alignedChunkMetadataList = (List)pair.right;
            this.collectSchemaFromOneFile(alignedChunkMetadataList, reader, schemaSet, measurementSet);
            if (!(reader instanceof CompactionTsFileReader)) continue;
            ((CompactionTsFileReader)reader).markEndOfAlignedSeries();
        }
        ArrayList<IMeasurementSchema> collectedSchemaList = new ArrayList<IMeasurementSchema>(schemaSet);
        collectedSchemaList.sort(Comparator.comparing(IMeasurementSchema::getMeasurementId));
        return collectedSchemaList;
    }

    private void collectSchemaFromOneFile(List<AlignedChunkMetadata> alignedChunkMetadataList, TsFileSequenceReader reader, Set<MeasurementSchema> schemaSet, Set<String> measurementSet) throws IOException {
        for (AlignedChunkMetadata alignedChunkMetadata : alignedChunkMetadataList) {
            List valueChunkMetadataList = alignedChunkMetadata.getValueChunkMetadataList();
            for (IChunkMetadata chunkMetadata : valueChunkMetadataList) {
                if (chunkMetadata == null || measurementSet.contains(chunkMetadata.getMeasurementUid())) continue;
                measurementSet.add(chunkMetadata.getMeasurementUid());
                Chunk chunk = reader.readMemChunk((ChunkMetadata)chunkMetadata);
                ChunkHeader header = chunk.getHeader();
                schemaSet.add(new MeasurementSchema(header.getMeasurementID(), header.getDataType(), header.getEncodingType(), header.getCompressionType()));
            }
        }
    }

    public void execute() throws IOException {
        while (!this.readerAndChunkMetadataList.isEmpty()) {
            Pair<TsFileSequenceReader, List<AlignedChunkMetadata>> readerListPair = this.readerAndChunkMetadataList.removeFirst();
            TsFileSequenceReader reader = (TsFileSequenceReader)readerListPair.left;
            List alignedChunkMetadataList = (List)readerListPair.right;
            if (reader instanceof CompactionTsFileReader) {
                ((CompactionTsFileReader)reader).markStartOfAlignedSeries();
            }
            TsFileAlignedSeriesReaderIterator readerIterator = new TsFileAlignedSeriesReaderIterator(reader, alignedChunkMetadataList, this.schemaList);
            while (readerIterator.hasNext()) {
                TsFileAlignedSeriesReaderIterator.NextAlignedChunkInfo nextAlignedChunkInfo = readerIterator.nextReader();
                this.summary.increaseProcessChunkNum(nextAlignedChunkInfo.getNotNullChunkNum());
                this.summary.increaseProcessPointNum(nextAlignedChunkInfo.getTotalPointNum());
                this.compactOneAlignedChunk(nextAlignedChunkInfo.getReader(), nextAlignedChunkInfo.getNotNullChunkNum());
            }
            if (!(reader instanceof CompactionTsFileReader)) continue;
            ((CompactionTsFileReader)reader).markEndOfAlignedSeries();
        }
        if (this.remainingPointInChunkWriter != 0L) {
            this.writer.writeChunk((IChunkWriter)this.chunkWriter);
        }
        this.writer.checkMetadataSizeAndMayFlush();
    }

    private void compactOneAlignedChunk(AlignedChunkReader chunkReader, int notNullChunkNum) throws IOException {
        while (chunkReader.hasNextSatisfiedPage()) {
            BatchData.BatchDataIterator batchDataIterator = chunkReader.nextPageData().getBatchDataIterator();
            while (batchDataIterator.hasNext()) {
                TsPrimitiveType[] pointsData = (TsPrimitiveType[])batchDataIterator.currentValue();
                long time = batchDataIterator.currentTime();
                this.chunkWriter.write(time, pointsData);
                ++this.remainingPointInChunkWriter;
                this.targetResource.updateStartTime(this.device, time);
                this.targetResource.updateEndTime(this.device, time);
                batchDataIterator.next();
            }
        }
        this.flushChunkWriterIfLargeEnough();
    }

    private void flushChunkWriterIfLargeEnough() throws IOException {
        if (this.remainingPointInChunkWriter >= this.chunkPointNumThreshold || this.chunkWriter.estimateMaxSeriesMemSize() >= this.chunkSizeThreshold * (long)this.schemaList.size()) {
            this.writer.writeChunk((IChunkWriter)this.chunkWriter);
            this.remainingPointInChunkWriter = 0L;
        }
    }
}

