/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.service.metrics.FileMetrics;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionExceptionHandler;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionFileCountExceededException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionMemoryNotEnoughException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionValidationFailedException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadChunkCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.CompactionLogger;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.validator.CompactionValidator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.AbstractInnerSpaceEstimator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.FastCompactionInnerCompactionEstimator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.ReadChunkInnerCompactionEstimator;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceList;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.tsfile.exception.write.TsFileNotCompleteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnerSpaceCompactionTask
extends AbstractCompactionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    protected List<TsFileResource> selectedTsFileResourceList;
    protected TsFileResource targetTsFileResource;
    protected boolean sequence;
    protected long selectedFileSize;
    protected int sumOfCompactionCount;
    protected long maxFileVersion;
    protected int maxCompactionCount;
    private File logFile;
    protected TsFileResourceList tsFileResourceList;
    protected List<TsFileResource> targetTsFileList;
    protected boolean[] isHoldingReadLock;
    protected boolean[] isHoldingWriteLock;
    protected long maxModsFileSize;
    protected AbstractInnerSpaceEstimator innerSpaceEstimator;

    public InnerSpaceCompactionTask(long timePartition, TsFileManager tsFileManager, List<TsFileResource> selectedTsFileResourceList, boolean sequence, ICompactionPerformer performer, AtomicInteger currentTaskNum, long serialId) {
        super(tsFileManager.getStorageGroupName(), tsFileManager.getDataRegionId(), timePartition, tsFileManager, currentTaskNum, serialId);
        this.selectedTsFileResourceList = selectedTsFileResourceList;
        this.sequence = sequence;
        this.performer = performer;
        if (IoTDBDescriptor.getInstance().getConfig().isEnableCompactionMemControl()) {
            if (this.performer instanceof ReadChunkCompactionPerformer) {
                this.innerSpaceEstimator = new ReadChunkInnerCompactionEstimator();
            } else if (!sequence && this.performer instanceof FastCompactionInnerCompactionEstimator) {
                this.innerSpaceEstimator = new FastCompactionInnerCompactionEstimator();
            }
        }
        this.isHoldingReadLock = new boolean[selectedTsFileResourceList.size()];
        this.isHoldingWriteLock = new boolean[selectedTsFileResourceList.size()];
        for (int i = 0; i < selectedTsFileResourceList.size(); ++i) {
            this.isHoldingWriteLock[i] = false;
            this.isHoldingReadLock[i] = false;
        }
        this.tsFileResourceList = sequence ? tsFileManager.getOrCreateSequenceListByTimePartition(timePartition) : tsFileManager.getOrCreateUnsequenceListByTimePartition(timePartition);
        this.hashCode = this.toString().hashCode();
        this.innerSeqTask = sequence;
        this.crossTask = false;
        this.collectSelectedFilesInfo();
        this.createSummary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doCompaction() {
        if (!this.tsFileManager.isAllowCompaction()) {
            return true;
        }
        long startTime = System.currentTimeMillis();
        String dataDirectory = this.selectedTsFileResourceList.get(0).getTsFile().getParent();
        LOGGER.info("{}-{} [Compaction] {} InnerSpaceCompaction task starts with {} files, total file size is {} MB.", new Object[]{this.storageGroupName, this.dataRegionId, this.sequence ? "Sequence" : "Unsequence", this.selectedTsFileResourceList.size(), this.selectedFileSize / 1024L / 1024L});
        boolean isSuccess = true;
        try {
            this.targetTsFileResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(this.selectedTsFileResourceList, this.sequence);
            this.logFile = new File(dataDirectory + File.separator + this.targetTsFileResource.getTsFile().getName() + ".inner-compaction.log");
            try (CompactionLogger compactionLogger = new CompactionLogger(this.logFile);){
                CompactionValidator validator;
                this.targetTsFileList = new ArrayList<TsFileResource>(Collections.singletonList(this.targetTsFileResource));
                compactionLogger.logFiles(this.selectedTsFileResourceList, "source");
                compactionLogger.logFiles(this.targetTsFileList, "target");
                LOGGER.info("{}-{} [Compaction] compaction with {}", new Object[]{this.storageGroupName, this.dataRegionId, this.selectedTsFileResourceList});
                this.performer.setSourceFiles(this.selectedTsFileResourceList);
                this.performer.setTargetFiles(this.targetTsFileList);
                this.performer.setSummary(this.summary);
                this.performer.perform();
                CompactionUtils.updateProgressIndex(this.targetTsFileList, this.selectedTsFileResourceList, Collections.emptyList());
                CompactionUtils.moveTargetFile(this.targetTsFileList, true, this.storageGroupName + "-" + this.dataRegionId);
                LOGGER.info("{}-{} [InnerSpaceCompactionTask] start to rename mods file", (Object)this.storageGroupName, (Object)this.dataRegionId);
                CompactionUtils.combineModsInInnerCompaction(this.selectedTsFileResourceList, this.targetTsFileResource);
                if (Thread.currentThread().isInterrupted() || this.summary.isCancel()) {
                    throw new InterruptedException(String.format("%s-%s [Compaction] abort", this.storageGroupName, this.dataRegionId));
                }
                if (this.sequence) {
                    this.tsFileManager.replace(this.selectedTsFileResourceList, Collections.emptyList(), this.targetTsFileList, this.timePartition, true);
                } else {
                    this.tsFileManager.replace(Collections.emptyList(), this.selectedTsFileResourceList, this.targetTsFileList, this.timePartition, false);
                }
                if (this.targetTsFileResource.isDeleted()) {
                    compactionLogger.logFile(this.targetTsFileResource, "empty");
                }
                if (!(validator = CompactionValidator.getInstance()).validateCompaction(this.tsFileManager, this.targetTsFileList, this.storageGroupName, this.timePartition, !this.sequence)) {
                    LOGGER.error("Failed to pass compaction validation, source files is: {}, target files is {}", this.selectedTsFileResourceList, this.targetTsFileList);
                    throw new CompactionValidationFailedException("Failed to pass compaction validation");
                }
                LOGGER.info("{}-{} [Compaction] Compacted target files, try to get the write lock of source files", (Object)this.storageGroupName, (Object)this.dataRegionId);
                for (int i = 0; i < this.selectedTsFileResourceList.size(); ++i) {
                    this.selectedTsFileResourceList.get(i).readUnlock();
                    this.isHoldingReadLock[i] = false;
                    this.selectedTsFileResourceList.get(i).writeLock();
                    this.isHoldingWriteLock[i] = true;
                }
                if (this.targetTsFileResource.getTsFile().exists() && this.targetTsFileResource.getTsFile().length() < (long)"TsFile".getBytes().length * 2L + 1L) {
                    throw new TsFileNotCompleteException(String.format("target file %s is smaller than magic string and version number size", this.targetTsFileResource));
                }
                LOGGER.info("{}-{} [Compaction] compaction finish, start to delete old files", (Object)this.storageGroupName, (Object)this.dataRegionId);
                long[] sizeList = new long[this.selectedTsFileResourceList.size()];
                int size = this.selectedTsFileResourceList.size();
                for (int i = 0; i < size; ++i) {
                    sizeList[i] = this.selectedTsFileResourceList.get(i).getTsFileSize();
                }
                CompactionUtils.deleteTsFilesInDisk(this.selectedTsFileResourceList, this.storageGroupName + "-" + this.dataRegionId);
                CompactionUtils.deleteModificationForSourceFile(this.selectedTsFileResourceList, this.storageGroupName + "-" + this.dataRegionId);
                if (!this.targetTsFileResource.isDeleted()) {
                    FileMetrics.getInstance().addFile(this.targetTsFileResource.getTsFile().length(), this.sequence, this.targetTsFileResource.getTsFile().getName());
                    this.targetTsFileResource.setStatus(TsFileResourceStatus.NORMAL);
                } else {
                    this.targetTsFileResource.remove();
                }
                ArrayList<String> fileNames = new ArrayList<String>();
                for (TsFileResource resource : this.selectedTsFileResourceList) {
                    fileNames.add(resource.getTsFile().getName());
                }
                FileMetrics.getInstance().deleteFile(sizeList, this.sequence, fileNames);
                CompactionMetrics.getInstance().recordSummaryInfo(this.summary);
                double costTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                LOGGER.info("{}-{} [Compaction] {} InnerSpaceCompaction task finishes successfully, target file is {},time cost is {} s, compaction speed is {} MB/s, {}", new Object[]{this.storageGroupName, this.dataRegionId, this.sequence ? "Sequence" : "Unsequence", this.targetTsFileResource.getTsFile().getName(), costTime, (double)this.selectedFileSize / 1024.0 / 1024.0 / costTime, this.summary});
            }
            if (this.logFile.exists()) {
                FileUtils.delete((File)this.logFile);
            }
        }
        catch (Exception e) {
            isSuccess = false;
            if (!(e instanceof InterruptedException)) {
                LOGGER.error("{}-{} [Compaction] Meet errors in inner space compaction.", new Object[]{this.storageGroupName, this.dataRegionId, e});
            } else {
                LOGGER.warn("{}-{} [Compaction] Compaction interrupted", (Object)this.storageGroupName, (Object)this.dataRegionId);
                Thread.interrupted();
            }
            if (this.isSequence()) {
                CompactionExceptionHandler.handleException(this.storageGroupName + "-" + this.dataRegionId, this.logFile, this.targetTsFileList, this.selectedTsFileResourceList, Collections.emptyList(), this.tsFileManager, this.timePartition, true, this.isSequence());
            } else {
                CompactionExceptionHandler.handleException(this.storageGroupName + "-" + this.dataRegionId, this.logFile, this.targetTsFileList, Collections.emptyList(), this.selectedTsFileResourceList, this.tsFileManager, this.timePartition, true, this.isSequence());
            }
        }
        finally {
            SystemInfo.getInstance().resetCompactionMemoryCost(this.memoryCost);
            SystemInfo.getInstance().decreaseCompactionFileNumCost(this.selectedTsFileResourceList.size());
            this.releaseAllLocksAndResetStatus();
        }
        return isSuccess;
    }

    @Override
    public boolean equalsOtherTask(AbstractCompactionTask otherTask) {
        if (!(otherTask instanceof InnerSpaceCompactionTask)) {
            return false;
        }
        InnerSpaceCompactionTask task = (InnerSpaceCompactionTask)otherTask;
        return this.selectedTsFileResourceList.equals(task.selectedTsFileResourceList) && this.performer.getClass().isInstance(task.performer);
    }

    @Override
    protected List<TsFileResource> getAllSourceTsFiles() {
        return this.selectedTsFileResourceList;
    }

    private void collectSelectedFilesInfo() {
        this.selectedFileSize = 0L;
        this.sumOfCompactionCount = 0;
        this.maxFileVersion = -1L;
        this.maxCompactionCount = -1;
        this.maxModsFileSize = 0L;
        if (this.selectedTsFileResourceList == null) {
            return;
        }
        for (TsFileResource resource : this.selectedTsFileResourceList) {
            try {
                this.selectedFileSize += resource.getTsFileSize();
                TsFileNameGenerator.TsFileName fileName = TsFileNameGenerator.getTsFileName(resource.getTsFile().getName());
                this.sumOfCompactionCount += fileName.getInnerCompactionCnt();
                if (fileName.getInnerCompactionCnt() > this.maxCompactionCount) {
                    this.maxCompactionCount = fileName.getInnerCompactionCnt();
                }
                if (fileName.getVersion() > this.maxFileVersion) {
                    this.maxFileVersion = fileName.getVersion();
                }
                if (Objects.isNull(resource.getModFile())) continue;
                long modsFileSize = resource.getModFile().getSize();
                this.maxModsFileSize = Math.max(this.maxModsFileSize, modsFileSize);
            }
            catch (IOException e) {
                LOGGER.warn("Fail to get the tsfile name of {}", (Object)resource.getTsFile(), (Object)e);
            }
        }
    }

    public List<TsFileResource> getSelectedTsFileResourceList() {
        return this.selectedTsFileResourceList;
    }

    public boolean isSequence() {
        return this.sequence;
    }

    public long getSelectedFileSize() {
        return this.selectedFileSize;
    }

    public int getSumOfCompactionCount() {
        return this.sumOfCompactionCount;
    }

    public long getMaxFileVersion() {
        return this.maxFileVersion;
    }

    public long getMaxModsFileSize() {
        return this.maxModsFileSize;
    }

    public String toString() {
        return this.storageGroupName + "-" + this.dataRegionId + "-" + this.timePartition + " task file num is " + this.selectedTsFileResourceList.size() + ", files is " + this.selectedTsFileResourceList + ", total compaction count is " + this.sumOfCompactionCount;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof InnerSpaceCompactionTask)) {
            return false;
        }
        return this.equalsOtherTask((InnerSpaceCompactionTask)other);
    }

    private void releaseAllLocksAndResetStatus() {
        this.resetCompactionCandidateStatusForAllSourceFiles();
        for (int i = 0; i < this.selectedTsFileResourceList.size(); ++i) {
            TsFileResource resource = this.selectedTsFileResourceList.get(i);
            if (this.isHoldingReadLock[i]) {
                resource.readUnlock();
            }
            if (!this.isHoldingWriteLock[i]) continue;
            resource.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkValidAndSetMerging() {
        if (!this.tsFileManager.isAllowCompaction()) {
            this.resetCompactionCandidateStatusForAllSourceFiles();
            return false;
        }
        try {
            for (int i = 0; i < this.selectedTsFileResourceList.size(); ++i) {
                TsFileResource resource = this.selectedTsFileResourceList.get(i);
                resource.readLock();
                this.isHoldingReadLock[i] = true;
                if (resource.setStatus(TsFileResourceStatus.COMPACTING)) continue;
                this.releaseAllLocksAndResetStatus();
                boolean bl = false;
                return bl;
            }
            if (this.innerSpaceEstimator != null) {
                this.memoryCost = this.innerSpaceEstimator.estimateInnerCompactionMemory(this.selectedTsFileResourceList);
            }
            SystemInfo.getInstance().addCompactionMemoryCost(this.memoryCost, 60L);
            SystemInfo.getInstance().addCompactionFileNum(this.selectedTsFileResourceList.size(), 60L);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                LOGGER.warn("Interrupted when allocating memory for compaction", (Throwable)e);
                Thread.currentThread().interrupt();
            } else if (e instanceof CompactionMemoryNotEnoughException) {
                LOGGER.warn("No enough memory for current compaction task {}", (Object)this, (Object)e);
            } else if (e instanceof CompactionFileCountExceededException) {
                LOGGER.warn("No enough file num for current compaction task {}", (Object)this, (Object)e);
                SystemInfo.getInstance().resetCompactionMemoryCost(this.memoryCost);
            }
            this.releaseAllLocksAndResetStatus();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (this.innerSpaceEstimator != null) {
                    this.innerSpaceEstimator.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close InnerSpaceCompactionMemoryEstimator");
            }
        }
        return true;
    }

    @Override
    protected void createSummary() {
        this.summary = this.performer instanceof FastCompactionPerformer ? new FastCompactionTaskSummary() : new CompactionTaskSummary();
    }
}

