/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.template;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public enum TemplateAlterOperationType {
    EXTEND_TEMPLATE(0);

    private final byte operationType;

    private TemplateAlterOperationType(byte operationType) {
        this.operationType = operationType;
    }

    public byte toByte() {
        return this.operationType;
    }

    public void serialize(OutputStream stream) throws IOException {
        ReadWriteIOUtils.write((byte)this.operationType, (OutputStream)stream);
    }

    public static TemplateAlterOperationType deserialize(ByteBuffer buffer) {
        byte type = ReadWriteIOUtils.readByte((ByteBuffer)buffer);
        return TemplateAlterOperationType.getType(type);
    }

    public static TemplateAlterOperationType getType(byte type) {
        switch (type) {
            case 0: {
                return EXTEND_TEMPLATE;
            }
        }
        throw new IllegalArgumentException("Unknown template update operation type" + type);
    }
}

