/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.metadata.schemafile.SegmentNotFoundException;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.AliasIndexPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISegment;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISegmentedPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.InternalPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFileConfig;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SegmentedPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.WrappedSegment;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public interface ISchemaPage {
    public static SchemaPage loadSchemaPage(ByteBuffer buffer) throws MetadataException {
        buffer.clear();
        byte pageType = ReadWriteIOUtils.readByte((ByteBuffer)buffer);
        switch (pageType) {
            case 0: {
                return new SegmentedPage(buffer);
            }
            case 1: {
                return new InternalPage(buffer);
            }
            case 2: {
                return new AliasIndexPage(buffer);
            }
        }
        throw new MetadataException("ByteBuffer is corrupted or set to a wrong position to load as a SchemaPage.");
    }

    public static SchemaPage initInternalPage(ByteBuffer buffer, int pageIndex, int ptr) {
        buffer.clear();
        buffer.position(32);
        ReadWriteIOUtils.write((long)((0xFFFFFFFFL & (long)ptr) << SchemaFileConfig.COMP_POINTER_OFFSET_DIGIT), (ByteBuffer)buffer);
        buffer.position(0);
        ReadWriteIOUtils.write((byte)1, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((int)pageIndex, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((short)((short)buffer.capacity()), (ByteBuffer)buffer);
        ReadWriteIOUtils.write((short)((short)(buffer.capacity() - 32 - InternalPage.COMPOUND_POINT_LENGTH)), (ByteBuffer)buffer);
        ReadWriteIOUtils.write((short)1, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((long)-1L, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((int)-1, (ByteBuffer)buffer);
        return new InternalPage(buffer);
    }

    public static ISegmentedPage initSegmentedPage(ByteBuffer buffer, int pageIndex) {
        buffer.clear();
        ReadWriteIOUtils.write((byte)0, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((int)pageIndex, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((short)32, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((short)((short)(buffer.capacity() - 32)), (ByteBuffer)buffer);
        ReadWriteIOUtils.write((short)0, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((long)-1L, (ByteBuffer)buffer);
        return new SegmentedPage(buffer);
    }

    public static SchemaPage initAliasIndexPage(ByteBuffer buffer, int pageIndex) {
        buffer.clear();
        ReadWriteIOUtils.write((byte)2, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((int)pageIndex, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((short)((short)buffer.capacity()), (ByteBuffer)buffer);
        ReadWriteIOUtils.write((short)((short)(buffer.capacity() - 32)), (ByteBuffer)buffer);
        ReadWriteIOUtils.write((short)0, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((long)-1L, (ByteBuffer)buffer);
        return new AliasIndexPage(buffer);
    }

    public void syncPageBuffer();

    public void flushPageToChannel(FileChannel var1) throws IOException;

    public void flushPageToStream(OutputStream var1) throws IOException;

    public String inspect() throws SegmentNotFoundException;

    public int getPageIndex();

    public void setPageIndex(int var1);

    public int getSubIndex();

    public void setSubIndex(int var1);

    public ISegment<Integer, Integer> getAsInternalPage();

    public ISegment<String, String> getAsAliasIndexPage();

    public ISegmentedPage getAsSegmentedPage();

    public ByteBuffer getEntireSegmentSlice() throws MetadataException;

    public void markDirty();

    public boolean isDirty();

    public WrappedSegment getSegmentOnTest(short var1) throws SegmentNotFoundException;

    public void getPageBuffer(ByteBuffer var1);
}

