/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.api.LayerPointReader;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary.UnaryTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;

public class InTransformer
extends UnaryTransformer {
    private final Satisfy satisfy;
    private Set<Integer> intSet;
    private Set<Long> longSet;
    private Set<Float> floatSet;
    private Set<Double> doubleSet;
    private Set<Boolean> booleanSet;
    private Set<String> stringSet;

    public InTransformer(LayerPointReader layerPointReader, boolean isNotIn, Set<String> values) {
        super(layerPointReader);
        this.satisfy = isNotIn ? new NotInSatisfy() : new InSatisfy();
        this.initTypedSet(values);
    }

    private void initTypedSet(Set<String> values) {
        switch (this.layerPointReaderDataType) {
            case INT32: {
                this.intSet = new HashSet<Integer>();
                for (String value : values) {
                    this.intSet.add(Integer.valueOf(value));
                }
                break;
            }
            case INT64: {
                this.longSet = new HashSet<Long>();
                for (String value : values) {
                    this.longSet.add(Long.valueOf(value));
                }
                break;
            }
            case FLOAT: {
                this.floatSet = new HashSet<Float>();
                for (String value : values) {
                    this.floatSet.add(Float.valueOf(value));
                }
                break;
            }
            case DOUBLE: {
                this.doubleSet = new HashSet<Double>();
                for (String value : values) {
                    this.doubleSet.add(Double.valueOf(value));
                }
                break;
            }
            case BOOLEAN: {
                this.booleanSet = new HashSet<Boolean>();
                for (String value : values) {
                    this.booleanSet.add(Boolean.valueOf(value));
                }
                break;
            }
            case TEXT: {
                this.stringSet = values;
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported data type: " + this.layerPointReader.getDataType());
            }
        }
    }

    @Override
    public TSDataType getDataType() {
        return TSDataType.BOOLEAN;
    }

    @Override
    protected void transformAndCache() throws QueryProcessException, IOException {
        switch (this.layerPointReaderDataType) {
            case INT32: {
                int intValue = this.layerPointReader.currentInt();
                this.cachedBoolean = this.satisfy.of(intValue);
                break;
            }
            case INT64: {
                long longValue = this.layerPointReader.currentLong();
                this.cachedBoolean = this.satisfy.of(longValue);
                break;
            }
            case FLOAT: {
                float floatValue = this.layerPointReader.currentFloat();
                this.cachedBoolean = this.satisfy.of(floatValue);
                break;
            }
            case DOUBLE: {
                double doubleValue = this.layerPointReader.currentDouble();
                this.cachedBoolean = this.satisfy.of(doubleValue);
                break;
            }
            case BOOLEAN: {
                boolean booleanValue = this.layerPointReader.currentBoolean();
                this.cachedBoolean = this.satisfy.of(booleanValue);
                break;
            }
            case TEXT: {
                Binary binaryValue = this.layerPointReader.currentBinary();
                this.cachedBoolean = this.satisfy.of(binaryValue.getStringValue());
                break;
            }
            default: {
                throw new QueryProcessException("unsupported data type: " + this.layerPointReader.getDataType());
            }
        }
    }

    private class NotInSatisfy
    implements Satisfy {
        private NotInSatisfy() {
        }

        @Override
        public boolean of(int intValue) {
            return !InTransformer.this.intSet.contains(intValue);
        }

        @Override
        public boolean of(long longValue) {
            return !InTransformer.this.longSet.contains(longValue);
        }

        @Override
        public boolean of(float floatValue) {
            return !InTransformer.this.floatSet.contains(Float.valueOf(floatValue));
        }

        @Override
        public boolean of(double doubleValue) {
            return !InTransformer.this.doubleSet.contains(doubleValue);
        }

        @Override
        public boolean of(boolean booleanValue) {
            return !InTransformer.this.booleanSet.contains(booleanValue);
        }

        @Override
        public boolean of(String stringValue) {
            return !InTransformer.this.stringSet.contains(stringValue);
        }
    }

    private class InSatisfy
    implements Satisfy {
        private InSatisfy() {
        }

        @Override
        public boolean of(int intValue) {
            return InTransformer.this.intSet.contains(intValue);
        }

        @Override
        public boolean of(long longValue) {
            return InTransformer.this.longSet.contains(longValue);
        }

        @Override
        public boolean of(float floatValue) {
            return InTransformer.this.floatSet.contains(Float.valueOf(floatValue));
        }

        @Override
        public boolean of(double doubleValue) {
            return InTransformer.this.doubleSet.contains(doubleValue);
        }

        @Override
        public boolean of(boolean booleanValue) {
            return InTransformer.this.booleanSet.contains(booleanValue);
        }

        @Override
        public boolean of(String stringValue) {
            return InTransformer.this.stringSet.contains(stringValue);
        }
    }

    private static interface Satisfy {
        public boolean of(int var1);

        public boolean of(long var1);

        public boolean of(float var1);

        public boolean of(double var1);

        public boolean of(boolean var1);

        public boolean of(String var1);
    }
}

