/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.sys;

import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.component.OrderByComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.component.SortItem;
import org.apache.iotdb.db.queryengine.plan.statement.component.WhereCondition;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowStatement;

public class ShowQueriesStatement
extends ShowStatement {
    private WhereCondition whereCondition;
    private OrderByComponent orderByComponent;
    private long rowLimit;
    private long rowOffset;
    private ZoneId zoneId;

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitShowQueries(this, context);
    }

    public void setWhereCondition(WhereCondition whereCondition) {
        this.whereCondition = whereCondition;
    }

    public WhereCondition getWhereCondition() {
        return this.whereCondition;
    }

    public void setOrderByComponent(OrderByComponent orderByComponent) {
        this.orderByComponent = orderByComponent;
    }

    public OrderByComponent getOrderByComponent() {
        return this.orderByComponent;
    }

    public List<SortItem> getSortItemList() {
        if (this.orderByComponent == null) {
            return Collections.singletonList(new SortItem("TIME", Ordering.ASC));
        }
        return this.orderByComponent.getSortItemList();
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowOffset(long rowOffset) {
        this.rowOffset = rowOffset;
    }

    public long getRowOffset() {
        return this.rowOffset;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }
}

