/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.write;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALWriteUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class DeleteDataNode
extends WritePlanNode
implements WALEntryValue {
    private static final int FIXED_SERIALIZED_SIZE = 30;
    private final List<PartialPath> pathList;
    private final long deleteStartTime;
    private final long deleteEndTime;
    protected long searchIndex = -1L;
    private TRegionReplicaSet regionReplicaSet;

    public DeleteDataNode(PlanNodeId id, List<PartialPath> pathList, long deleteStartTime, long deleteEndTime) {
        super(id);
        this.pathList = pathList;
        this.deleteStartTime = deleteStartTime;
        this.deleteEndTime = deleteEndTime;
    }

    public DeleteDataNode(PlanNodeId id, List<PartialPath> pathList, long deleteStartTime, long deleteEndTime, TRegionReplicaSet regionReplicaSet) {
        super(id);
        this.pathList = pathList;
        this.deleteStartTime = deleteStartTime;
        this.deleteEndTime = deleteEndTime;
        this.regionReplicaSet = regionReplicaSet;
    }

    public List<PartialPath> getPathList() {
        return this.pathList;
    }

    public long getDeleteStartTime() {
        return this.deleteStartTime;
    }

    public long getDeleteEndTime() {
        return this.deleteEndTime;
    }

    public long getSearchIndex() {
        return this.searchIndex;
    }

    public void setSearchIndex(long searchIndex) {
        this.searchIndex = searchIndex;
    }

    @Override
    public List<PlanNode> getChildren() {
        return new ArrayList<PlanNode>();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        return new DeleteDataNode(this.getPlanNodeId(), this.pathList, this.deleteStartTime, this.deleteEndTime);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    public int serializedSize() {
        int size = 30;
        for (PartialPath path : this.pathList) {
            size += ReadWriteIOUtils.sizeToWrite((String)path.getFullPath());
        }
        return size;
    }

    @Override
    public void serializeToWAL(IWALByteBufferView buffer) {
        buffer.putShort(PlanNodeType.DELETE_DATA.getNodeType());
        buffer.putLong(this.searchIndex);
        buffer.putInt(this.pathList.size());
        for (PartialPath path : this.pathList) {
            WALWriteUtils.write(path.getFullPath(), buffer);
        }
        buffer.putLong(this.deleteStartTime);
        buffer.putLong(this.deleteEndTime);
    }

    public static DeleteDataNode deserializeFromWAL(DataInputStream stream) throws IOException {
        long searchIndex = stream.readLong();
        int size = stream.readInt();
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>(size);
        for (int i = 0; i < size; ++i) {
            try {
                pathList.add(new PartialPath(ReadWriteIOUtils.readString((InputStream)stream)));
                continue;
            }
            catch (IllegalPathException e) {
                throw new IllegalArgumentException("Cannot deserialize InsertRowNode", e);
            }
        }
        long deleteStartTime = stream.readLong();
        long deleteEndTime = stream.readLong();
        DeleteDataNode deleteDataNode = new DeleteDataNode(new PlanNodeId(""), pathList, deleteStartTime, deleteEndTime);
        deleteDataNode.setSearchIndex(searchIndex);
        return deleteDataNode;
    }

    public static DeleteDataNode deserializeFromWAL(ByteBuffer buffer) {
        long searchIndex = buffer.getLong();
        int size = buffer.getInt();
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>(size);
        for (int i = 0; i < size; ++i) {
            try {
                pathList.add(new PartialPath(ReadWriteIOUtils.readString((ByteBuffer)buffer)));
                continue;
            }
            catch (IllegalPathException e) {
                throw new IllegalArgumentException("Cannot deserialize InsertRowNode", e);
            }
        }
        long deleteStartTime = buffer.getLong();
        long deleteEndTime = buffer.getLong();
        DeleteDataNode deleteDataNode = new DeleteDataNode(new PlanNodeId(""), pathList, deleteStartTime, deleteEndTime);
        deleteDataNode.setSearchIndex(searchIndex);
        return deleteDataNode;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.DELETE_DATA.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.pathList.size(), (ByteBuffer)byteBuffer);
        for (PartialPath path : this.pathList) {
            path.serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((long)this.deleteStartTime, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.deleteEndTime, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.DELETE_DATA.serialize(stream);
        ReadWriteIOUtils.write((int)this.pathList.size(), (OutputStream)stream);
        for (PartialPath path : this.pathList) {
            path.serialize((OutputStream)stream);
        }
        ReadWriteIOUtils.write((long)this.deleteStartTime, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.deleteEndTime, (OutputStream)stream);
    }

    public static DeleteDataNode deserialize(ByteBuffer byteBuffer) {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>(size);
        for (int i = 0; i < size; ++i) {
            pathList.add((PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer));
        }
        long deleteStartTime = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        long deleteEndTime = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new DeleteDataNode(planNodeId, pathList, deleteStartTime, deleteEndTime);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitDeleteData(this, context);
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    public String toString() {
        return String.format("DeleteDataNode-%s[ Paths: %s, Region: %s ]", this.getPlanNodeId(), this.pathList, this.regionReplicaSet == null ? "Not Assigned" : this.regionReplicaSet.getRegionId());
    }

    @Override
    public List<WritePlanNode> splitByPartition(Analysis analysis) {
        ISchemaTree schemaTree = analysis.getSchemaTree();
        DataPartition dataPartition = analysis.getDataPartitionInfo();
        HashMap<TRegionReplicaSet, List<PartialPath>> regionToPatternMap = new HashMap<TRegionReplicaSet, List<PartialPath>>();
        for (PartialPath pathPattern : this.pathList) {
            if (pathPattern.getTailNode().equals("**")) {
                this.splitPathPatternByDevice(pathPattern, pathPattern, schemaTree, dataPartition, regionToPatternMap);
            }
            this.splitPathPatternByDevice(pathPattern.getDevicePath(), pathPattern, schemaTree, dataPartition, regionToPatternMap);
        }
        return regionToPatternMap.keySet().stream().map(o -> new DeleteDataNode(this.getPlanNodeId(), (List)regionToPatternMap.get(o), this.deleteStartTime, this.deleteEndTime, (TRegionReplicaSet)o)).collect(Collectors.toList());
    }

    private void splitPathPatternByDevice(PartialPath devicePattern, PartialPath pathPattern, ISchemaTree schemaTree, DataPartition dataPartition, Map<TRegionReplicaSet, List<PartialPath>> regionToPatternMap) {
        for (DeviceSchemaInfo deviceSchemaInfo : schemaTree.getMatchedDevices(devicePattern)) {
            PartialPath devicePath = deviceSchemaInfo.getDevicePath();
            for (TRegionReplicaSet regionReplicaSet : dataPartition.getDataRegionReplicaSet(devicePath.getFullPath(), Collections.emptyList())) {
                if (regionReplicaSet.getRegionId() == null) continue;
                regionToPatternMap.computeIfAbsent(regionReplicaSet, o -> new ArrayList()).addAll(pathPattern.alterPrefixPath(devicePath));
            }
        }
    }
}

