/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata.model;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ShowTrailsTask
implements IConfigTask {
    private final String modelId;

    public ShowTrailsTask(String modelId) {
        this.modelId = modelId;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showTrails(this.modelId);
    }

    public static void buildTsBlock(List<ByteBuffer> trailInfoList, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showTrailsColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        for (ByteBuffer trailInfo : trailInfoList) {
            int i;
            String trailId = ReadWriteIOUtils.readString((ByteBuffer)trailInfo);
            String modelPath = ReadWriteIOUtils.readString((ByteBuffer)trailInfo);
            int listSize = ReadWriteIOUtils.readInt((ByteBuffer)trailInfo);
            ArrayList<String> modelHyperparameter = new ArrayList<String>();
            for (i = 0; i < listSize; ++i) {
                modelHyperparameter.add(ReadWriteIOUtils.readString((ByteBuffer)trailInfo));
            }
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(Binary.valueOf((String)trailId));
            builder.getColumnBuilder(1).writeBinary(Binary.valueOf((String)modelPath));
            builder.getColumnBuilder(2).writeBinary(Binary.valueOf((String)((String)modelHyperparameter.get(0))));
            builder.declarePosition();
            for (i = 1; i < listSize; ++i) {
                builder.getTimeColumnBuilder().writeLong(0L);
                builder.getColumnBuilder(0).writeBinary(Binary.valueOf((String)""));
                builder.getColumnBuilder(1).writeBinary(Binary.valueOf((String)""));
                builder.getColumnBuilder(2).writeBinary(Binary.valueOf((String)((String)modelHyperparameter.get(i))));
                builder.declarePosition();
            }
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowTrailsHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

