/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.pipe.plugin.meta.PipePluginMeta;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class ShowPipePluginsTask
implements IConfigTask {
    private static final Binary PIPE_PLUGIN_TYPE_BUILTIN = Binary.valueOf((String)"Builtin");
    private static final Binary PIPE_PLUGIN_TYPE_EXTERNAL = Binary.valueOf((String)"External");
    private static final Binary PIPE_JAR_NAME_EMPTY_FIELD = Binary.valueOf((String)"");

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showPipePlugins();
    }

    public static void buildTsBlock(List<ByteBuffer> allPipePluginsInformation, SettableFuture<ConfigTaskResult> future) {
        ArrayList<PipePluginMeta> pipePluginMetaList = new ArrayList<PipePluginMeta>();
        if (allPipePluginsInformation != null) {
            for (ByteBuffer pipePluginInformationByteBuffer : allPipePluginsInformation) {
                pipePluginMetaList.add(PipePluginMeta.deserialize((ByteBuffer)pipePluginInformationByteBuffer));
            }
        }
        pipePluginMetaList.sort(Comparator.comparing(PipePluginMeta::getPluginName));
        List outputDataTypes = ColumnHeaderConstant.showPipePluginsColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        for (PipePluginMeta pipePluginMeta : pipePluginMetaList) {
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(Binary.valueOf((String)pipePluginMeta.getPluginName()));
            builder.getColumnBuilder(1).writeBinary(pipePluginMeta.isBuiltin() ? PIPE_PLUGIN_TYPE_BUILTIN : PIPE_PLUGIN_TYPE_EXTERNAL);
            builder.getColumnBuilder(2).writeBinary(Binary.valueOf((String)pipePluginMeta.getClassName()));
            builder.getColumnBuilder(3).writeBinary(pipePluginMeta.getJarName() == null ? PIPE_JAR_NAME_EMPTY_FIELD : Binary.valueOf((String)pipePluginMeta.getJarName()));
            builder.declarePosition();
        }
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), DatasetHeaderFactory.getShowPipePluginsHeader()));
    }
}

