/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.IDualKeyCache;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.IDualKeyCacheComputation;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.IDualKeyCacheStats;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.IDualKeyCacheUpdating;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.CacheEntryGroupImpl;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.CacheStats;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntry;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntryGroup;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntryManager;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheSizeComputer;

class DualKeyCacheImpl<FK, SK, V, T extends ICacheEntry<SK, V>>
implements IDualKeyCache<FK, SK, V> {
    private final SegmentedConcurrentHashMap<FK, ICacheEntryGroup<FK, SK, V, T>> firstKeyMap = new SegmentedConcurrentHashMap();
    private final ICacheEntryManager<FK, SK, V, T> cacheEntryManager;
    private final ICacheSizeComputer<FK, SK, V> sizeComputer;
    private final CacheStats cacheStats;

    DualKeyCacheImpl(ICacheEntryManager<FK, SK, V, T> cacheEntryManager, ICacheSizeComputer<FK, SK, V> sizeComputer, long memoryCapacity) {
        this.cacheEntryManager = cacheEntryManager;
        this.sizeComputer = sizeComputer;
        this.cacheStats = new CacheStats(memoryCapacity);
    }

    @Override
    public V get(FK firstKey, SK secondKey) {
        ICacheEntryGroup<FK, SK, V, T> cacheEntryGroup = this.firstKeyMap.get(firstKey);
        if (cacheEntryGroup == null) {
            this.cacheStats.recordMiss(1);
            return null;
        }
        T cacheEntry = cacheEntryGroup.getCacheEntry(secondKey);
        if (cacheEntry == null) {
            this.cacheStats.recordMiss(1);
            return null;
        }
        this.cacheEntryManager.access(cacheEntry);
        this.cacheStats.recordHit(1);
        return cacheEntry.getValue();
    }

    @Override
    public void compute(IDualKeyCacheComputation<FK, SK, V> computation) {
        FK firstKey = computation.getFirstKey();
        ICacheEntryGroup<FK, SK, V, T> cacheEntryGroup = this.firstKeyMap.get(firstKey);
        SK[] secondKeyList = computation.getSecondKeyList();
        if (cacheEntryGroup == null) {
            for (int i = 0; i < secondKeyList.length; ++i) {
                computation.computeValue(i, null);
            }
            this.cacheStats.recordMiss(secondKeyList.length);
        } else {
            int hitCount = 0;
            for (int i = 0; i < secondKeyList.length; ++i) {
                T cacheEntry = cacheEntryGroup.getCacheEntry(secondKeyList[i]);
                if (cacheEntry == null) {
                    computation.computeValue(i, null);
                    continue;
                }
                computation.computeValue(i, cacheEntry.getValue());
                this.cacheEntryManager.access(cacheEntry);
                ++hitCount;
            }
            this.cacheStats.recordHit(hitCount);
            this.cacheStats.recordMiss(secondKeyList.length - hitCount);
        }
    }

    @Override
    public void update(IDualKeyCacheUpdating<FK, SK, V> updating) {
        FK firstKey = updating.getFirstKey();
        ICacheEntryGroup<FK, SK, V, T> cacheEntryGroup = this.firstKeyMap.get(firstKey);
        SK[] secondKeyList = updating.getSecondKeyList();
        if (cacheEntryGroup == null) {
            for (int i = 0; i < secondKeyList.length; ++i) {
                updating.updateValue(i, null);
            }
            this.cacheStats.recordMiss(secondKeyList.length);
        } else {
            int hitCount = 0;
            for (int i = 0; i < secondKeyList.length; ++i) {
                T cacheEntry = cacheEntryGroup.getCacheEntry(secondKeyList[i]);
                if (cacheEntry == null) {
                    updating.updateValue(i, null);
                    continue;
                }
                int changeSize = updating.updateValue(i, cacheEntry.getValue());
                this.cacheEntryManager.access(cacheEntry);
                if (changeSize != 0) {
                    this.cacheStats.increaseMemoryUsage(changeSize);
                    if (this.cacheStats.isExceedMemoryCapacity()) {
                        this.executeCacheEviction(changeSize);
                    }
                }
                ++hitCount;
            }
            this.cacheStats.recordHit(hitCount);
            this.cacheStats.recordMiss(secondKeyList.length - hitCount);
        }
    }

    @Override
    public void put(FK firstKey, SK secondKey, V value) {
        int usedMemorySize = this.putToCache(firstKey, secondKey, value);
        this.cacheStats.increaseMemoryUsage(usedMemorySize);
        if (this.cacheStats.isExceedMemoryCapacity()) {
            this.executeCacheEviction(usedMemorySize);
        }
    }

    private int putToCache(FK firstKey, SK secondKey, V value) {
        AtomicInteger usedMemorySize = new AtomicInteger(0);
        this.firstKeyMap.compute(firstKey, (k, cacheEntryGroup) -> {
            if (cacheEntryGroup == null) {
                cacheEntryGroup = new CacheEntryGroupImpl(firstKey);
                usedMemorySize.getAndAdd(this.sizeComputer.computeFirstKeySize(firstKey));
            }
            CacheEntryGroupImpl finalCacheEntryGroup = cacheEntryGroup;
            cacheEntryGroup.computeCacheEntry(secondKey, (sk, cacheEntry) -> {
                if (cacheEntry == null) {
                    cacheEntry = this.cacheEntryManager.createCacheEntry(secondKey, value, finalCacheEntryGroup);
                    this.cacheEntryManager.put(cacheEntry);
                    usedMemorySize.getAndAdd(this.sizeComputer.computeSecondKeySize(sk));
                } else {
                    Object existingValue = cacheEntry.getValue();
                    if (existingValue != value && !existingValue.equals(value)) {
                        cacheEntry.replaceValue(value);
                        usedMemorySize.getAndAdd(-this.sizeComputer.computeValueSize(existingValue));
                    }
                    this.cacheEntryManager.access(cacheEntry);
                }
                usedMemorySize.getAndAdd(this.sizeComputer.computeValueSize(value));
                return cacheEntry;
            });
            return cacheEntryGroup;
        });
        return usedMemorySize.get();
    }

    private void executeCacheEviction(int targetSize) {
        while (targetSize > 0 && this.cacheStats.memoryUsage() > 0L) {
            int evictedSize = this.evictOneCacheEntry();
            this.cacheStats.decreaseMemoryUsage(evictedSize);
            targetSize -= evictedSize;
        }
    }

    private int evictOneCacheEntry() {
        T evictCacheEntry = this.cacheEntryManager.evict();
        if (evictCacheEntry == null) {
            return 0;
        }
        AtomicInteger evictedSize = new AtomicInteger(0);
        evictedSize.getAndAdd(this.sizeComputer.computeValueSize(evictCacheEntry.getValue()));
        ICacheEntryGroup belongedGroup = evictCacheEntry.getBelongedGroup();
        belongedGroup.removeCacheEntry(evictCacheEntry.getSecondKey());
        evictedSize.getAndAdd(this.sizeComputer.computeSecondKeySize(evictCacheEntry.getSecondKey()));
        if (belongedGroup.isEmpty()) {
            this.firstKeyMap.compute(belongedGroup.getFirstKey(), (firstKey, cacheEntryGroup) -> {
                if (cacheEntryGroup == null) {
                    return null;
                }
                if (cacheEntryGroup.isEmpty()) {
                    evictedSize.getAndAdd(this.sizeComputer.computeFirstKeySize(firstKey));
                    return null;
                }
                return cacheEntryGroup;
            });
        }
        return evictedSize.get();
    }

    @Override
    public void invalidateAll() {
        this.executeInvalidateAll();
    }

    private void executeInvalidateAll() {
        this.firstKeyMap.clear();
        this.cacheEntryManager.cleanUp();
        this.cacheStats.resetMemoryUsage();
    }

    @Override
    public void cleanUp() {
        this.executeInvalidateAll();
        this.cacheStats.reset();
    }

    @Override
    public IDualKeyCacheStats stats() {
        return this.cacheStats;
    }

    private static class SegmentedConcurrentHashMap<K, V> {
        private static final int SLOT_NUM = 31;
        private final Map<K, V>[] maps = new ConcurrentHashMap[31];

        private SegmentedConcurrentHashMap() {
        }

        V get(K key) {
            return this.getBelongedMap(key).get(key);
        }

        V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            return this.getBelongedMap(key).compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            Map<K, V>[] mapArray = this.maps;
            synchronized (this.maps) {
                for (int i = 0; i < 31; ++i) {
                    this.maps[i] = null;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Map<K, V> getBelongedMap(K key) {
            int slotIndex = key.hashCode() % 31;
            slotIndex = slotIndex < 0 ? slotIndex + 31 : slotIndex;
            Map<K, V> map = this.maps[slotIndex];
            if (map != null) return map;
            Map<K, V>[] mapArray = this.maps;
            synchronized (this.maps) {
                map = this.maps[slotIndex];
                if (map != null) return map;
                this.maps[slotIndex] = map = new ConcurrentHashMap();
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return map;
            }
        }
    }
}

