/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.LoadFileException;
import org.apache.iotdb.db.exception.VerifyMetadataException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.SchemaValidator;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DatabaseSchemaStatement;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsfileAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTsfileAnalyzer.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private final LoadTsFileStatement loadTsFileStatement;
    private final MPPQueryContext context;
    private final IPartitionFetcher partitionFetcher;
    private final ISchemaFetcher schemaFetcher;
    private final SchemaAutoCreatorAndVerifier schemaAutoCreatorAndVerifier = new SchemaAutoCreatorAndVerifier();

    LoadTsfileAnalyzer(LoadTsFileStatement loadTsFileStatement, MPPQueryContext context, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        this.loadTsFileStatement = loadTsFileStatement;
        this.context = context;
        this.partitionFetcher = partitionFetcher;
        this.schemaFetcher = schemaFetcher;
    }

    public Analysis analyzeFileByFile() {
        this.context.setQueryType(QueryType.WRITE);
        int tsfileNum = this.loadTsFileStatement.getTsFiles().size();
        for (int i = 0; i < tsfileNum; ++i) {
            File tsFile = this.loadTsFileStatement.getTsFiles().get(i);
            if (tsFile.length() == 0L) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn(String.format("TsFile %s is empty.", tsFile.getPath()));
                }
                throw new SemanticException(String.format("TsFile %s is empty, please check it be flushed to disk correctly.", tsFile.getPath()));
            }
            try {
                this.analyzeSingleTsFile(tsFile);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("Load - Analysis Stage: {}/{} tsfiles have been analyzed, progress: {}%", new Object[]{i + 1, tsfileNum, String.format("%.3f", (double)(i + 1) * 100.0 / (double)tsfileNum)});
                continue;
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn(String.format("Parse file %s to resource error, this TsFile maybe empty.", tsFile.getPath()), (Throwable)e);
                throw new SemanticException(String.format("TsFile %s is empty or incomplete.", tsFile.getPath()));
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Parse file %s to resource error.", tsFile.getPath()), (Throwable)e);
                throw new SemanticException(String.format("Parse file %s to resource error", tsFile.getPath()));
            }
        }
        this.schemaAutoCreatorAndVerifier.flush();
        LOGGER.info("Load - Analysis Stage: all tsfiles have been analyzed.");
        Analysis analysis = new Analysis();
        analysis.setStatement(this.loadTsFileStatement);
        return analysis;
    }

    private void analyzeSingleTsFile(File tsFile) throws IOException {
        try (TsFileSequenceReader reader = new TsFileSequenceReader(tsFile.getAbsolutePath());){
            TsFileResource tsFileResource;
            Map device2TimeseriesMetadata = null;
            if (IoTDBDescriptor.getInstance().getConfig().isAutoCreateSchemaEnabled() || this.loadTsFileStatement.isVerifySchema()) {
                device2TimeseriesMetadata = reader.getAllTimeseriesMetadata(true);
                TimeSeriesIterator timeSeriesIterator = new TimeSeriesIterator(tsFile, device2TimeseriesMetadata);
                while (timeSeriesIterator.hasNext()) {
                    this.schemaAutoCreatorAndVerifier.autoCreateAndVerify(reader, timeSeriesIterator);
                }
                this.schemaAutoCreatorAndVerifier.flushAndClearDeviceIsAlignedCacheIfNecessary();
            }
            if (!(tsFileResource = new TsFileResource(tsFile)).resourceFileExists()) {
                if (device2TimeseriesMetadata == null) {
                    device2TimeseriesMetadata = reader.getAllTimeseriesMetadata(true);
                }
                FileLoaderUtils.updateTsFileResource(device2TimeseriesMetadata, tsFileResource);
                tsFileResource.updatePlanIndexes(reader.getMinPlanIndex());
                tsFileResource.updatePlanIndexes(reader.getMaxPlanIndex());
            } else {
                tsFileResource.deserialize();
            }
            tsFileResource.setStatus(TsFileResourceStatus.NORMAL);
            this.loadTsFileStatement.addTsFileResource(tsFileResource);
        }
    }

    static /* synthetic */ IoTDBConfig access$100() {
        return CONFIG;
    }

    private final class SchemaAutoCreatorAndVerifier {
        private final Map<String, Boolean> tsfileDevice2IsAligned = new HashMap<String, Boolean>();
        private final Set<PartialPath> alreadySetDatabases = new HashSet<PartialPath>();
        private final int maxTimeseriesNumberPerBatch = LoadTsfileAnalyzer.access$100().getMaxLoadingTimeseriesNumber();
        private final Map<String, Set<MeasurementSchema>> currentBatchDevice2TimeseriesSchemas = new HashMap<String, Set<MeasurementSchema>>();
        private int currentBatchTimeseriesCount = 0;

        private SchemaAutoCreatorAndVerifier() {
        }

        public void autoCreateAndVerify(TsFileSequenceReader reader, TimeSeriesIterator timeSeriesIterator) throws IOException {
            while (this.currentBatchTimeseriesCount < this.maxTimeseriesNumberPerBatch && timeSeriesIterator.hasNext()) {
                Pair<String, TimeseriesMetadata> pair = timeSeriesIterator.next();
                String device = (String)pair.left;
                TimeseriesMetadata timeseriesMetadata = (TimeseriesMetadata)pair.right;
                TSDataType dataType = timeseriesMetadata.getTsDataType();
                if (dataType.equals((Object)TSDataType.VECTOR)) {
                    this.tsfileDevice2IsAligned.put(device, true);
                    continue;
                }
                Pair compressionEncodingPair = reader.readTimeseriesCompressionTypeAndEncoding(timeseriesMetadata);
                this.currentBatchDevice2TimeseriesSchemas.computeIfAbsent(device, o -> new HashSet()).add(new MeasurementSchema(timeseriesMetadata.getMeasurementId(), dataType, (TSEncoding)compressionEncodingPair.getRight(), (CompressionType)compressionEncodingPair.getLeft()));
                this.tsfileDevice2IsAligned.putIfAbsent(device, false);
                ++this.currentBatchTimeseriesCount;
            }
            if (this.currentBatchTimeseriesCount == this.maxTimeseriesNumberPerBatch) {
                this.flush();
            }
        }

        public void flushAndClearDeviceIsAlignedCacheIfNecessary() throws SemanticException {
            if (this.tsfileDevice2IsAligned.size() > 10000) {
                this.flush();
                this.tsfileDevice2IsAligned.clear();
            }
        }

        public void flush() {
            this.doAutoCreateAndVerify();
            this.currentBatchDevice2TimeseriesSchemas.clear();
            this.currentBatchTimeseriesCount = 0;
        }

        private void doAutoCreateAndVerify() throws SemanticException {
            if (this.currentBatchDevice2TimeseriesSchemas.isEmpty()) {
                return;
            }
            try {
                if (LoadTsfileAnalyzer.this.loadTsFileStatement.isVerifySchema()) {
                    this.makeSureNoDuplicatedMeasurementsInDevices();
                }
                if (LoadTsfileAnalyzer.this.loadTsFileStatement.isAutoCreateDatabase()) {
                    this.autoCreateDatabase();
                }
                ISchemaTree schemaTree = this.autoCreateSchema();
                if (LoadTsfileAnalyzer.this.loadTsFileStatement.isVerifySchema()) {
                    this.verifySchema(schemaTree);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Auto create or verify schema error.", (Throwable)e);
                throw new SemanticException(String.format("Auto create or verify schema error when executing statement %s.", LoadTsfileAnalyzer.this.loadTsFileStatement));
            }
        }

        private void makeSureNoDuplicatedMeasurementsInDevices() throws VerifyMetadataException {
            for (Map.Entry<String, Set<MeasurementSchema>> entry : this.currentBatchDevice2TimeseriesSchemas.entrySet()) {
                String device = entry.getKey();
                HashMap<String, MeasurementSchema> measurement2Schema = new HashMap<String, MeasurementSchema>();
                for (MeasurementSchema timeseriesSchema : entry.getValue()) {
                    String measurement = timeseriesSchema.getMeasurementId();
                    if (measurement2Schema.containsKey(measurement)) {
                        throw new VerifyMetadataException(String.format("Duplicated measurements %s in device %s.", measurement, device));
                    }
                    measurement2Schema.put(measurement, timeseriesSchema);
                }
            }
        }

        private void autoCreateDatabase() throws VerifyMetadataException, LoadFileException, IllegalPathException {
            int databasePrefixNodesLength = LoadTsfileAnalyzer.this.loadTsFileStatement.getDatabaseLevel() + 1;
            HashSet<PartialPath> databaseSet = new HashSet<PartialPath>();
            for (String device : this.currentBatchDevice2TimeseriesSchemas.keySet()) {
                PartialPath devicePath = new PartialPath(device);
                String[] devicePrefixNodes = devicePath.getNodes();
                if (devicePrefixNodes.length < databasePrefixNodesLength) {
                    throw new VerifyMetadataException(String.format("Database level %d is longer than device %s.", databasePrefixNodesLength, device));
                }
                String[] databasePrefixNodes = new String[databasePrefixNodesLength];
                System.arraycopy(devicePrefixNodes, 0, databasePrefixNodes, 0, databasePrefixNodesLength);
                databaseSet.add(new PartialPath(databasePrefixNodes));
            }
            databaseSet.removeAll(this.alreadySetDatabases);
            for (PartialPath databasePath : databaseSet) {
                DatabaseSchemaStatement statement = new DatabaseSchemaStatement(DatabaseSchemaStatement.DatabaseSchemaStatementType.CREATE);
                statement.setDatabasePath(databasePath);
                statement.setEnablePrintExceptionLog(false);
                this.executeSetDatabaseStatement(statement);
            }
            this.alreadySetDatabases.addAll(databaseSet);
        }

        private void executeSetDatabaseStatement(Statement statement) throws LoadFileException {
            long queryId = SessionManager.getInstance().requestQueryId();
            ExecutionResult result = Coordinator.getInstance().execute(statement, queryId, null, "", LoadTsfileAnalyzer.this.partitionFetcher, LoadTsfileAnalyzer.this.schemaFetcher, IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold());
            if (result.status.code != TSStatusCode.SUCCESS_STATUS.getStatusCode() && result.status.code != TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode()) {
                LOGGER.warn("Create database error, statement: {}, result status is: {}", (Object)statement, (Object)result.status);
                throw new LoadFileException(String.format("Create database error, statement: %s, result status is: %s", statement, result.status));
            }
        }

        private ISchemaTree autoCreateSchema() throws IllegalPathException {
            ArrayList<PartialPath> deviceList = new ArrayList<PartialPath>();
            ArrayList<String[]> measurementList = new ArrayList<String[]>();
            ArrayList<TSDataType[]> dataTypeList = new ArrayList<TSDataType[]>();
            ArrayList<TSEncoding[]> encodingsList = new ArrayList<TSEncoding[]>();
            ArrayList<CompressionType[]> compressionTypesList = new ArrayList<CompressionType[]>();
            ArrayList<Boolean> isAlignedList = new ArrayList<Boolean>();
            for (Map.Entry<String, Set<MeasurementSchema>> entry : this.currentBatchDevice2TimeseriesSchemas.entrySet()) {
                int measurementSize = entry.getValue().size();
                String[] measurements = new String[measurementSize];
                TSDataType[] tsDataTypes = new TSDataType[measurementSize];
                TSEncoding[] encodings = new TSEncoding[measurementSize];
                CompressionType[] compressionTypes = new CompressionType[measurementSize];
                int index = 0;
                for (MeasurementSchema measurementSchema : entry.getValue()) {
                    measurements[index] = measurementSchema.getMeasurementId();
                    tsDataTypes[index] = measurementSchema.getType();
                    encodings[index] = measurementSchema.getEncodingType();
                    compressionTypes[index++] = measurementSchema.getCompressor();
                }
                deviceList.add(new PartialPath(entry.getKey()));
                measurementList.add(measurements);
                dataTypeList.add(tsDataTypes);
                encodingsList.add(encodings);
                compressionTypesList.add(compressionTypes);
                isAlignedList.add(this.tsfileDevice2IsAligned.get(entry.getKey()));
            }
            return SchemaValidator.validate(LoadTsfileAnalyzer.this.schemaFetcher, deviceList, measurementList, dataTypeList, encodingsList, compressionTypesList, isAlignedList, LoadTsfileAnalyzer.this.context);
        }

        private void verifySchema(ISchemaTree schemaTree) throws VerifyMetadataException, IllegalPathException {
            for (Map.Entry<String, Set<MeasurementSchema>> entry : this.currentBatchDevice2TimeseriesSchemas.entrySet()) {
                boolean isAlignedInIoTDB;
                ArrayList tsfileTimeseriesSchemas;
                String device = entry.getKey();
                DeviceSchemaInfo iotdbDeviceSchemaInfo = schemaTree.searchDeviceSchemaInfo(new PartialPath(device), (tsfileTimeseriesSchemas = new ArrayList(entry.getValue())).stream().map(MeasurementSchema::getMeasurementId).collect(Collectors.toList()));
                if (iotdbDeviceSchemaInfo == null) {
                    throw new VerifyMetadataException(String.format("Device %s does not exist in IoTDB and can not be created. Please check weather auto-create-schema is enabled.", device));
                }
                boolean isAlignedInTsFile = this.tsfileDevice2IsAligned.get(device);
                if (isAlignedInTsFile != (isAlignedInIoTDB = iotdbDeviceSchemaInfo.isAligned())) {
                    throw new VerifyMetadataException(String.format("Device %s in TsFile is %s, but in IoTDB is %s.", device, isAlignedInTsFile ? "aligned" : "not aligned", isAlignedInIoTDB ? "aligned" : "not aligned"));
                }
                List<MeasurementSchema> iotdbTimeseriesSchemas = iotdbDeviceSchemaInfo.getMeasurementSchemaList();
                int n = iotdbTimeseriesSchemas.size();
                for (int i = 0; i < n; ++i) {
                    MeasurementSchema tsFileSchema = (MeasurementSchema)tsfileTimeseriesSchemas.get(i);
                    MeasurementSchema iotdbSchema = iotdbTimeseriesSchemas.get(i);
                    if (iotdbSchema == null) {
                        throw new VerifyMetadataException(String.format("Measurement %s does not exist in IoTDB and can not be created. Please check weather auto-create-schema is enabled.", device + "." + tsfileTimeseriesSchemas.get(i)));
                    }
                    if (!tsFileSchema.getType().equals((Object)iotdbSchema.getType())) {
                        throw new VerifyMetadataException(String.format("Measurement %s%s%s datatype not match, TsFile: %s, IoTDB: %s", device, ".", iotdbSchema.getMeasurementId(), tsFileSchema.getType(), iotdbSchema.getType()));
                    }
                    if (!tsFileSchema.getEncodingType().equals((Object)iotdbSchema.getEncodingType())) {
                        LOGGER.warn("Encoding type not match, measurement: {}{}{}, TsFile encoding: {}, IoTDB encoding: {}", new Object[]{device, ".", iotdbSchema.getMeasurementId(), tsFileSchema.getEncodingType().name(), iotdbSchema.getEncodingType().name()});
                    }
                    if (tsFileSchema.getCompressor().equals((Object)iotdbSchema.getCompressor())) continue;
                    LOGGER.warn("Compressor not match, measurement: {}{}{}, TsFile compressor: {}, IoTDB compressor: {}", new Object[]{device, ".", iotdbSchema.getMeasurementId(), tsFileSchema.getCompressor().name(), iotdbSchema.getCompressor().name()});
                }
            }
        }
    }

    private static final class TimeSeriesIterator
    implements Iterator<Pair<String, TimeseriesMetadata>> {
        private static final Logger LOGGER = LoggerFactory.getLogger(TimeSeriesIterator.class);
        private static final long LOG_PRINT_INTERVAL = 10000L;
        private long returnedTimeseriesCount = 0L;
        private boolean lastLogHasPrinted = false;
        private final File tsFile;
        private final Iterator<Map.Entry<String, List<TimeseriesMetadata>>> device2TimeseriesMetadataIterator;
        private String currentDevice;
        private Iterator<TimeseriesMetadata> timeseriesMetadataIterator;

        public TimeSeriesIterator(File tsFile, Map<String, List<TimeseriesMetadata>> device2TimeseriesMetadata) {
            this.tsFile = tsFile;
            this.device2TimeseriesMetadataIterator = device2TimeseriesMetadata.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.timeseriesMetadataIterator == null || !this.timeseriesMetadataIterator.hasNext()) {
                if (this.device2TimeseriesMetadataIterator.hasNext()) {
                    Map.Entry<String, List<TimeseriesMetadata>> next = this.device2TimeseriesMetadataIterator.next();
                    this.currentDevice = next.getKey();
                    this.timeseriesMetadataIterator = next.getValue().iterator();
                } else {
                    if (!this.lastLogHasPrinted) {
                        LOGGER.info("Analyzing TsFile {}, all {} timeseries has been returned to analyzer.", (Object)this.tsFile.getAbsolutePath(), (Object)this.returnedTimeseriesCount);
                        this.lastLogHasPrinted = true;
                    }
                    return false;
                }
            }
            return this.timeseriesMetadataIterator.hasNext();
        }

        @Override
        public Pair<String, TimeseriesMetadata> next() {
            if (this.returnedTimeseriesCount == 0L) {
                LOGGER.info("Analyzing TsFile {}, start to return timeseries to analyzer.", (Object)this.tsFile.getAbsolutePath());
            } else if (this.returnedTimeseriesCount % 10000L == 0L) {
                LOGGER.info("Analyzing TsFile {}, until now {} timeseries has been returned to analyzer.", (Object)this.tsFile.getAbsolutePath(), (Object)this.returnedTimeseriesCount);
            }
            ++this.returnedTimeseriesCount;
            return new Pair((Object)this.currentDevice, (Object)this.timeseriesMetadataIterator.next());
        }
    }
}

