/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.execution.aggregation.Aggregator;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationUtil;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.AbstractDataSourceOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Pair;

public abstract class AbstractSeriesAggregationScanOperator
extends AbstractDataSourceOperator {
    protected final boolean ascending;
    protected final boolean isGroupByQuery;
    protected int subSensorSize;
    protected TsBlock inputTsBlock;
    protected final ITimeRangeIterator timeRangeIterator;
    protected TimeRange curTimeRange;
    protected final List<Aggregator> aggregators;
    protected final TsBlockBuilder resultTsBlockBuilder;
    protected boolean finished = false;
    private final long cachedRawDataSize;

    protected AbstractSeriesAggregationScanOperator(PlanNodeId sourceId, OperatorContext context, SeriesScanUtil seriesScanUtil, int subSensorSize, List<Aggregator> aggregators, ITimeRangeIterator timeRangeIterator, boolean ascending, GroupByTimeParameter groupByTimeParameter, long maxReturnSize) {
        this.sourceId = sourceId;
        this.operatorContext = context;
        this.ascending = ascending;
        this.isGroupByQuery = groupByTimeParameter != null;
        this.seriesScanUtil = seriesScanUtil;
        this.subSensorSize = subSensorSize;
        this.aggregators = aggregators;
        this.timeRangeIterator = timeRangeIterator;
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (Aggregator aggregator : aggregators) {
            dataTypes.addAll(Arrays.asList(aggregator.getOutputType()));
        }
        this.resultTsBlockBuilder = new TsBlockBuilder(dataTypes);
        this.cachedRawDataSize = (1L + (long)subSensorSize) * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
        this.maxReturnSize = maxReturnSize;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.cachedRawDataSize + this.maxReturnSize;
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.isGroupByQuery ? this.cachedRawDataSize : 0L;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.timeRangeIterator.hasNextTimeRange();
    }

    @Override
    public TsBlock next() throws Exception {
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        while (System.nanoTime() - start < maxRuntime && this.timeRangeIterator.hasNextTimeRange() && !this.resultTsBlockBuilder.isFull()) {
            this.curTimeRange = this.timeRangeIterator.nextTimeRange();
            for (Aggregator aggregator : this.aggregators) {
                aggregator.reset();
            }
            this.calculateNextAggregationResult();
        }
        if (this.resultTsBlockBuilder.getPositionCount() > 0) {
            TsBlock resultTsBlock = this.resultTsBlockBuilder.build();
            this.resultTsBlockBuilder.reset();
            return resultTsBlock;
        }
        return null;
    }

    @Override
    public boolean isFinished() throws Exception {
        if (!this.finished) {
            this.finished = !this.hasNextWithTimer();
        }
        return this.finished;
    }

    protected void calculateNextAggregationResult() {
        try {
            if (this.calcFromCachedData()) {
                this.updateResultTsBlock();
                return;
            }
            if (this.readAndCalcFromPage()) {
                this.updateResultTsBlock();
                return;
            }
            if (this.readAndCalcFromChunk()) {
                this.updateResultTsBlock();
                return;
            }
            if (this.readAndCalcFromFile()) {
                this.updateResultTsBlock();
                return;
            }
            this.updateResultTsBlock();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while scanning the file", e);
        }
    }

    protected void updateResultTsBlock() {
        AggregationUtil.appendAggregationResult(this.resultTsBlockBuilder, this.aggregators, this.timeRangeIterator.currentOutputTime());
    }

    protected boolean calcFromCachedData() {
        return this.calcFromRawData(this.inputTsBlock);
    }

    private boolean calcFromRawData(TsBlock tsBlock) {
        Pair<Boolean, TsBlock> calcResult = AggregationUtil.calculateAggregationFromRawData(tsBlock, this.aggregators, this.curTimeRange, this.ascending);
        this.inputTsBlock = (TsBlock)calcResult.getRight();
        return (Boolean)calcResult.getLeft();
    }

    protected void calcFromStatistics(Statistics[] statistics) {
        for (Aggregator aggregator : this.aggregators) {
            if (aggregator.hasFinalResult()) continue;
            aggregator.processStatistics(statistics);
        }
    }

    protected boolean readAndCalcFromFile() throws IOException {
        while (this.seriesScanUtil.hasNextFile()) {
            if (this.canUseCurrentFileStatistics()) {
                Statistics fileTimeStatistics = this.seriesScanUtil.currentFileTimeStatistics();
                if (fileTimeStatistics.getStartTime() > this.curTimeRange.getMax()) {
                    if (this.ascending) {
                        return true;
                    }
                    this.seriesScanUtil.skipCurrentFile();
                    continue;
                }
                if (this.curTimeRange.contains(fileTimeStatistics.getStartTime(), fileTimeStatistics.getEndTime())) {
                    Statistics[] statisticsList = new Statistics[this.subSensorSize];
                    for (int i = 0; i < this.subSensorSize; ++i) {
                        statisticsList[i] = this.seriesScanUtil.currentFileStatistics(i);
                    }
                    this.calcFromStatistics(statisticsList);
                    this.seriesScanUtil.skipCurrentFile();
                    if (!AggregationUtil.isAllAggregatorsHasFinalResult(this.aggregators) || this.isGroupByQuery) continue;
                    return true;
                }
            }
            if (!this.readAndCalcFromChunk()) continue;
            return true;
        }
        return false;
    }

    protected boolean readAndCalcFromChunk() throws IOException {
        while (this.seriesScanUtil.hasNextChunk()) {
            if (this.canUseCurrentChunkStatistics()) {
                Statistics chunkTimeStatistics = this.seriesScanUtil.currentChunkTimeStatistics();
                if (chunkTimeStatistics.getStartTime() > this.curTimeRange.getMax()) {
                    if (this.ascending) {
                        return true;
                    }
                    this.seriesScanUtil.skipCurrentChunk();
                    continue;
                }
                if (this.curTimeRange.contains(chunkTimeStatistics.getStartTime(), chunkTimeStatistics.getEndTime())) {
                    Statistics[] statisticsList = new Statistics[this.subSensorSize];
                    for (int i = 0; i < this.subSensorSize; ++i) {
                        statisticsList[i] = this.seriesScanUtil.currentChunkStatistics(i);
                    }
                    this.calcFromStatistics(statisticsList);
                    this.seriesScanUtil.skipCurrentChunk();
                    if (!AggregationUtil.isAllAggregatorsHasFinalResult(this.aggregators) || this.isGroupByQuery) continue;
                    return true;
                }
            }
            if (!this.readAndCalcFromPage()) continue;
            return true;
        }
        return false;
    }

    protected boolean readAndCalcFromPage() throws IOException {
        while (this.seriesScanUtil.hasNextPage()) {
            TsBlock tsBlock;
            if (this.canUseCurrentPageStatistics()) {
                Statistics pageTimeStatistics = this.seriesScanUtil.currentPageTimeStatistics();
                if (pageTimeStatistics.getStartTime() > this.curTimeRange.getMax()) {
                    if (this.ascending) {
                        return true;
                    }
                    this.seriesScanUtil.skipCurrentPage();
                    continue;
                }
                if (this.curTimeRange.contains(pageTimeStatistics.getStartTime(), pageTimeStatistics.getEndTime())) {
                    Statistics[] statisticsList = new Statistics[this.subSensorSize];
                    for (int i = 0; i < this.subSensorSize; ++i) {
                        statisticsList[i] = this.seriesScanUtil.currentPageStatistics(i);
                    }
                    this.calcFromStatistics(statisticsList);
                    this.seriesScanUtil.skipCurrentPage();
                    if (!AggregationUtil.isAllAggregatorsHasFinalResult(this.aggregators) || this.isGroupByQuery) continue;
                    return true;
                }
            }
            if ((tsBlock = this.seriesScanUtil.nextPage()) == null || tsBlock.isEmpty() || !this.calcFromRawData(tsBlock)) continue;
            return true;
        }
        return false;
    }

    protected boolean canUseCurrentFileStatistics() throws IOException {
        Statistics fileStatistics = this.seriesScanUtil.currentFileTimeStatistics();
        return !this.seriesScanUtil.isFileOverlapped() && fileStatistics.containedByTimeFilter(this.seriesScanUtil.getGlobalTimeFilter()) && !this.seriesScanUtil.currentFileModified();
    }

    protected boolean canUseCurrentChunkStatistics() throws IOException {
        Statistics chunkStatistics = this.seriesScanUtil.currentChunkTimeStatistics();
        return !this.seriesScanUtil.isChunkOverlapped() && chunkStatistics.containedByTimeFilter(this.seriesScanUtil.getGlobalTimeFilter()) && !this.seriesScanUtil.currentChunkModified();
    }

    protected boolean canUseCurrentPageStatistics() throws IOException {
        Statistics currentPageStatistics = this.seriesScanUtil.currentPageTimeStatistics();
        if (currentPageStatistics == null) {
            return false;
        }
        return !this.seriesScanUtil.isPageOverlapped() && currentPageStatistics.containedByTimeFilter(this.seriesScanUtil.getGlobalTimeFilter()) && !this.seriesScanUtil.currentPageModified();
    }
}

