/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.ILinearFill;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.Column;

public class LinearFillOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private final ILinearFill[] fillArray;
    private final Operator child;
    private final int outputColumnCount;
    private final List<TsBlock> cachedTsBlock;
    private final List<Long> cachedRowIndex;
    private long currentRowIndex = 0L;
    private final int[] nextTsBlockIndex;
    private boolean canCallNext;
    private boolean noMoreTsBlock;

    public LinearFillOperator(OperatorContext operatorContext, ILinearFill[] fillArray, Operator child) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        Preconditions.checkArgument((fillArray != null && fillArray.length > 0 ? 1 : 0) != 0, (Object)"fillArray should not be null or empty");
        this.fillArray = fillArray;
        this.child = Objects.requireNonNull(child, "child operator is null");
        this.outputColumnCount = fillArray.length;
        this.cachedTsBlock = new ArrayList<TsBlock>();
        this.cachedRowIndex = new ArrayList<Long>();
        this.nextTsBlockIndex = new int[this.outputColumnCount];
        Arrays.fill(this.nextTsBlockIndex, 1);
        this.canCallNext = false;
        this.noMoreTsBlock = true;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.cachedTsBlock.isEmpty()) {
            this.canCallNext = false;
            TsBlock nextTsBlock = this.child.nextWithTimer();
            if (nextTsBlock == null || nextTsBlock.isEmpty()) {
                return nextTsBlock;
            }
            this.cachedTsBlock.add(nextTsBlock);
            this.cachedRowIndex.add(this.currentRowIndex);
            this.currentRowIndex += (long)nextTsBlock.getPositionCount();
        }
        TsBlock originTsBlock = this.cachedTsBlock.get(0);
        long currentEndRowIndex = this.cachedRowIndex.get(0) + (long)originTsBlock.getPositionCount() - 1L;
        block0: for (int columnIndex = 0; columnIndex < this.outputColumnCount; ++columnIndex) {
            if (!this.fillArray[columnIndex].needPrepareForNext(currentEndRowIndex, originTsBlock.getColumn(columnIndex))) continue;
            while (!this.isCachedTsBlockEnough(columnIndex, currentEndRowIndex)) {
                if (this.tryToGetNextTsBlock()) continue;
                if (this.noMoreTsBlock) continue block0;
                return null;
            }
        }
        originTsBlock = this.cachedTsBlock.remove(0);
        long startRowIndex = this.cachedRowIndex.remove(0);
        Column[] columns = new Column[this.outputColumnCount];
        for (int i = 0; i < this.outputColumnCount; ++i) {
            columns[i] = this.fillArray[i].fill(originTsBlock.getTimeColumn(), originTsBlock.getColumn(i), startRowIndex);
        }
        TsBlock result = new TsBlock(originTsBlock.getPositionCount(), originTsBlock.getTimeColumn(), columns);
        for (int i = 0; i < this.outputColumnCount; ++i) {
            this.nextTsBlockIndex[i] = Math.max(1, this.nextTsBlockIndex[i] - 1);
        }
        return result;
    }

    @Override
    public boolean hasNext() throws Exception {
        this.noMoreTsBlock = !this.child.hasNextWithTimer();
        this.canCallNext = !this.noMoreTsBlock;
        return !this.cachedTsBlock.isEmpty() || !this.noMoreTsBlock;
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.cachedTsBlock.isEmpty() && this.child.isFinished();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return 3L * this.child.calculateMaxPeekMemory() + this.child.calculateRetainedSizeAfterCallingNext();
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.child.calculateMaxReturnSize();
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.child.calculateRetainedSizeAfterCallingNext();
    }

    private boolean isCachedTsBlockEnough(int columnIndex, long currentEndRowIndex) {
        while (this.nextTsBlockIndex[columnIndex] < this.cachedTsBlock.size()) {
            TsBlock nextTsBlock = this.cachedTsBlock.get(this.nextTsBlockIndex[columnIndex]);
            long startRowIndex = this.cachedRowIndex.get(this.nextTsBlockIndex[columnIndex]);
            int n = columnIndex;
            this.nextTsBlockIndex[n] = this.nextTsBlockIndex[n] + 1;
            if (!this.fillArray[columnIndex].prepareForNext(startRowIndex, currentEndRowIndex, nextTsBlock.getTimeColumn(), nextTsBlock.getColumn(columnIndex))) continue;
            return true;
        }
        return false;
    }

    private boolean tryToGetNextTsBlock() throws Exception {
        if (this.canCallNext) {
            this.canCallNext = false;
            TsBlock nextTsBlock = this.child.nextWithTimer();
            if (nextTsBlock == null || nextTsBlock.isEmpty()) {
                return false;
            }
            this.cachedTsBlock.add(nextTsBlock);
            this.cachedRowIndex.add(this.currentRowIndex);
            this.currentRowIndex += (long)nextTsBlock.getPositionCount();
            return true;
        }
        return false;
    }
}

