/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator;

import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.AggrWindowIterator;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.PreAggrWindowIterator;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.PreAggrWindowWithNaturalMonthIterator;

public class TimeRangeIteratorFactory {
    private TimeRangeIteratorFactory() {
    }

    public static ITimeRangeIterator getTimeRangeIterator(long startTime, long endTime, long interval, long slidingStep, boolean isAscending, boolean isIntervalByMonth, boolean isSlidingStepByMonth, boolean leftCRightO, boolean outputPartialTimeWindow) {
        long originInterval = interval;
        long originSlidingStep = slidingStep;
        interval = isIntervalByMonth ? interval / 2592000000L : interval;
        long l = slidingStep = isSlidingStepByMonth ? slidingStep / 2592000000L : slidingStep;
        if (outputPartialTimeWindow && originInterval > originSlidingStep) {
            if (!isIntervalByMonth && !isSlidingStepByMonth) {
                return new PreAggrWindowIterator(startTime, endTime, interval, slidingStep, isAscending, leftCRightO);
            }
            return new PreAggrWindowWithNaturalMonthIterator(startTime, endTime, interval, slidingStep, isAscending, isSlidingStepByMonth, isIntervalByMonth, leftCRightO);
        }
        return new AggrWindowIterator(startTime, endTime, interval, slidingStep, isAscending, isSlidingStepByMonth, isIntervalByMonth, leftCRightO);
    }
}

