/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.aggregation.Accumulator;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class FirstValueAccumulator
implements Accumulator {
    protected final TSDataType seriesDataType;
    protected boolean hasCandidateResult;
    protected TsPrimitiveType firstValue;
    protected long minTime = Long.MAX_VALUE;

    public FirstValueAccumulator(TSDataType seriesDataType) {
        this.seriesDataType = seriesDataType;
        this.firstValue = TsPrimitiveType.getByType((TSDataType)seriesDataType);
    }

    @Override
    public void addInput(Column[] column, BitMap bitMap, int lastIndex) {
        switch (this.seriesDataType) {
            case INT32: {
                this.addIntInput(column, bitMap, lastIndex);
                return;
            }
            case INT64: {
                this.addLongInput(column, bitMap, lastIndex);
                return;
            }
            case FLOAT: {
                this.addFloatInput(column, bitMap, lastIndex);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(column, bitMap, lastIndex);
                return;
            }
            case TEXT: {
                this.addBinaryInput(column, bitMap, lastIndex);
                return;
            }
            case BOOLEAN: {
                this.addBooleanInput(column, bitMap, lastIndex);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in FirstValue: %s", this.seriesDataType));
    }

    @Override
    public void addIntermediate(Column[] partialResult) {
        Preconditions.checkArgument((partialResult.length == 2 ? 1 : 0) != 0, (Object)"partialResult of FirstValue should be 2");
        if (partialResult[0].isNull(0)) {
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                this.updateIntFirstValue(partialResult[0].getInt(0), partialResult[1].getLong(0));
                break;
            }
            case INT64: {
                this.updateLongFirstValue(partialResult[0].getLong(0), partialResult[1].getLong(0));
                break;
            }
            case FLOAT: {
                this.updateFloatFirstValue(partialResult[0].getFloat(0), partialResult[1].getLong(0));
                break;
            }
            case DOUBLE: {
                this.updateDoubleFirstValue(partialResult[0].getDouble(0), partialResult[1].getLong(0));
                break;
            }
            case TEXT: {
                this.updateBinaryFirstValue(partialResult[0].getBinary(0), partialResult[1].getLong(0));
                break;
            }
            case BOOLEAN: {
                this.updateBooleanFirstValue(partialResult[0].getBoolean(0), partialResult[1].getLong(0));
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in FirstValue: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void addStatistics(Statistics statistics) {
        if (statistics == null) {
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                this.updateIntFirstValue((Integer)statistics.getFirstValue(), statistics.getStartTime());
                break;
            }
            case INT64: {
                this.updateLongFirstValue((Long)statistics.getFirstValue(), statistics.getStartTime());
                break;
            }
            case FLOAT: {
                this.updateFloatFirstValue(((Float)statistics.getFirstValue()).floatValue(), statistics.getStartTime());
                break;
            }
            case DOUBLE: {
                this.updateDoubleFirstValue((Double)statistics.getFirstValue(), statistics.getStartTime());
                break;
            }
            case TEXT: {
                this.updateBinaryFirstValue((Binary)statistics.getFirstValue(), statistics.getStartTime());
                break;
            }
            case BOOLEAN: {
                this.updateBooleanFirstValue((Boolean)statistics.getFirstValue(), statistics.getStartTime());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in FirstValue: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void setFinal(Column finalResult) {
        this.reset();
        if (!finalResult.isNull(0)) {
            this.hasCandidateResult = true;
            switch (this.seriesDataType) {
                case INT32: {
                    this.firstValue.setInt(finalResult.getInt(0));
                    break;
                }
                case INT64: {
                    this.firstValue.setLong(finalResult.getLong(0));
                    break;
                }
                case FLOAT: {
                    this.firstValue.setFloat(finalResult.getFloat(0));
                    break;
                }
                case DOUBLE: {
                    this.firstValue.setDouble(finalResult.getDouble(0));
                    break;
                }
                case TEXT: {
                    this.firstValue.setBinary(finalResult.getBinary(0));
                    break;
                }
                case BOOLEAN: {
                    this.firstValue.setBoolean(finalResult.getBoolean(0));
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type in FirstValue: %s", this.seriesDataType));
                }
            }
        }
    }

    @Override
    public void outputIntermediate(ColumnBuilder[] columnBuilders) {
        Preconditions.checkArgument((columnBuilders.length == 2 ? 1 : 0) != 0, (Object)"partialResult of FirstValue should be 2");
        if (!this.hasCandidateResult) {
            columnBuilders[0].appendNull();
            columnBuilders[1].appendNull();
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                columnBuilders[0].writeInt(this.firstValue.getInt());
                break;
            }
            case INT64: {
                columnBuilders[0].writeLong(this.firstValue.getLong());
                break;
            }
            case FLOAT: {
                columnBuilders[0].writeFloat(this.firstValue.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilders[0].writeDouble(this.firstValue.getDouble());
                break;
            }
            case TEXT: {
                columnBuilders[0].writeBinary(this.firstValue.getBinary());
                break;
            }
            case BOOLEAN: {
                columnBuilders[0].writeBoolean(this.firstValue.getBoolean());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in Extreme: %s", this.seriesDataType));
            }
        }
        columnBuilders[1].writeLong(this.minTime);
    }

    @Override
    public void outputFinal(ColumnBuilder columnBuilder) {
        if (!this.hasCandidateResult) {
            columnBuilder.appendNull();
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                columnBuilder.writeInt(this.firstValue.getInt());
                break;
            }
            case INT64: {
                columnBuilder.writeLong(this.firstValue.getLong());
                break;
            }
            case FLOAT: {
                columnBuilder.writeFloat(this.firstValue.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilder.writeDouble(this.firstValue.getDouble());
                break;
            }
            case TEXT: {
                columnBuilder.writeBinary(this.firstValue.getBinary());
                break;
            }
            case BOOLEAN: {
                columnBuilder.writeBoolean(this.firstValue.getBoolean());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in Extreme: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void reset() {
        this.hasCandidateResult = false;
        this.minTime = Long.MAX_VALUE;
        this.firstValue.reset();
    }

    @Override
    public boolean hasFinalResult() {
        return this.hasCandidateResult;
    }

    @Override
    public TSDataType[] getIntermediateType() {
        return new TSDataType[]{this.firstValue.getDataType(), TSDataType.INT64};
    }

    @Override
    public TSDataType getFinalType() {
        return this.firstValue.getDataType();
    }

    protected void addIntInput(Column[] column, BitMap bitMap, int lastIndex) {
        for (int i = 0; i <= lastIndex; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateIntFirstValue(column[1].getInt(i), column[0].getLong(i));
            return;
        }
    }

    protected void updateIntFirstValue(int value, long curTime) {
        this.hasCandidateResult = true;
        if (curTime < this.minTime) {
            this.minTime = curTime;
            this.firstValue.setInt(value);
        }
    }

    protected void addLongInput(Column[] column, BitMap bitMap, int lastIndex) {
        for (int i = 0; i <= lastIndex; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateLongFirstValue(column[1].getLong(i), column[0].getLong(i));
            return;
        }
    }

    protected void updateLongFirstValue(long value, long curTime) {
        this.hasCandidateResult = true;
        if (curTime < this.minTime) {
            this.minTime = curTime;
            this.firstValue.setLong(value);
        }
    }

    protected void addFloatInput(Column[] column, BitMap bitMap, int lastIndex) {
        for (int i = 0; i <= lastIndex; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateFloatFirstValue(column[1].getFloat(i), column[0].getLong(i));
            return;
        }
    }

    protected void updateFloatFirstValue(float value, long curTime) {
        this.hasCandidateResult = true;
        if (curTime < this.minTime) {
            this.minTime = curTime;
            this.firstValue.setFloat(value);
        }
    }

    protected void addDoubleInput(Column[] column, BitMap bitMap, int lastIndex) {
        for (int i = 0; i <= lastIndex; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateDoubleFirstValue(column[1].getDouble(i), column[0].getLong(i));
            return;
        }
    }

    protected void updateDoubleFirstValue(double value, long curTime) {
        this.hasCandidateResult = true;
        if (curTime < this.minTime) {
            this.minTime = curTime;
            this.firstValue.setDouble(value);
        }
    }

    protected void addBooleanInput(Column[] column, BitMap bitMap, int lastIndex) {
        for (int i = 0; i <= lastIndex; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateBooleanFirstValue(column[1].getBoolean(i), column[0].getLong(i));
            return;
        }
    }

    protected void updateBooleanFirstValue(boolean value, long curTime) {
        this.hasCandidateResult = true;
        if (curTime < this.minTime) {
            this.minTime = curTime;
            this.firstValue.setBoolean(value);
        }
    }

    protected void addBinaryInput(Column[] column, BitMap bitMap, int lastIndex) {
        for (int i = 0; i <= lastIndex; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.updateBinaryFirstValue(column[1].getBinary(i), column[0].getLong(i));
            return;
        }
    }

    protected void updateBinaryFirstValue(Binary value, long curTime) {
        this.hasCandidateResult = true;
        if (curTime < this.minTime) {
            this.minTime = curTime;
            this.firstValue.setBinary(value);
        }
    }
}

