/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common.schematree.visitor;

import java.util.Map;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.fa.IFAState;
import org.apache.iotdb.commons.path.fa.IFATransition;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaNode;
import org.apache.iotdb.db.queryengine.common.schematree.visitor.SchemaTreeVisitor;

public class SchemaTreeMeasurementVisitor
extends SchemaTreeVisitor<MeasurementPath> {
    private final String tailNode;

    public SchemaTreeMeasurementVisitor(SchemaNode root, PartialPath pathPattern, boolean isPrefixMatch) {
        super(root, pathPattern, isPrefixMatch);
        this.tailNode = pathPattern.getTailNode();
    }

    protected boolean mayTargetNodeType(SchemaNode node) {
        return node.isMeasurement();
    }

    protected IFAState tryGetNextState(SchemaNode node, IFAState sourceState, Map<String, IFATransition> preciseMatchTransitionMap) {
        if (node.isMeasurement()) {
            IFAState state;
            IFATransition transition;
            String alias = node.getAsMeasurementNode().getAlias();
            if (alias != null && (transition = preciseMatchTransitionMap.get(alias)) != null && (state = this.patternFA.getNextState(sourceState, transition)).isFinal()) {
                return state;
            }
            transition = preciseMatchTransitionMap.get(node.getName());
            if (transition != null && (state = this.patternFA.getNextState(sourceState, transition)).isFinal()) {
                return state;
            }
            return null;
        }
        IFATransition transition = preciseMatchTransitionMap.get(node.getName());
        if (transition == null) {
            return null;
        }
        return this.patternFA.getNextState(sourceState, transition);
    }

    protected IFAState tryGetNextState(SchemaNode node, IFAState sourceState, IFATransition transition) {
        if (node.isMeasurement()) {
            IFAState state;
            String alias = node.getAsMeasurementNode().getAlias();
            if (alias != null && transition.isMatch(alias) && (state = this.patternFA.getNextState(sourceState, transition)).isFinal()) {
                return state;
            }
            if (transition.isMatch(node.getName()) && (state = this.patternFA.getNextState(sourceState, transition)).isFinal()) {
                return state;
            }
            return null;
        }
        if (transition.isMatch(node.getName())) {
            return this.patternFA.getNextState(sourceState, transition);
        }
        return null;
    }

    protected boolean acceptInternalMatchedNode(SchemaNode node) {
        return false;
    }

    protected boolean acceptFullMatchedNode(SchemaNode node) {
        return node.isMeasurement();
    }

    protected MeasurementPath generateResult(SchemaNode nextMatchedNode) {
        MeasurementPath result = new MeasurementPath(this.getFullPathFromRootToNode(nextMatchedNode), nextMatchedNode.getAsMeasurementNode().getSchema());
        result.setTagMap(nextMatchedNode.getAsMeasurementNode().getTagMap());
        result.setUnderAlignedEntity(Boolean.valueOf(((SchemaNode)this.getParentOfNextMatchedNode()).getAsEntityNode().isAligned()));
        String alias = nextMatchedNode.getAsMeasurementNode().getAlias();
        if (this.tailNode.equals(alias)) {
            result.setMeasurementAlias(alias);
        }
        return result;
    }
}

