/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.exception.metadata;

import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.rpc.TSStatusCode;

public class PathNotExistException
extends MetadataException {
    private static final String PATH_NOT_EXIST_WRONG_MESSAGE = "Path [%s] does not exist";
    private static final String SOURCE_PATH_NOT_EXIST_WRONG_MESSAGE = "The source path [%s] of view [%s] does not exist.";
    private static final String NORMAL_TIMESERIES_NOT_EXIST_WRONG_MESSAGE = "Timeseries [%s] does not exist or is represented by schema template";
    private static final String TEMPLATE_TIMESERIES_NOT_EXIST_WRONG_MESSAGE = "Timeseries [%s] does not exist or is not represented by schema template";

    public PathNotExistException(String sourcePath, String viewPath) {
        super(String.format(SOURCE_PATH_NOT_EXIST_WRONG_MESSAGE, sourcePath, viewPath), TSStatusCode.PATH_NOT_EXIST.getStatusCode());
    }

    public PathNotExistException(String path) {
        super(String.format(PATH_NOT_EXIST_WRONG_MESSAGE, path), TSStatusCode.PATH_NOT_EXIST.getStatusCode());
    }

    public PathNotExistException(String path, boolean isUserException) {
        super(String.format(PATH_NOT_EXIST_WRONG_MESSAGE, path), TSStatusCode.PATH_NOT_EXIST.getStatusCode(), isUserException);
    }

    public PathNotExistException(List<String> paths) {
        super(String.format(PATH_NOT_EXIST_WRONG_MESSAGE, paths.size() == 1 ? paths.get(0) : paths.get(0) + " ... " + paths.get(paths.size() - 1)), TSStatusCode.PATH_NOT_EXIST.getStatusCode());
    }

    public PathNotExistException(List<String> paths, boolean isTemplateSeries) {
        super(String.format(isTemplateSeries ? TEMPLATE_TIMESERIES_NOT_EXIST_WRONG_MESSAGE : NORMAL_TIMESERIES_NOT_EXIST_WRONG_MESSAGE, paths.size() == 1 ? paths.get(0) : paths.get(0) + " ... " + paths.get(paths.size() - 1)), TSStatusCode.PATH_NOT_EXIST.getStatusCode());
    }
}

