/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.system;

import com.sun.management.OperatingSystemMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.metrics.utils.SystemMetric;
import org.apache.iotdb.metrics.utils.SystemTag;
import org.apache.iotdb.tsfile.utils.FSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemMetrics
implements IMetricSet {
    private static final Logger logger = LoggerFactory.getLogger(SystemMetrics.class);
    private static final String SYSTEM = "system";
    private final OperatingSystemMXBean osMxBean;
    private final Set<FileStore> fileStores = new HashSet<FileStore>();
    private final ArrayList<String> diskDirs;

    public SystemMetrics(ArrayList<String> diskDirs) {
        this.diskDirs = diskDirs;
        this.osMxBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    }

    @Override
    public void bindTo(AbstractMetricService metricService) {
        this.collectSystemCpuInfo(metricService);
        this.collectSystemMemInfo(metricService);
        this.collectSystemDiskInfo(metricService);
    }

    @Override
    public void unbindFrom(AbstractMetricService metricService) {
        this.removeSystemCpuInfo(metricService);
        this.removeSystemDiskInfo(metricService);
        this.removeSystemMemInfo(metricService);
    }

    private void collectSystemCpuInfo(AbstractMetricService metricService) {
        metricService.createAutoGauge(SystemMetric.SYS_CPU_LOAD.toString(), MetricLevel.CORE, this.osMxBean, a -> this.osMxBean.getSystemCpuLoad() * 100.0, SystemTag.NAME.toString(), SYSTEM);
        metricService.getOrCreateGauge(SystemMetric.SYS_CPU_CORES.toString(), MetricLevel.CORE, SystemTag.NAME.toString(), SYSTEM).set(this.osMxBean.getAvailableProcessors());
    }

    private void removeSystemCpuInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.SYS_CPU_LOAD.toString(), SystemTag.NAME.toString(), SYSTEM);
        metricService.remove(MetricType.GAUGE, SystemMetric.SYS_CPU_CORES.toString(), SystemTag.NAME.toString(), SYSTEM);
    }

    private void collectSystemMemInfo(AbstractMetricService metricService) {
        metricService.getOrCreateGauge(SystemMetric.SYS_TOTAL_PHYSICAL_MEMORY_SIZE.toString(), MetricLevel.CORE, SystemTag.NAME.toString(), SYSTEM).set(this.osMxBean.getTotalPhysicalMemorySize());
        metricService.createAutoGauge(SystemMetric.SYS_FREE_PHYSICAL_MEMORY_SIZE.toString(), MetricLevel.CORE, this.osMxBean, a -> this.osMxBean.getFreePhysicalMemorySize(), SystemTag.NAME.toString(), SYSTEM);
        metricService.createAutoGauge(SystemMetric.SYS_TOTAL_SWAP_SPACE_SIZE.toString(), MetricLevel.CORE, this.osMxBean, a -> this.osMxBean.getTotalSwapSpaceSize(), SystemTag.NAME.toString(), SYSTEM);
        metricService.createAutoGauge(SystemMetric.SYS_FREE_SWAP_SPACE_SIZE.toString(), MetricLevel.CORE, this.osMxBean, a -> this.osMxBean.getFreeSwapSpaceSize(), SystemTag.NAME.toString(), SYSTEM);
        metricService.createAutoGauge(SystemMetric.SYS_COMMITTED_VM_SIZE.toString(), MetricLevel.CORE, this.osMxBean, a -> this.osMxBean.getCommittedVirtualMemorySize(), SystemTag.NAME.toString(), SYSTEM);
    }

    private void removeSystemMemInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.GAUGE, SystemMetric.SYS_TOTAL_PHYSICAL_MEMORY_SIZE.toString(), SystemTag.NAME.toString(), SYSTEM);
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.SYS_FREE_PHYSICAL_MEMORY_SIZE.toString(), SystemTag.NAME.toString(), SYSTEM);
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.SYS_TOTAL_SWAP_SPACE_SIZE.toString(), SystemTag.NAME.toString(), SYSTEM);
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.SYS_FREE_SWAP_SPACE_SIZE.toString(), SystemTag.NAME.toString(), SYSTEM);
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.SYS_COMMITTED_VM_SIZE.toString(), SystemTag.NAME.toString(), SYSTEM);
    }

    private void collectSystemDiskInfo(AbstractMetricService metricService) {
        for (String diskDir : this.diskDirs) {
            if (!FSUtils.isLocal((String)diskDir)) continue;
            Path path = Paths.get(diskDir, new String[0]);
            FileStore fileStore = null;
            try {
                fileStore = Files.getFileStore(path);
            }
            catch (IOException e) {
                path = path.getParent();
                try {
                    fileStore = Files.getFileStore(path);
                }
                catch (IOException innerException) {
                    logger.error("Failed to get storage path of {}, because", (Object)diskDir, (Object)innerException);
                }
            }
            if (null == fileStore) continue;
            this.fileStores.add(fileStore);
        }
        metricService.createAutoGauge(SystemMetric.SYS_DISK_TOTAL_SPACE.toString(), MetricLevel.CORE, this, SystemMetrics::getSystemDiskTotalSpace, SystemTag.NAME.toString(), SYSTEM);
        metricService.createAutoGauge(SystemMetric.SYS_DISK_FREE_SPACE.toString(), MetricLevel.CORE, this, SystemMetrics::getSystemDiskFreeSpace, SystemTag.NAME.toString(), SYSTEM);
    }

    private void removeSystemDiskInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.SYS_DISK_TOTAL_SPACE.toString(), SystemTag.NAME.toString(), SYSTEM);
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.SYS_DISK_FREE_SPACE.toString(), SystemTag.NAME.toString(), SYSTEM);
        this.diskDirs.clear();
        this.fileStores.clear();
    }

    public long getSystemDiskTotalSpace() {
        long sysTotalSpace = 0L;
        for (FileStore fileStore : this.fileStores) {
            try {
                sysTotalSpace += fileStore.getTotalSpace();
            }
            catch (IOException e) {
                logger.error("Failed to statistic the size of {}, because", (Object)fileStore, (Object)e);
            }
        }
        return sysTotalSpace;
    }

    public long getSystemDiskFreeSpace() {
        long sysFreeSpace = 0L;
        for (FileStore fileStore : this.fileStores) {
            try {
                sysFreeSpace += fileStore.getUsableSpace();
            }
            catch (IOException e) {
                logger.error("Failed to statistic the size of {}, because", (Object)fileStore, (Object)e);
            }
        }
        return sysFreeSpace;
    }
}

