/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.structure;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;

public class BalanceTreeMap<K, V extends Comparable<V>> {
    private final HashMap<K, V> keyValueMap = new HashMap();
    private final TreeMap<V, Set<K>> valueKeysMap = new TreeMap();

    public void put(K key, V value) {
        Comparable oldValue = (Comparable)this.keyValueMap.put(key, value);
        if (oldValue != null) {
            Set<K> keysSet = this.valueKeysMap.get(oldValue);
            keysSet.remove(key);
            if (keysSet.isEmpty()) {
                this.valueKeysMap.remove(oldValue);
            }
        }
        this.valueKeysMap.computeIfAbsent((Set)value, (Function<Set, Set<Comparable>>)((Function<Comparable, Set>)empty -> new HashSet())).add(key);
    }

    public K getKeyWithMinValue() {
        return this.valueKeysMap.firstEntry().getValue().iterator().next();
    }

    public V get(K key) {
        return (V)((Comparable)this.keyValueMap.getOrDefault(key, null));
    }

    public boolean containsKey(K key) {
        return this.keyValueMap.containsKey(key);
    }

    public int size() {
        return this.keyValueMap.size();
    }

    public void remove(K key) {
        Comparable value = (Comparable)this.keyValueMap.remove(key);
        if (value != null) {
            Set<K> keysSet = this.valueKeysMap.get(value);
            keysSet.remove(key);
            if (keysSet.isEmpty()) {
                this.valueKeysMap.remove(value);
            }
        }
    }

    public boolean isEmpty() {
        return this.keyValueMap.isEmpty() && this.valueKeysMap.isEmpty();
    }
}

