/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PathPatternUtil;
import org.apache.iotdb.commons.path.PathType;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartialPath
extends Path
implements Comparable<Path>,
Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(PartialPath.class);
    protected String[] nodes;

    public PartialPath() {
    }

    public PartialPath(String path) throws IllegalPathException {
        this.nodes = PathUtils.splitPathToDetachedNodes(path);
        if (this.nodes.length == 0) {
            throw new IllegalPathException(path);
        }
        this.fullPath = this.getFullPath();
    }

    public PartialPath(String device, String measurement) throws IllegalPathException {
        String path = device + "." + measurement;
        this.nodes = PathUtils.splitPathToDetachedNodes(path);
        this.fullPath = this.getFullPath();
    }

    public PartialPath(String[] partialNodes) {
        this.nodes = partialNodes;
    }

    public PartialPath(String path, boolean needSplit) {
        Validate.isTrue((!needSplit ? 1 : 0) != 0);
        this.fullPath = path;
        this.nodes = "".equals(path) ? new String[0] : new String[]{path};
    }

    public boolean hasWildcard() {
        for (String node : this.nodes) {
            if (!PathPatternUtil.hasWildcard(node)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMultiLevelMatchWildcard() {
        for (String node : this.nodes) {
            if (!PathPatternUtil.hasMultiLevelMatchWildcard(node)) continue;
            return true;
        }
        return false;
    }

    public boolean hasExplicitDevice() {
        if (this.nodes[this.nodes.length - 1].equals("**")) {
            return false;
        }
        for (int i = 0; i < this.nodes.length - 1; ++i) {
            if (!PathPatternUtil.hasWildcard(this.nodes[i])) continue;
            return false;
        }
        return true;
    }

    public PartialPath concatPath(PartialPath partialPath) {
        int len = this.nodes.length;
        String[] newNodes = Arrays.copyOf(this.nodes, this.nodes.length + partialPath.nodes.length);
        System.arraycopy(partialPath.nodes, 0, newNodes, len, partialPath.nodes.length);
        return new PartialPath(newNodes);
    }

    public void concatPath(String[] otherNodes) {
        int len = this.nodes.length;
        this.nodes = Arrays.copyOf(this.nodes, this.nodes.length + otherNodes.length);
        System.arraycopy(otherNodes, 0, this.nodes, len, otherNodes.length);
        this.fullPath = String.join((CharSequence)".", this.nodes);
    }

    public PartialPath concatNode(String node) {
        String[] newPathNodes = Arrays.copyOf(this.nodes, this.nodes.length + 1);
        newPathNodes[newPathNodes.length - 1] = node;
        return new PartialPath(newPathNodes);
    }

    public String[] getNodes() {
        return this.nodes;
    }

    public int getNodeLength() {
        return this.nodes.length;
    }

    public String getTailNode() {
        if (this.nodes.length <= 0) {
            return "";
        }
        return this.nodes[this.nodes.length - 1];
    }

    public List<PartialPath> alterPrefixPath(PartialPath prefix) {
        Validate.notNull((Object)prefix);
        for (String node : prefix.getNodes()) {
            if (!"**".equals(node) && !"*".equals(node)) continue;
            throw new IllegalArgumentException("Wildcards are not allowed in the prefix path: " + prefix.getFullPath());
        }
        ArrayList<List<String>> results = new ArrayList<List<String>>();
        this.alterPrefixPathInternal(Arrays.asList(prefix.getNodes()), Arrays.asList(this.nodes), new ArrayList<String>(), results);
        return results.stream().map(r -> new PartialPath(r.toArray(new String[0]))).collect(Collectors.toList());
    }

    private boolean alterPrefixPathInternal(List<String> prefix, List<String> path, List<String> current, List<List<String>> results) {
        if (prefix.isEmpty()) {
            current.addAll(path);
            results.add(current);
            return !path.isEmpty() && "**".equals(path.get(0));
        }
        if (path.isEmpty()) {
            return false;
        }
        if ("**".equals(path.get(0))) {
            for (int j = 1; j <= prefix.size(); ++j) {
                ArrayList<String> copy = new ArrayList<String>(current);
                copy.addAll(prefix.subList(0, j));
                if (!this.alterPrefixPathInternal(prefix.subList(j, prefix.size()), path.subList(1, path.size()), copy, results)) continue;
                return true;
            }
            ArrayList<String> copy = new ArrayList<String>(current);
            copy.addAll(prefix);
            return this.alterPrefixPathInternal(Collections.emptyList(), path.subList(0, path.size()), copy, results);
        }
        if ("*".equals(path.get(0)) || prefix.get(0).equals(path.get(0))) {
            current.add(prefix.get(0));
            return this.alterPrefixPathInternal(prefix.subList(1, prefix.size()), path.subList(1, path.size()), current, results);
        }
        return false;
    }

    public boolean matchFullPath(PartialPath rPath) {
        return this.matchPath(rPath.getNodes(), 0, 0, false, false);
    }

    public boolean matchPrefixPath(PartialPath prefixPath) {
        return this.matchPath(prefixPath.getNodes(), 0, 0, false, true);
    }

    private boolean matchPath(String[] pathNodes, int pathIndex, int patternIndex, boolean multiLevelWild, boolean pathIsPrefix) {
        if (pathIndex == pathNodes.length && patternIndex == this.nodes.length) {
            return true;
        }
        if (patternIndex == this.nodes.length && multiLevelWild) {
            return this.matchPath(pathNodes, pathIndex + 1, patternIndex, true, pathIsPrefix);
        }
        if (pathIndex >= pathNodes.length) {
            return pathIsPrefix;
        }
        if (patternIndex >= this.nodes.length) {
            return false;
        }
        String pathNode = pathNodes[pathIndex];
        String patternNode = this.nodes[patternIndex];
        boolean isMatch = false;
        if (patternNode.equals("**")) {
            isMatch = this.matchPath(pathNodes, pathIndex + 1, patternIndex + 1, true, pathIsPrefix);
        } else {
            if (PathPatternUtil.hasWildcard(patternNode)) {
                if (PathPatternUtil.isNodeMatch(patternNode, pathNode)) {
                    isMatch = this.matchPath(pathNodes, pathIndex + 1, patternIndex + 1, false, pathIsPrefix);
                }
            } else if (patternNode.equals(pathNode)) {
                isMatch = this.matchPath(pathNodes, pathIndex + 1, patternIndex + 1, false, pathIsPrefix);
            }
            if (!isMatch && multiLevelWild) {
                isMatch = this.matchPath(pathNodes, pathIndex + 1, patternIndex, true, pathIsPrefix);
            }
        }
        return isMatch;
    }

    public boolean prefixMatchFullPath(PartialPath rPath) {
        String[] rNodes = rPath.getNodes();
        if (this.nodes.length > rNodes.length) {
            return false;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i].equals("**")) {
                return true;
            }
            if (this.nodes[i].equals("*")) continue;
            if (PathPatternUtil.hasWildcard(this.nodes[i])) {
                if (PathPatternUtil.isNodeMatch(this.nodes[i], rNodes[i])) continue;
                return false;
            }
            if (this.nodes[i].equals(rNodes[i])) continue;
            return false;
        }
        return true;
    }

    public boolean include(PartialPath rPath) {
        String[] rNodes = rPath.getNodes();
        String[] lNodes = (String[])this.nodes.clone();
        for (int i = 1; i < lNodes.length; ++i) {
            if ("**".equals(lNodes[i - 1]) && "*".equals(lNodes[i])) {
                lNodes[i] = "**";
            }
            if (!"**".equals(lNodes[lNodes.length - i]) || !"*".equals(lNodes[lNodes.length - 1 - i])) continue;
            lNodes[lNodes.length - 1 - i] = "**";
        }
        boolean[] dp = new boolean[rNodes.length + 1];
        dp[0] = true;
        for (int i = 1; i <= lNodes.length; ++i) {
            boolean[] newDp = new boolean[rNodes.length + 1];
            for (int j = i; j <= rNodes.length; ++j) {
                if (lNodes[i - 1].equals("**")) {
                    if (!dp[j - 1]) continue;
                    for (int k = j; k <= rNodes.length; ++k) {
                        newDp[k] = true;
                    }
                    break;
                }
                if (rNodes[j - 1].equals("**") || (!PathPatternUtil.hasWildcard(lNodes[i - 1]) || !PathPatternUtil.isNodeMatch(lNodes[i - 1], rNodes[j - 1])) && !lNodes[i - 1].equals(rNodes[j - 1])) continue;
                int n = j;
                newDp[n] = newDp[n] | dp[j - 1];
            }
            dp = newDp;
        }
        return dp[rNodes.length];
    }

    public boolean overlapWith(PartialPath rPath) {
        String[] rNodes = rPath.getNodes();
        for (int i = 0; i < this.nodes.length && i < rNodes.length; ++i) {
            if (this.nodes[i].equals("**") || rNodes[i].equals("**")) {
                return this.checkOverlapWithMultiLevelWildcard(this.nodes, rNodes);
            }
            if (PathPatternUtil.hasWildcard(this.nodes[i]) && PathPatternUtil.isNodeMatch(this.nodes[i], rNodes[i]) || PathPatternUtil.hasWildcard(rNodes[i]) && PathPatternUtil.isNodeMatch(rNodes[i], this.nodes[i]) || this.nodes[i].equals(rNodes[i])) continue;
            return false;
        }
        return this.nodes.length == rNodes.length;
    }

    public boolean overlapWithFullPathPrefix(PartialPath prefixFullPath) {
        String[] rNodes = prefixFullPath.getNodes();
        int rNodesIndex = 0;
        for (int i = 0; i < this.nodes.length && rNodesIndex < rNodes.length; ++i) {
            if (this.nodes[i].equals("**")) {
                return true;
            }
            if (this.nodes[i].equals("*")) {
                ++rNodesIndex;
                continue;
            }
            if (PathPatternUtil.hasWildcard(this.nodes[i])) {
                if (!PathPatternUtil.isNodeMatch(this.nodes[i], rNodes[rNodesIndex])) {
                    return false;
                }
                ++rNodesIndex;
                continue;
            }
            if (this.nodes[i].equals(rNodes[rNodesIndex])) {
                ++rNodesIndex;
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean checkOverlapWithMultiLevelWildcard(String[] nodes1, String[] nodes2) {
        boolean[][] dp = new boolean[nodes1.length + 1][nodes2.length + 1];
        dp[0][0] = true;
        for (int i = 1; i <= nodes1.length; ++i) {
            for (int j = 1; j <= nodes2.length; ++j) {
                if (nodes1[i - 1].equals("**") || nodes2[j - 1].equals("**")) {
                    int k;
                    if (nodes1[i - 1].equals("**") && dp[i - 1][j - 1]) {
                        for (k = j; k <= nodes2.length; ++k) {
                            dp[i][k] = true;
                        }
                    }
                    if (!nodes2[j - 1].equals("**") || !dp[i - 1][j - 1]) continue;
                    for (k = i; k <= nodes1.length; ++k) {
                        dp[k][j] = true;
                    }
                    continue;
                }
                if (!(PathPatternUtil.hasWildcard(nodes1[i - 1]) && PathPatternUtil.isNodeMatch(nodes1[i - 1], nodes2[j - 1]) || PathPatternUtil.hasWildcard(nodes2[j - 1]) && PathPatternUtil.isNodeMatch(nodes2[j - 1], nodes1[i - 1])) && !nodes1[i - 1].equals(nodes2[j - 1])) continue;
                boolean[] blArray = dp[i];
                int n = j;
                blArray[n] = blArray[n] | dp[i - 1][j - 1];
            }
        }
        return dp[nodes1.length][nodes2.length];
    }

    public String getFullPath() {
        if (this.fullPath == null) {
            StringBuilder s = new StringBuilder(this.nodes[0]);
            for (int i = 1; i < this.nodes.length; ++i) {
                s.append(".").append(this.nodes[i]);
            }
            this.fullPath = s.toString();
        }
        return this.fullPath;
    }

    public PartialPath copy() {
        PartialPath result = new PartialPath();
        result.nodes = this.nodes;
        result.fullPath = this.fullPath;
        result.device = this.device;
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PartialPath)) {
            return false;
        }
        String[] otherNodes = ((PartialPath)obj).getNodes();
        if (this.nodes.length != otherNodes.length) {
            return false;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i].equals(otherNodes[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(String obj) {
        return this.getFullPath().equals(obj);
    }

    public int hashCode() {
        int h = 0;
        for (String node : this.nodes) {
            h += 31 * h + node.hashCode();
        }
        return h;
    }

    public String getMeasurement() {
        return this.nodes[this.nodes.length - 1];
    }

    public String getFirstNode() {
        return this.nodes[0];
    }

    public String getDevice() {
        if (this.device != null) {
            return this.device;
        }
        if (this.nodes.length == 1) {
            return "";
        }
        StringBuilder s = new StringBuilder(this.nodes[0]);
        for (int i = 1; i < this.nodes.length - 1; ++i) {
            s.append(".");
            s.append(this.nodes[i]);
        }
        this.device = s.toString();
        return this.device;
    }

    public String getMeasurementAlias() {
        throw new RuntimeException("Only MeasurementPath support alias");
    }

    public void setMeasurementAlias(String measurementAlias) {
        throw new RuntimeException("Only MeasurementPath support alias");
    }

    public boolean isMeasurementAliasExists() {
        return false;
    }

    public String getFullPathWithAlias() {
        throw new RuntimeException("Only MeasurementPath support alias");
    }

    public IMeasurementSchema getMeasurementSchema() throws MetadataException {
        throw new MetadataException("This path doesn't represent a measurement");
    }

    public TSDataType getSeriesType() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This path doesn't represent a measurement");
    }

    @Override
    public int compareTo(Path path) {
        PartialPath partialPath = (PartialPath)path;
        return this.getFullPath().compareTo(partialPath.getFullPath());
    }

    public boolean startsWithOrPrefixOf(String[] otherNodes) {
        for (int i = 0; i < otherNodes.length && i < this.nodes.length; ++i) {
            if (this.nodes[i].equals(otherNodes[i])) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String prefix) {
        return this.getFullPath().startsWith(prefix);
    }

    public boolean containNode(String otherNode) {
        for (String node : this.nodes) {
            if (!node.equals(otherNode)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getFullPath();
    }

    public PartialPath getDevicePath() {
        return new PartialPath(Arrays.copyOf(this.nodes, this.nodes.length - 1));
    }

    public List<PartialPath> getDevicePathPattern() {
        ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        result.add(this.getDevicePath());
        if (this.nodes[this.nodes.length - 1].equals("**")) {
            result.add(new PartialPath(this.nodes));
        }
        return result;
    }

    public Path toTSFilePath() {
        return new Path(this.getDevice(), this.getMeasurement(), true);
    }

    public static List<String> toStringList(List<PartialPath> pathList) {
        ArrayList<String> ret = new ArrayList<String>();
        for (PartialPath path : pathList) {
            ret.add(path.getFullPath());
        }
        return ret;
    }

    public static List<PartialPath> fromStringList(List<String> pathList) {
        if (pathList == null || pathList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PartialPath> ret = new ArrayList<PartialPath>();
        for (String s : pathList) {
            try {
                ret.add(new PartialPath(s));
            }
            catch (IllegalPathException e) {
                logger.warn("Encountered an illegal path {}", (Object)s);
            }
        }
        return ret;
    }

    public PartialPath clone() {
        return new PartialPath((String[])this.getNodes().clone());
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS publicBAOS = new PublicBAOS();
        this.serialize((OutputStream)publicBAOS);
        return ByteBuffer.wrap(publicBAOS.getBuf(), 0, publicBAOS.size());
    }

    public void serialize(OutputStream stream) throws IOException {
        PathType.Partial.serialize(stream);
        this.serializeWithoutType(stream);
    }

    public void serialize(ByteBuffer byteBuffer) {
        PathType.Partial.serialize(byteBuffer);
        this.serializeWithoutType(byteBuffer);
    }

    public void serialize(PublicBAOS stream) throws IOException {
        PathType.Partial.serialize(stream);
        this.serializeWithoutType(stream);
    }

    protected void serializeWithoutType(ByteBuffer byteBuffer) {
        super.serializeWithoutType(byteBuffer);
        ReadWriteIOUtils.write((int)this.nodes.length, (ByteBuffer)byteBuffer);
        for (String node : this.nodes) {
            ReadWriteIOUtils.write((String)node, (ByteBuffer)byteBuffer);
        }
    }

    protected void serializeWithoutType(OutputStream stream) throws IOException {
        super.serializeWithoutType(stream);
        ReadWriteIOUtils.write((int)this.nodes.length, (OutputStream)stream);
        for (String node : this.nodes) {
            ReadWriteIOUtils.write((String)node, (OutputStream)stream);
        }
    }

    public static PartialPath deserialize(ByteBuffer byteBuffer) {
        Path path = Path.deserialize((ByteBuffer)byteBuffer);
        PartialPath partialPath = new PartialPath();
        int nodeSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        String[] nodes = new String[nodeSize];
        for (int i = 0; i < nodeSize; ++i) {
            nodes[i] = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        }
        partialPath.nodes = nodes;
        partialPath.setMeasurement(path.getMeasurement());
        partialPath.device = path.getDevice();
        partialPath.fullPath = path.getFullPath();
        return partialPath;
    }

    public PartialPath transformToPartialPath() {
        return this;
    }

    public static int estimateSize(PartialPath partialPath) {
        int size = 52;
        for (String node : partialPath.getNodes()) {
            size += PartialPath.estimateStringSize(node);
        }
        return size += PartialPath.estimateStringSize(partialPath.getFullPath());
    }

    private static int estimateStringSize(String string) {
        return string == null ? 0 : 32 + 2 * string.length();
    }
}

