/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.reader.page;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.BatchDataFactory;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.operator.AndFilter;
import org.apache.iotdb.tsfile.read.reader.IAlignedPageReader;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.read.reader.page.TimePageReader;
import org.apache.iotdb.tsfile.read.reader.page.ValuePageReader;
import org.apache.iotdb.tsfile.read.reader.series.PaginationController;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class AlignedPageReader
implements IPageReader,
IAlignedPageReader {
    private final TimePageReader timePageReader;
    private final List<ValuePageReader> valuePageReaderList;
    private final int valueCount;
    private Filter filter;
    private PaginationController paginationController = PaginationController.UNLIMITED_PAGINATION_CONTROLLER;
    private boolean isModified;
    private TsBlockBuilder builder;
    private static final int MASK = 128;

    public AlignedPageReader(PageHeader timePageHeader, ByteBuffer timePageData, Decoder timeDecoder, List<PageHeader> valuePageHeaderList, List<ByteBuffer> valuePageDataList, List<TSDataType> valueDataTypeList, List<Decoder> valueDecoderList, Filter filter) {
        this.timePageReader = new TimePageReader(timePageHeader, timePageData, timeDecoder);
        this.isModified = this.timePageReader.isModified();
        this.valuePageReaderList = new ArrayList<ValuePageReader>(valuePageHeaderList.size());
        for (int i = 0; i < valuePageHeaderList.size(); ++i) {
            if (valuePageHeaderList.get(i) != null) {
                ValuePageReader valuePageReader = new ValuePageReader(valuePageHeaderList.get(i), valuePageDataList.get(i), valueDataTypeList.get(i), valueDecoderList.get(i));
                this.valuePageReaderList.add(valuePageReader);
                this.isModified = this.isModified || valuePageReader.isModified();
                continue;
            }
            this.valuePageReaderList.add(null);
        }
        this.filter = filter;
        this.valueCount = this.valuePageReaderList.size();
    }

    @Override
    public BatchData getAllSatisfiedPageData(boolean ascending) throws IOException {
        BatchData pageData = BatchDataFactory.createBatchData(TSDataType.VECTOR, ascending, false);
        int timeIndex = -1;
        while (this.timePageReader.hasNextTime()) {
            long timestamp = this.timePageReader.nextTime();
            ++timeIndex;
            boolean isNull = true;
            Object notNullObject = null;
            TsPrimitiveType[] v = new TsPrimitiveType[this.valueCount];
            for (int i = 0; i < v.length; ++i) {
                ValuePageReader pageReader = this.valuePageReaderList.get(i);
                TsPrimitiveType tsPrimitiveType = v[i] = pageReader == null ? null : pageReader.nextValue(timestamp, timeIndex);
                if (v[i] == null) continue;
                isNull = false;
                notNullObject = v[i].getValue();
            }
            if (isNull || this.filter != null && !this.filter.satisfy(timestamp, notNullObject)) continue;
            pageData.putVector(timestamp, v);
        }
        return pageData.flip();
    }

    private boolean pageSatisfy() {
        if (this.filter != null) {
            return this.filter.satisfy(this.getStatistics());
        }
        long rowCount = this.getTimeStatistics().getCount();
        for (Statistics<Serializable> statistics : this.getValueStatisticsList()) {
            if (statistics != null && !statistics.hasNullValue(rowCount)) continue;
            return true;
        }
        if (this.paginationController.hasCurOffset(rowCount)) {
            this.paginationController.consumeOffset(rowCount);
            return false;
        }
        return true;
    }

    @Override
    public TsBlock getAllSatisfiedData() throws IOException {
        int i;
        this.builder.reset();
        if (!this.pageSatisfy()) {
            return this.builder.build();
        }
        long[] timeBatch = this.timePageReader.getNextTimeBatch();
        boolean[] keepCurrentRow = new boolean[timeBatch.length];
        if (this.filter == null) {
            Arrays.fill(keepCurrentRow, true);
        } else {
            int n = timeBatch.length;
            for (int i2 = 0; i2 < n; ++i2) {
                keepCurrentRow[i2] = this.filter.satisfy(timeBatch[i2], null);
            }
        }
        byte[] bitmask = new byte[(timeBatch.length - 1) / 8 + 1];
        Arrays.fill(bitmask, (byte)0);
        boolean[][] isDeleted = new boolean[this.valueCount][timeBatch.length];
        for (int columnIndex = 0; columnIndex < this.valueCount; ++columnIndex) {
            int i3;
            ValuePageReader pageReader = this.valuePageReaderList.get(columnIndex);
            if (pageReader == null) continue;
            byte[] bitmap = pageReader.getBitmap();
            pageReader.fillIsDeleted(timeBatch, isDeleted[columnIndex]);
            int n = isDeleted[columnIndex].length;
            for (i3 = 0; i3 < n; ++i3) {
                if (!isDeleted[columnIndex][i3]) continue;
                int shift = i3 % 8;
                bitmap[i3 / 8] = (byte)(bitmap[i3 / 8] & ~(128 >>> shift));
            }
            n = bitmask.length;
            for (i3 = 0; i3 < n; ++i3) {
                bitmask[i3] = (byte)(bitmap[i3] | bitmask[i3]);
            }
        }
        int n = bitmask.length;
        for (int i4 = 0; i4 < n; ++i4) {
            int j;
            if (bitmask[i4] == -1) continue;
            if (bitmask[i4] == 0) {
                for (j = 0; j < 8 && i4 * 8 + j < keepCurrentRow.length; ++j) {
                    keepCurrentRow[i4 * 8 + j] = false;
                }
                continue;
            }
            for (j = 0; j < 8 && i4 * 8 + j < keepCurrentRow.length; ++j) {
                if ((bitmask[i4] & 0xFF & 128 >>> j) != 0) continue;
                keepCurrentRow[i4 * 8 + j] = false;
            }
        }
        int readEndIndex = timeBatch.length;
        for (i = 0; i < timeBatch.length; ++i) {
            if (!keepCurrentRow[i]) continue;
            if (this.paginationController.hasCurOffset()) {
                this.paginationController.consumeOffset();
                keepCurrentRow[i] = false;
                continue;
            }
            if (this.paginationController.hasCurLimit()) {
                this.builder.getTimeColumnBuilder().writeLong(timeBatch[i]);
                this.builder.declarePosition();
                this.paginationController.consumeLimit();
                continue;
            }
            readEndIndex = i;
            break;
        }
        for (i = 0; i < this.valueCount; ++i) {
            ValuePageReader pageReader = this.valuePageReaderList.get(i);
            if (pageReader != null) {
                pageReader.writeColumnBuilderWithNextBatch(readEndIndex, this.builder.getColumnBuilder(i), keepCurrentRow, isDeleted[i]);
                continue;
            }
            for (int j = 0; j < readEndIndex; ++j) {
                if (!keepCurrentRow[j]) continue;
                this.builder.getColumnBuilder(i).appendNull();
            }
        }
        return this.builder.build();
    }

    public void setDeleteIntervalList(List<List<TimeRange>> list) {
        for (int i = 0; i < this.valueCount; ++i) {
            if (this.valuePageReaderList.get(i) == null) continue;
            this.valuePageReaderList.get(i).setDeleteIntervalList(list.get(i));
        }
    }

    public Statistics getStatistics() {
        return this.valuePageReaderList.size() == 1 && this.valuePageReaderList.get(0) != null ? this.valuePageReaderList.get(0).getStatistics() : this.timePageReader.getStatistics();
    }

    @Override
    public Statistics getStatistics(int index) {
        ValuePageReader valuePageReader = this.valuePageReaderList.get(index);
        return valuePageReader == null ? null : valuePageReader.getStatistics();
    }

    @Override
    public Statistics getTimeStatistics() {
        return this.timePageReader.getStatistics();
    }

    private List<Statistics<Serializable>> getValueStatisticsList() {
        ArrayList<Statistics<Serializable>> valueStatisticsList = new ArrayList<Statistics<Serializable>>();
        for (ValuePageReader v : this.valuePageReaderList) {
            valueStatisticsList.add(v == null ? null : v.getStatistics());
        }
        return valueStatisticsList;
    }

    @Override
    public void setFilter(Filter filter) {
        this.filter = this.filter == null ? filter : new AndFilter(this.filter, filter);
    }

    @Override
    public void setLimitOffset(PaginationController paginationController) {
        this.paginationController = paginationController;
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    @Override
    public void initTsBlockBuilder(List<TSDataType> dataTypes) {
        this.builder = new TsBlockBuilder(dataTypes);
    }
}

