/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.pipe;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.pipe.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeMetaKeeper;
import org.apache.iotdb.commons.pipe.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeStatus;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.consensus.request.write.pipe.runtime.PipeHandleLeaderChangePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.runtime.PipeHandleMetaChangePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.CreatePipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.DropPipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.SetPipeStatusPlanV2;
import org.apache.iotdb.confignode.consensus.response.pipe.task.PipeTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.mpp.rpc.thrift.TPushPipeMetaResp;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTaskInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTaskInfo.class);
    private static final String SNAPSHOT_FILE_NAME = "pipe_task_info.bin";
    private final PipeMetaKeeper pipeMetaKeeper = new PipeMetaKeeper();

    private void acquireReadLock() {
        this.pipeMetaKeeper.acquireReadLock();
    }

    private void releaseReadLock() {
        this.pipeMetaKeeper.releaseReadLock();
    }

    private void acquireWriteLock() {
        this.pipeMetaKeeper.acquireWriteLock();
    }

    private void releaseWriteLock() {
        this.pipeMetaKeeper.releaseWriteLock();
    }

    public void checkBeforeCreatePipe(TCreatePipeReq createPipeRequest) throws PipeException {
        this.acquireReadLock();
        try {
            this.checkBeforeCreatePipeInternal(createPipeRequest);
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void checkBeforeCreatePipeInternal(TCreatePipeReq createPipeRequest) throws PipeException {
        if (!this.isPipeExisted(createPipeRequest.getPipeName())) {
            return;
        }
        String exceptionMessage = String.format("Failed to create pipe %s, the pipe with the same name has been created", createPipeRequest.getPipeName());
        LOGGER.info(exceptionMessage);
        throw new PipeException(exceptionMessage);
    }

    public void checkBeforeStartPipe(String pipeName) throws PipeException {
        this.acquireReadLock();
        try {
            this.checkBeforeStartPipeInternal(pipeName);
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void checkBeforeStartPipeInternal(String pipeName) throws PipeException {
        if (!this.isPipeExisted(pipeName)) {
            String exceptionMessage = String.format("Failed to start pipe %s, the pipe does not exist", pipeName);
            LOGGER.info(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
        PipeStatus pipeStatus = this.getPipeStatus(pipeName);
        if (pipeStatus == PipeStatus.RUNNING) {
            String exceptionMessage = String.format("Failed to start pipe %s, the pipe is already running", pipeName);
            LOGGER.info(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
        if (pipeStatus == PipeStatus.DROPPED) {
            String exceptionMessage = String.format("Failed to start pipe %s, the pipe is already dropped", pipeName);
            LOGGER.info(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
    }

    public void checkBeforeStopPipe(String pipeName) throws PipeException {
        this.acquireReadLock();
        try {
            this.checkBeforeStopPipeInternal(pipeName);
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void checkBeforeStopPipeInternal(String pipeName) throws PipeException {
        if (!this.isPipeExisted(pipeName)) {
            String exceptionMessage = String.format("Failed to stop pipe %s, the pipe does not exist", pipeName);
            LOGGER.info(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
        PipeStatus pipeStatus = this.getPipeStatus(pipeName);
        if (pipeStatus == PipeStatus.STOPPED) {
            String exceptionMessage = String.format("Failed to stop pipe %s, the pipe is already stop", pipeName);
            LOGGER.info(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
        if (pipeStatus == PipeStatus.DROPPED) {
            String exceptionMessage = String.format("Failed to stop pipe %s, the pipe is already dropped", pipeName);
            LOGGER.info(exceptionMessage);
            throw new PipeException(exceptionMessage);
        }
    }

    public void checkBeforeDropPipe(String pipeName) {
        this.acquireReadLock();
        try {
            this.checkBeforeDropPipeInternal(pipeName);
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void checkBeforeDropPipeInternal(String pipeName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Check before drop pipe {}, pipe exists: {}.", (Object)pipeName, (Object)(this.isPipeExisted(pipeName) ? "true" : "false"));
        }
    }

    public boolean isPipeExisted(String pipeName) {
        this.acquireReadLock();
        try {
            boolean bl = this.pipeMetaKeeper.containsPipeMeta(pipeName);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private PipeStatus getPipeStatus(String pipeName) {
        this.acquireReadLock();
        try {
            PipeStatus pipeStatus = (PipeStatus)this.pipeMetaKeeper.getPipeMeta(pipeName).getRuntimeMeta().getStatus().get();
            return pipeStatus;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public TSStatus createPipe(CreatePipePlanV2 plan) {
        this.acquireWriteLock();
        try {
            this.pipeMetaKeeper.addPipeMeta(plan.getPipeStaticMeta().getPipeName(), new PipeMeta(plan.getPipeStaticMeta(), plan.getPipeRuntimeMeta()));
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public TSStatus setPipeStatus(SetPipeStatusPlanV2 plan) {
        this.acquireWriteLock();
        try {
            this.pipeMetaKeeper.getPipeMeta(plan.getPipeName()).getRuntimeMeta().getStatus().set(plan.getPipeStatus());
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public TSStatus dropPipe(DropPipePlanV2 plan) {
        this.acquireWriteLock();
        try {
            this.pipeMetaKeeper.removePipeMeta(plan.getPipeName());
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public DataSet showPipes() {
        this.acquireReadLock();
        try {
            PipeTableResp pipeTableResp = new PipeTableResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), StreamSupport.stream(this.getPipeMetaList().spliterator(), false).collect(Collectors.toList()));
            return pipeTableResp;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public Iterable<PipeMeta> getPipeMetaList() {
        this.acquireReadLock();
        try {
            Iterable iterable = this.pipeMetaKeeper.getPipeMetaList();
            return iterable;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public boolean isEmpty() {
        this.acquireReadLock();
        try {
            boolean bl = this.pipeMetaKeeper.isEmpty();
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public TSStatus handleLeaderChange(PipeHandleLeaderChangePlan plan) {
        this.acquireWriteLock();
        try {
            TSStatus tSStatus = this.handleLeaderChangeInternal(plan);
            return tSStatus;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private TSStatus handleLeaderChangeInternal(PipeHandleLeaderChangePlan plan) {
        plan.getConsensusGroupId2NewDataRegionLeaderIdMap().forEach((dataRegionGroupId, newDataRegionLeader) -> this.pipeMetaKeeper.getPipeMetaList().forEach(pipeMeta -> {
            Map consensusGroupIdToTaskMetaMap = pipeMeta.getRuntimeMeta().getConsensusGroupId2TaskMetaMap();
            if (consensusGroupIdToTaskMetaMap.containsKey(dataRegionGroupId)) {
                if (newDataRegionLeader != -1) {
                    ((PipeTaskMeta)consensusGroupIdToTaskMetaMap.get(dataRegionGroupId)).setLeaderDataNodeId(newDataRegionLeader.intValue());
                } else {
                    consensusGroupIdToTaskMetaMap.remove(dataRegionGroupId);
                }
            } else if (newDataRegionLeader != -1) {
                consensusGroupIdToTaskMetaMap.put(dataRegionGroupId, new PipeTaskMeta((ProgressIndex)new MinimumProgressIndex(), newDataRegionLeader.intValue()));
            }
        }));
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus handleMetaChanges(PipeHandleMetaChangePlan plan) {
        this.acquireWriteLock();
        try {
            TSStatus tSStatus = this.handleMetaChangesInternal(plan);
            return tSStatus;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private TSStatus handleMetaChangesInternal(PipeHandleMetaChangePlan plan) {
        LOGGER.info("Handling pipe meta changes ...");
        this.pipeMetaKeeper.clear();
        plan.getPipeMetaList().forEach(pipeMeta -> {
            this.pipeMetaKeeper.addPipeMeta(pipeMeta.getStaticMeta().getPipeName(), pipeMeta);
            LOGGER.info("Recording pipe meta: {}", pipeMeta);
        });
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public boolean hasExceptions(String pipeName) {
        this.acquireReadLock();
        try {
            boolean bl = this.hasExceptionsInternal(pipeName);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private boolean hasExceptionsInternal(String pipeName) {
        if (!this.pipeMetaKeeper.containsPipeMeta(pipeName)) {
            return false;
        }
        PipeRuntimeMeta runtimeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName).getRuntimeMeta();
        Map exceptionMap = runtimeMeta.getDataNodeId2PipeRuntimeExceptionMap();
        if (!exceptionMap.isEmpty()) {
            return true;
        }
        AtomicBoolean hasException = new AtomicBoolean(false);
        runtimeMeta.getConsensusGroupId2TaskMetaMap().values().forEach(pipeTaskMeta -> {
            if (pipeTaskMeta.getExceptionMessages().iterator().hasNext()) {
                hasException.set(true);
            }
        });
        return hasException.get();
    }

    public boolean isStoppedByRuntimeException(String pipeName) {
        this.acquireReadLock();
        try {
            boolean bl = this.isStoppedByRuntimeExceptionInternal(pipeName);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private boolean isStoppedByRuntimeExceptionInternal(String pipeName) {
        return this.pipeMetaKeeper.containsPipeMeta(pipeName) && this.pipeMetaKeeper.getPipeMeta(pipeName).getRuntimeMeta().getIsStoppedByRuntimeException();
    }

    public void clearExceptionsAndSetIsStoppedByRuntimeExceptionToFalse(String pipeName) {
        this.acquireWriteLock();
        try {
            this.clearExceptionsAndSetIsStoppedByRuntimeExceptionToFalseInternal(pipeName);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void clearExceptionsAndSetIsStoppedByRuntimeExceptionToFalseInternal(String pipeName) {
        if (!this.pipeMetaKeeper.containsPipeMeta(pipeName)) {
            return;
        }
        PipeRuntimeMeta runtimeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName).getRuntimeMeta();
        runtimeMeta.setIsStoppedByRuntimeException(false);
        runtimeMeta.setExceptionsClearTime(System.currentTimeMillis());
        Map exceptionMap = runtimeMeta.getDataNodeId2PipeRuntimeExceptionMap();
        if (!exceptionMap.isEmpty()) {
            exceptionMap.clear();
        }
        runtimeMeta.getConsensusGroupId2TaskMetaMap().values().forEach(pipeTaskMeta -> {
            if (pipeTaskMeta.getExceptionMessages().iterator().hasNext()) {
                pipeTaskMeta.clearExceptionMessages();
            }
        });
    }

    public void setIsStoppedByRuntimeExceptionToFalse(String pipeName) {
        this.acquireWriteLock();
        try {
            this.setIsStoppedByRuntimeExceptionToFalseInternal(pipeName);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void setIsStoppedByRuntimeExceptionToFalseInternal(String pipeName) {
        if (!this.pipeMetaKeeper.containsPipeMeta(pipeName)) {
            return;
        }
        this.pipeMetaKeeper.getPipeMeta(pipeName).getRuntimeMeta().setIsStoppedByRuntimeException(false);
    }

    public boolean recordPushPipeMetaExceptions(Map<Integer, TPushPipeMetaResp> respMap) {
        this.acquireWriteLock();
        try {
            boolean bl = this.recordPushPipeMetaExceptionsInternal(respMap);
            return bl;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private boolean recordPushPipeMetaExceptionsInternal(Map<Integer, TPushPipeMetaResp> respMap) {
        boolean hasException = false;
        for (Map.Entry<Integer, TPushPipeMetaResp> respEntry : respMap.entrySet()) {
            int dataNodeId = respEntry.getKey();
            TPushPipeMetaResp resp = respEntry.getValue();
            if (resp.getStatus().getCode() != TSStatusCode.PIPE_PUSH_META_ERROR.getStatusCode()) continue;
            hasException = true;
            if (!resp.isSetExceptionMessages()) continue;
            resp.getExceptionMessages().forEach(message -> {
                if (this.pipeMetaKeeper.containsPipeMeta(message.getPipeName())) {
                    PipeRuntimeMeta runtimeMeta = this.pipeMetaKeeper.getPipeMeta(message.getPipeName()).getRuntimeMeta();
                    runtimeMeta.getStatus().set(PipeStatus.STOPPED);
                    runtimeMeta.setIsStoppedByRuntimeException(true);
                    Map exceptionMap = runtimeMeta.getDataNodeId2PipeRuntimeExceptionMap();
                    if (!exceptionMap.containsKey(dataNodeId) || ((PipeRuntimeException)exceptionMap.get(dataNodeId)).getTimeStamp() < message.getTimeStamp()) {
                        exceptionMap.put(dataNodeId, new PipeRuntimeCriticalException(message.getMessage(), message.getTimeStamp()));
                    }
                }
            });
        }
        return hasException;
    }

    public boolean autoRestart() {
        this.acquireWriteLock();
        try {
            boolean bl = this.autoRestartInternal();
            return bl;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private boolean autoRestartInternal() {
        AtomicBoolean needRestart = new AtomicBoolean(false);
        LinkedList pipeToRestart = new LinkedList();
        this.pipeMetaKeeper.getPipeMetaList().forEach(pipeMeta -> {
            if (pipeMeta.getRuntimeMeta().getIsStoppedByRuntimeException()) {
                pipeMeta.getRuntimeMeta().getStatus().set(PipeStatus.RUNNING);
                needRestart.set(true);
                pipeToRestart.add(pipeMeta.getStaticMeta().getPipeName());
            }
        });
        if (needRestart.get()) {
            LOGGER.info("PipeMetaSyncer is trying to restart the pipes: {}", pipeToRestart);
        }
        return needRestart.get();
    }

    public void handleSuccessfulRestart() {
        this.acquireWriteLock();
        try {
            this.handleSuccessfulRestartInternal();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void handleSuccessfulRestartInternal() {
        this.pipeMetaKeeper.getPipeMetaList().forEach(pipeMeta -> {
            if (((PipeStatus)pipeMeta.getRuntimeMeta().getStatus().get()).equals((Object)PipeStatus.RUNNING)) {
                this.clearExceptionsAndSetIsStoppedByRuntimeExceptionToFalse(pipeMeta.getStaticMeta().getPipeName());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processTakeSnapshot(File snapshotDir) throws IOException {
        this.acquireReadLock();
        try {
            File snapshotFile = new File(snapshotDir, SNAPSHOT_FILE_NAME);
            if (snapshotFile.exists() && snapshotFile.isFile()) {
                LOGGER.error("Failed to take snapshot, because snapshot file [{}] is already exist.", (Object)snapshotFile.getAbsolutePath());
                boolean bl = false;
                return bl;
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(snapshotFile);){
                this.pipeMetaKeeper.processTakeSnapshot(fileOutputStream);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoadSnapshot(File snapshotDir) throws IOException {
        this.acquireWriteLock();
        try {
            File snapshotFile = new File(snapshotDir, SNAPSHOT_FILE_NAME);
            if (!snapshotFile.exists() || !snapshotFile.isFile()) {
                LOGGER.error("Failed to load snapshot,snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
                return;
            }
            try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);){
                this.pipeMetaKeeper.processLoadSnapshot(fileInputStream);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public int hashCode() {
        return this.pipeMetaKeeper.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipeTaskInfo other = (PipeTaskInfo)obj;
        return this.pipeMetaKeeper.equals((Object)other.pipeMetaKeeper);
    }

    public String toString() {
        return this.pipeMetaKeeper.toString();
    }
}

