/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.partition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.structure.BalanceTreeMap;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;

public class DataPartitionPolicyTable {
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final int SERIES_SLOT_NUM = CONF.getSeriesSlotNum();
    private final ReentrantLock dataAllotTableLock = new ReentrantLock();
    private final Map<TSeriesPartitionSlot, TConsensusGroupId> dataAllotMap = new HashMap<TSeriesPartitionSlot, TConsensusGroupId>();
    private final BalanceTreeMap<TConsensusGroupId, Integer> seriesPartitionSlotCounter = new BalanceTreeMap();

    public TConsensusGroupId getRegionGroupIdOrActivateIfNecessary(TSeriesPartitionSlot seriesPartitionSlot) {
        if (this.dataAllotMap.containsKey(seriesPartitionSlot)) {
            return this.dataAllotMap.get(seriesPartitionSlot);
        }
        TConsensusGroupId regionGroupId = (TConsensusGroupId)this.seriesPartitionSlotCounter.getKeyWithMinValue();
        this.dataAllotMap.put(seriesPartitionSlot, regionGroupId);
        this.seriesPartitionSlotCounter.put((Object)regionGroupId, (Comparable)Integer.valueOf((Integer)this.seriesPartitionSlotCounter.get((Object)regionGroupId) + 1));
        return regionGroupId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reBalanceDataPartitionPolicy(List<TConsensusGroupId> dataRegionGroups) {
        if (dataRegionGroups.isEmpty()) {
            return;
        }
        this.dataAllotTableLock.lock();
        try {
            dataRegionGroups.forEach(dataRegionGroup -> {
                if (!this.seriesPartitionSlotCounter.containsKey(dataRegionGroup)) {
                    this.seriesPartitionSlotCounter.put(dataRegionGroup, (Comparable)Integer.valueOf(0));
                }
            });
            ArrayList<TSeriesPartitionSlot> seriesPartitionSlots = new ArrayList<TSeriesPartitionSlot>();
            for (int i = 0; i < SERIES_SLOT_NUM; ++i) {
                seriesPartitionSlots.add(new TSeriesPartitionSlot(i));
            }
            Collections.shuffle(seriesPartitionSlots);
            int mu = SERIES_SLOT_NUM / dataRegionGroups.size();
            for (TSeriesPartitionSlot seriesPartitionSlot : seriesPartitionSlots) {
                TConsensusGroupId regionGroupId;
                int seriesPartitionSlotCount;
                if (!this.dataAllotMap.containsKey(seriesPartitionSlot) || (seriesPartitionSlotCount = ((Integer)this.seriesPartitionSlotCounter.get((Object)(regionGroupId = this.dataAllotMap.get(seriesPartitionSlot)))).intValue()) <= mu) continue;
                this.dataAllotMap.remove(seriesPartitionSlot);
                this.seriesPartitionSlotCounter.put((Object)regionGroupId, (Comparable)Integer.valueOf(seriesPartitionSlotCount - 1));
            }
        }
        finally {
            this.dataAllotTableLock.unlock();
        }
    }

    public void setDataAllotMap(Map<TSeriesPartitionSlot, TConsensusGroupId> dataAllotMap) {
        if (this.seriesPartitionSlotCounter.size() == 0) {
            return;
        }
        try {
            this.dataAllotTableLock.lock();
            int mu = SERIES_SLOT_NUM / this.seriesPartitionSlotCounter.size();
            dataAllotMap.forEach((seriesPartitionSlot, regionGroupId) -> {
                if (regionGroupId != null && (Integer)this.seriesPartitionSlotCounter.get(regionGroupId) < mu) {
                    this.dataAllotMap.put((TSeriesPartitionSlot)seriesPartitionSlot, (TConsensusGroupId)regionGroupId);
                    this.seriesPartitionSlotCounter.put(regionGroupId, (Comparable)Integer.valueOf((Integer)this.seriesPartitionSlotCounter.get(regionGroupId) + 1));
                }
            });
        }
        finally {
            this.dataAllotTableLock.unlock();
        }
    }

    public void acquireLock() {
        this.dataAllotTableLock.lock();
    }

    public void releaseLock() {
        this.dataAllotTableLock.unlock();
    }
}

