/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.rescon.memory;

import java.util.TreeSet;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.TimeIndexLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileResourceManager {
    private static final Logger logger = LoggerFactory.getLogger(TsFileResourceManager.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private double TIME_INDEX_MEMORY_THRESHOLD = CONFIG.getAllocateMemoryForTimeIndex();
    private final TreeSet<TsFileResource> sealedTsFileResources = new TreeSet(TsFileResource::compareIndexDegradePriority);
    private long totalTimeIndexMemCost;

    public void setTimeIndexMemoryThreshold(double timeIndexMemoryThreshold) {
        this.TIME_INDEX_MEMORY_THRESHOLD = timeIndexMemoryThreshold;
    }

    public long getPriorityQueueSize() {
        return this.sealedTsFileResources.size();
    }

    public synchronized void registerSealedTsFileResource(TsFileResource tsFileResource) {
        if (!this.sealedTsFileResources.contains(tsFileResource)) {
            this.sealedTsFileResources.add(tsFileResource);
            this.totalTimeIndexMemCost += tsFileResource.calculateRamSize();
            this.chooseTsFileResourceToDegrade();
        }
    }

    public synchronized void removeTsFileResource(TsFileResource tsFileResource) {
        if (this.sealedTsFileResources.contains(tsFileResource)) {
            this.sealedTsFileResources.remove(tsFileResource);
            this.totalTimeIndexMemCost = TimeIndexLevel.valueOf(tsFileResource.getTimeIndexType()) == TimeIndexLevel.FILE_TIME_INDEX ? (this.totalTimeIndexMemCost -= tsFileResource.calculateRamSize()) : (this.totalTimeIndexMemCost -= tsFileResource.getRamSize());
        }
    }

    private void releaseTimeIndexMemCost(long memCost) {
        this.totalTimeIndexMemCost -= memCost;
    }

    private void chooseTsFileResourceToDegrade() {
        while ((double)this.totalTimeIndexMemCost > this.TIME_INDEX_MEMORY_THRESHOLD) {
            TsFileResource tsFileResource = this.sealedTsFileResources.pollFirst();
            if (tsFileResource == null || TimeIndexLevel.valueOf(tsFileResource.getTimeIndexType()) == TimeIndexLevel.FILE_TIME_INDEX) {
                logger.debug("Can't degrade time index any more because all time index are file level.");
                this.sealedTsFileResources.add(tsFileResource);
                return;
            }
            long memoryReduce = tsFileResource.degradeTimeIndex();
            logger.debug("Degrade tsfile resource {}", (Object)tsFileResource.getTsFilePath());
            this.releaseTimeIndexMemCost(memoryReduce);
            this.sealedTsFileResources.add(tsFileResource);
        }
    }

    public synchronized void clear() {
        if (this.sealedTsFileResources != null) {
            this.sealedTsFileResources.clear();
        }
        this.totalTimeIndexMemCost = 0L;
    }

    public static TsFileResourceManager getInstance() {
        return InstanceHolder.instance;
    }

    private static class InstanceHolder {
        private static TsFileResourceManager instance = new TsFileResourceManager();

        private InstanceHolder() {
        }
    }
}

