/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.rescon.memory;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.rescon.memory.TimePartitionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimePartitionManager {
    private static final Logger logger = LoggerFactory.getLogger(TimePartitionManager.class);
    final Map<DataRegionId, Map<Long, TimePartitionInfo>> timePartitionInfoMap;
    long memCost = 0L;
    long timePartitionInfoMemoryThreshold = IoTDBDescriptor.getInstance().getConfig().getAllocateMemoryForTimePartitionInfo();

    private TimePartitionManager() {
        this.timePartitionInfoMap = new HashMap<DataRegionId, Map<Long, TimePartitionInfo>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTimePartitionInfo(TimePartitionInfo timePartitionInfo) {
        Map<DataRegionId, Map<Long, TimePartitionInfo>> map = this.timePartitionInfoMap;
        synchronized (map) {
            TreeMap timePartitionInfoMapForRegion = (TreeMap)this.timePartitionInfoMap.computeIfAbsent(timePartitionInfo.dataRegionId, k -> new TreeMap());
            Map.Entry entry = timePartitionInfoMapForRegion.floorEntry(timePartitionInfo.partitionId);
            if (entry != null) {
                ((TimePartitionInfo)entry.getValue()).isLatestPartition = false;
            }
            timePartitionInfoMapForRegion.put(timePartitionInfo.partitionId, timePartitionInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAfterFlushing(DataRegionId dataRegionId, long timePartitionId, long systemFlushTime, long memSize, boolean isActive) {
        Map<DataRegionId, Map<Long, TimePartitionInfo>> map = this.timePartitionInfoMap;
        synchronized (map) {
            TimePartitionInfo timePartitionInfo = (TimePartitionInfo)this.timePartitionInfoMap.computeIfAbsent(dataRegionId, k -> new TreeMap()).get(timePartitionId);
            if (timePartitionInfo != null) {
                timePartitionInfo.lastSystemFlushTime = systemFlushTime;
                this.memCost += memSize - timePartitionInfo.memSize;
                timePartitionInfo.memSize = memSize;
                timePartitionInfo.isActive = isActive;
                if (this.memCost > this.timePartitionInfoMemoryThreshold) {
                    this.evictOldPartition();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAfterOpeningTsFileProcessor(DataRegionId dataRegionId, long timePartitionId) {
        Map<DataRegionId, Map<Long, TimePartitionInfo>> map = this.timePartitionInfoMap;
        synchronized (map) {
            TimePartitionInfo timePartitionInfo = (TimePartitionInfo)this.timePartitionInfoMap.computeIfAbsent(dataRegionId, k -> new TreeMap()).get(timePartitionId);
            if (timePartitionInfo != null) {
                timePartitionInfo.isActive = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictOldPartition() {
        TreeSet<TimePartitionInfo> treeSet = new TreeSet<TimePartitionInfo>(TimePartitionInfo::comparePriority);
        Map<DataRegionId, Map<Long, TimePartitionInfo>> map = this.timePartitionInfoMap;
        synchronized (map) {
            for (Map.Entry<DataRegionId, Map<Long, TimePartitionInfo>> entry : this.timePartitionInfoMap.entrySet()) {
                treeSet.addAll(entry.getValue().values());
            }
            while (this.memCost > this.timePartitionInfoMemoryThreshold) {
                TimePartitionInfo timePartitionInfo = (TimePartitionInfo)treeSet.pollFirst();
                if (timePartitionInfo == null) {
                    return;
                }
                this.memCost -= timePartitionInfo.memSize;
                DataRegion dataRegion = StorageEngine.getInstance().getDataRegion(timePartitionInfo.dataRegionId);
                if (dataRegion != null) {
                    dataRegion.releaseFlushTimeMap(timePartitionInfo.partitionId);
                }
                this.timePartitionInfoMap.get(timePartitionInfo.dataRegionId).remove(timePartitionInfo.partitionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePartition(DataRegionId dataRegionId, long partitionId) {
        Map<DataRegionId, Map<Long, TimePartitionInfo>> map = this.timePartitionInfoMap;
        synchronized (map) {
            TimePartitionInfo timePartitionInfo;
            Map<Long, TimePartitionInfo> timePartitionInfoMapForDataRegion = this.timePartitionInfoMap.get(dataRegionId);
            if (timePartitionInfoMapForDataRegion != null && (timePartitionInfo = timePartitionInfoMapForDataRegion.get(partitionId)) != null) {
                timePartitionInfoMapForDataRegion.remove(partitionId);
                this.memCost -= timePartitionInfo.memSize;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimePartitionInfo getTimePartitionInfo(DataRegionId dataRegionId, long timePartitionId) {
        Map<DataRegionId, Map<Long, TimePartitionInfo>> map = this.timePartitionInfoMap;
        synchronized (map) {
            Map<Long, TimePartitionInfo> timePartitionInfoMapForDataRegion = this.timePartitionInfoMap.get(dataRegionId);
            if (timePartitionInfoMapForDataRegion == null) {
                return null;
            }
            return timePartitionInfoMapForDataRegion.get(timePartitionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<DataRegionId, Map<Long, TimePartitionInfo>> map = this.timePartitionInfoMap;
        synchronized (map) {
            this.timePartitionInfoMap.clear();
            this.memCost = 0L;
        }
    }

    public void setTimePartitionInfoMemoryThreshold(long timePartitionInfoMemoryThreshold) {
        this.timePartitionInfoMemoryThreshold = timePartitionInfoMemoryThreshold;
    }

    public static TimePartitionManager getInstance() {
        return InstanceHolder.instance;
    }

    private static class InstanceHolder {
        private static TimePartitionManager instance = new TimePartitionManager();

        private InstanceHolder() {
        }
    }
}

