/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.buffer;

import java.util.Objects;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryType;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALMode;

public class WALInfoEntry
extends WALEntry {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    public static final int FIXED_SERIALIZED_SIZE = 9;
    private TabletInfo tabletInfo;

    public WALInfoEntry(long memTableId, WALEntryValue value, boolean wait) {
        super(memTableId, value, wait);
    }

    public WALInfoEntry(long memTableId, WALEntryValue value) {
        this(memTableId, value, config.getWalMode() == WALMode.SYNC);
        if (value instanceof InsertTabletNode) {
            this.tabletInfo = new TabletInfo(0, ((InsertTabletNode)value).getRowCount());
        }
    }

    public WALInfoEntry(long memTableId, InsertTabletNode value, int tabletStart, int tabletEnd) {
        this(memTableId, value, config.getWalMode() == WALMode.SYNC);
        this.tabletInfo = new TabletInfo(tabletStart, tabletEnd);
    }

    WALInfoEntry(WALEntryType type, long memTableId, WALEntryValue value) {
        super(type, memTableId, value, false);
        if (value instanceof InsertTabletNode) {
            this.tabletInfo = new TabletInfo(0, ((InsertTabletNode)value).getRowCount());
        }
    }

    @Override
    public int serializedSize() {
        return 9 + (this.value == null ? 0 : this.value.serializedSize());
    }

    @Override
    public void serialize(IWALByteBufferView buffer) {
        buffer.put(this.type.getCode());
        buffer.putLong(this.memTableId);
        switch (this.type) {
            case INSERT_TABLET_NODE: {
                ((InsertTabletNode)this.value).serializeToWAL(buffer, this.tabletInfo.tabletStart, this.tabletInfo.tabletEnd);
                break;
            }
            case INSERT_ROW_NODE: 
            case DELETE_DATA_NODE: 
            case MEMORY_TABLE_SNAPSHOT: {
                this.value.serializeToWAL(buffer);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported wal entry type " + (Object)((Object)this.type));
            }
        }
    }

    @Override
    public boolean isSignal() {
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tabletInfo);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        WALInfoEntry other = (WALInfoEntry)obj;
        return Objects.equals(this.tabletInfo, other.tabletInfo);
    }

    private static class TabletInfo {
        private final int tabletStart;
        private final int tabletEnd;

        public TabletInfo(int tabletStart, int tabletEnd) {
            this.tabletStart = tabletStart;
            this.tabletEnd = tabletEnd;
        }

        public int hashCode() {
            return Objects.hash(this.tabletStart, this.tabletEnd);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TabletInfo)) {
                return false;
            }
            TabletInfo other = (TabletInfo)obj;
            return this.tabletStart == other.tabletStart && this.tabletEnd == other.tabletEnd;
        }
    }
}

