/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.ChunkMetadataElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.FileElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.PageElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.reader.PointPriorityReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.TimeRange;

public abstract class SeriesCompactionExecutor {
    private final FastCompactionTaskSummary summary;
    protected List<FileElement> fileList = new ArrayList<FileElement>();
    protected final PriorityQueue<ChunkMetadataElement> chunkMetadataQueue;
    protected final PriorityQueue<PageElement> pageQueue;
    protected AbstractCompactionWriter compactionWriter;
    protected int subTaskId;
    protected Map<TsFileResource, TsFileSequenceReader> readerCacheMap;
    private final Map<TsFileResource, List<Modification>> modificationCacheMap;
    private final PointPriorityReader pointPriorityReader;
    protected String deviceId;
    private final List<PageElement> candidateOverlappedPages = new ArrayList<PageElement>();
    private long nextChunkStartTime = Long.MAX_VALUE;
    private long nextPageStartTime = Long.MAX_VALUE;
    protected boolean isAligned;

    protected SeriesCompactionExecutor(AbstractCompactionWriter compactionWriter, Map<TsFileResource, TsFileSequenceReader> readerCacheMap, Map<TsFileResource, List<Modification>> modificationCacheMap, String deviceId, boolean isAligned, int subTaskId, FastCompactionTaskSummary summary) {
        this.compactionWriter = compactionWriter;
        this.subTaskId = subTaskId;
        this.deviceId = deviceId;
        this.readerCacheMap = readerCacheMap;
        this.modificationCacheMap = modificationCacheMap;
        this.summary = summary;
        this.pointPriorityReader = new PointPriorityReader(this::checkShouldRemoveFile, isAligned);
        this.isAligned = isAligned;
        this.chunkMetadataQueue = new PriorityQueue((o1, o2) -> {
            int timeCompare = Long.compare(o1.startTime, o2.startTime);
            return timeCompare != 0 ? timeCompare : Long.compare(o2.priority, o1.priority);
        });
        this.pageQueue = new PriorityQueue((o1, o2) -> {
            int timeCompare = Long.compare(o1.startTime, o2.startTime);
            return timeCompare != 0 ? timeCompare : Long.compare(o2.priority, o1.priority);
        });
    }

    public abstract void execute() throws PageException, IllegalPathException, IOException, WriteProcessException;

    protected abstract void compactFiles() throws PageException, IOException, WriteProcessException, IllegalPathException;

    protected void compactChunks() throws IOException, PageException, WriteProcessException, IllegalPathException {
        while (!this.chunkMetadataQueue.isEmpty()) {
            ChunkMetadataElement firstChunkMetadataElement = this.chunkMetadataQueue.poll();
            this.nextChunkStartTime = this.chunkMetadataQueue.isEmpty() ? Long.MAX_VALUE : this.chunkMetadataQueue.peek().startTime;
            boolean isChunkOverlap = firstChunkMetadataElement.chunkMetadata.getEndTime() >= this.nextChunkStartTime;
            boolean isModified = firstChunkMetadataElement.chunkMetadata.isModified();
            this.readChunk(firstChunkMetadataElement);
            boolean forceDecodingChunk = firstChunkMetadataElement.needForceDecoding;
            if (isChunkOverlap || isModified || forceDecodingChunk) {
                ++this.summary.chunkOverlapOrModified;
                this.compactWithOverlapChunks(firstChunkMetadataElement);
                continue;
            }
            ++this.summary.chunkNoneOverlap;
            this.compactWithNonOverlapChunk(firstChunkMetadataElement);
        }
    }

    private void compactWithOverlapChunks(ChunkMetadataElement overlappedChunkMetadata) throws IOException, PageException, WriteProcessException, IllegalPathException {
        this.deserializeChunkIntoPageQueue(overlappedChunkMetadata);
        this.compactPages();
    }

    private void compactWithNonOverlapChunk(ChunkMetadataElement chunkMetadataElement) throws IOException, PageException, WriteProcessException, IllegalPathException {
        boolean success = this.isAligned ? this.compactionWriter.flushAlignedChunk(chunkMetadataElement.chunk, ((AlignedChunkMetadata)chunkMetadataElement.chunkMetadata).getTimeChunkMetadata(), chunkMetadataElement.valueChunks, ((AlignedChunkMetadata)chunkMetadataElement.chunkMetadata).getValueChunkMetadataList(), this.subTaskId) : this.compactionWriter.flushNonAlignedChunk(chunkMetadataElement.chunk, (ChunkMetadata)chunkMetadataElement.chunkMetadata, this.subTaskId);
        if (success) {
            this.updateSummary(chunkMetadataElement, ChunkStatus.DIRECTORY_FLUSH);
            this.checkShouldRemoveFile(chunkMetadataElement);
        } else {
            ++this.summary.chunkNoneOverlapButDeserialize;
            this.deserializeChunkIntoPageQueue(chunkMetadataElement);
            this.compactPages();
        }
    }

    abstract void deserializeChunkIntoPageQueue(ChunkMetadataElement var1) throws IOException;

    abstract void readChunk(ChunkMetadataElement var1) throws IOException;

    abstract void deserializeFileIntoChunkMetadataQueue(List<FileElement> var1) throws IOException, IllegalPathException;

    private void compactPages() throws IOException, PageException, WriteProcessException, IllegalPathException {
        while (!this.pageQueue.isEmpty()) {
            boolean isPageOverlap;
            PageElement firstPageElement = this.getPageFromPageQueue(this.pageQueue.peek().startTime);
            ModifiedStatus modifiedStatus = this.isPageModified(firstPageElement);
            if (modifiedStatus == ModifiedStatus.ALL_DELETED) {
                this.checkShouldRemoveFile(firstPageElement);
                continue;
            }
            boolean bl = isPageOverlap = firstPageElement.pageHeader.getEndTime() >= this.nextPageStartTime || firstPageElement.pageHeader.getEndTime() >= this.nextChunkStartTime;
            if (isPageOverlap || modifiedStatus == ModifiedStatus.PARTIAL_DELETED || firstPageElement.needForceDecoding) {
                ++this.summary.pageOverlapOrModified;
                this.pointPriorityReader.addNewPage(firstPageElement);
                this.compactWithOverlapPages();
                continue;
            }
            ++this.summary.pageNoneOverlap;
            this.compactWithNonOverlapPage(firstPageElement);
        }
    }

    private void compactWithNonOverlapPage(PageElement pageElement) throws PageException, IOException, WriteProcessException, IllegalPathException {
        boolean success = this.isAligned ? this.compactionWriter.flushAlignedPage(pageElement.pageData, pageElement.pageHeader, pageElement.valuePageDatas, pageElement.valuePageHeaders, this.subTaskId) : this.compactionWriter.flushNonAlignedPage(pageElement.pageData, pageElement.pageHeader, this.subTaskId);
        if (success) {
            this.checkShouldRemoveFile(pageElement);
        } else {
            TimeValuePair point;
            ++this.summary.pageNoneOverlapButDeserialize;
            this.pointPriorityReader.addNewPage(pageElement);
            while (this.pointPriorityReader.hasNext() && (point = this.pointPriorityReader.currentPoint()).getTimestamp() <= pageElement.pageHeader.getEndTime()) {
                this.compactionWriter.write(point, this.subTaskId);
                this.pointPriorityReader.next();
            }
        }
    }

    private void compactWithOverlapPages() throws IOException, PageException, WriteProcessException, IllegalPathException {
        while (this.pointPriorityReader.hasNext()) {
            TimeValuePair currentPoint = this.pointPriorityReader.currentPoint();
            long currentTime = currentPoint.getTimestamp();
            while (currentTime >= this.nextChunkStartTime || currentTime >= this.nextPageStartTime) {
                PageElement nextPageElement = this.getPageFromPageQueue(currentTime);
                this.checkAndCompactOverlapPage(nextPageElement, currentPoint);
                currentPoint = this.pointPriorityReader.currentPoint();
                currentTime = currentPoint.getTimestamp();
            }
            this.compactionWriter.write(currentPoint, this.subTaskId);
            this.pointPriorityReader.next();
        }
    }

    private void checkAndCompactOverlapPage(PageElement nextPageElement, TimeValuePair currentPoint) throws IOException, IllegalPathException, PageException, WriteProcessException {
        ModifiedStatus nextPageModifiedStatus = this.isPageModified(nextPageElement);
        if (nextPageModifiedStatus == ModifiedStatus.ALL_DELETED) {
            this.checkShouldRemoveFile(nextPageElement);
        } else {
            boolean isNextPageOverlap;
            boolean bl = isNextPageOverlap = currentPoint.getTimestamp() <= nextPageElement.pageHeader.getEndTime() || nextPageElement.pageHeader.getEndTime() >= this.nextPageStartTime || nextPageElement.pageHeader.getEndTime() >= this.nextChunkStartTime;
            if (isNextPageOverlap || nextPageModifiedStatus == ModifiedStatus.PARTIAL_DELETED || nextPageElement.needForceDecoding) {
                ++this.summary.pageOverlapOrModified;
                this.pointPriorityReader.addNewPage(nextPageElement);
            } else {
                ++this.summary.pageFakeOverlap;
                this.compactWithNonOverlapPage(nextPageElement);
            }
        }
    }

    protected List<FileElement> findOverlapFiles(FileElement file) {
        ArrayList<FileElement> overlappedFiles = new ArrayList<FileElement>();
        long endTime = file.resource.getEndTime(this.deviceId);
        for (FileElement fileElement : this.fileList) {
            if (fileElement.resource.getStartTime(this.deviceId) > endTime) break;
            if (fileElement.isSelected) continue;
            overlappedFiles.add(fileElement);
            fileElement.isSelected = true;
        }
        return overlappedFiles;
    }

    protected abstract ModifiedStatus isPageModified(PageElement var1);

    protected ModifiedStatus checkIsModified(long startTime, long endTime, Collection<TimeRange> deletions) {
        ModifiedStatus status = ModifiedStatus.NONE_DELETED;
        if (deletions != null) {
            for (TimeRange range : deletions) {
                if (range.contains(startTime, endTime)) {
                    return ModifiedStatus.ALL_DELETED;
                }
                if (!range.overlaps(new TimeRange(startTime, endTime))) continue;
                status = ModifiedStatus.PARTIAL_DELETED;
            }
        }
        return status;
    }

    private PageElement getPageFromPageQueue(long curTime) throws IOException {
        if (curTime >= this.nextChunkStartTime) {
            ++this.summary.chunkOverlapOrModified;
            ChunkMetadataElement chunkMetadataElement = this.chunkMetadataQueue.poll();
            this.nextChunkStartTime = this.chunkMetadataQueue.isEmpty() ? Long.MAX_VALUE : this.chunkMetadataQueue.peek().startTime;
            this.readChunk(chunkMetadataElement);
            this.deserializeChunkIntoPageQueue(chunkMetadataElement);
        }
        PageElement page = this.pageQueue.poll();
        this.nextPageStartTime = this.pageQueue.isEmpty() ? Long.MAX_VALUE : this.pageQueue.peek().startTime;
        return page;
    }

    private void checkShouldRemoveFile(PageElement pageElement) throws IOException, IllegalPathException {
        if (pageElement.isLastPage && pageElement.chunkMetadataElement.isLastChunk) {
            this.removeFile(pageElement.chunkMetadataElement.fileElement);
        }
    }

    private void checkShouldRemoveFile(ChunkMetadataElement chunkMetadataElement) throws IOException, IllegalPathException {
        if (chunkMetadataElement.isLastChunk) {
            this.removeFile(chunkMetadataElement.fileElement);
        }
    }

    protected void removeFile(FileElement fileElement) throws IllegalPathException, IOException {
        boolean isFirstFile = this.fileList.get(0).equals(fileElement);
        this.fileList.remove(fileElement);
        if (isFirstFile && !this.fileList.isEmpty()) {
            List<FileElement> newOverlappedFiles = this.findOverlapFiles(this.fileList.get(0));
            this.deserializeFileIntoChunkMetadataQueue(newOverlappedFiles);
            this.nextChunkStartTime = this.chunkMetadataQueue.isEmpty() ? Long.MAX_VALUE : this.chunkMetadataQueue.peek().startTime;
        }
    }

    protected List<Modification> getModificationsFromCache(TsFileResource tsFileResource, PartialPath path) {
        List modifications = this.modificationCacheMap.computeIfAbsent(tsFileResource, resource -> new ArrayList<Modification>(resource.getModFile().getModifications()));
        ArrayList<Modification> pathModifications = new ArrayList<Modification>();
        for (Modification modification : modifications) {
            if (!modification.getPath().matchFullPath(path)) continue;
            pathModifications.add(modification);
        }
        return pathModifications;
    }

    protected void updateSummary(ChunkMetadataElement chunkMetadataElement, ChunkStatus status) {
        switch (status) {
            case READ_IN: {
                this.summary.increaseProcessChunkNum(this.isAligned ? ((AlignedChunkMetadata)chunkMetadataElement.chunkMetadata).getValueChunkMetadataList().size() + 1 : 1);
                if (this.isAligned) {
                    for (IChunkMetadata valueChunkMetadata : ((AlignedChunkMetadata)chunkMetadataElement.chunkMetadata).getValueChunkMetadataList()) {
                        if (valueChunkMetadata == null) continue;
                        this.summary.increaseProcessPointNum(valueChunkMetadata.getStatistics().getCount());
                    }
                    break;
                }
                this.summary.increaseProcessPointNum(chunkMetadataElement.chunkMetadata.getStatistics().getCount());
                break;
            }
            case DIRECTORY_FLUSH: {
                if (this.isAligned) {
                    this.summary.increaseDirectlyFlushChunkNum(((AlignedChunkMetadata)chunkMetadataElement.chunkMetadata).getValueChunkMetadataList().size() + 1);
                    break;
                }
                this.summary.increaseDirectlyFlushChunkNum(1);
                break;
            }
            case DESERIALIZE_CHUNK: {
                if (this.isAligned) {
                    this.summary.increaseDeserializedChunkNum(((AlignedChunkMetadata)chunkMetadataElement.chunkMetadata).getValueChunkMetadataList().size() + 1);
                    break;
                }
                this.summary.increaseDeserializedChunkNum(1);
                break;
            }
        }
    }

    static enum ChunkStatus {
        READ_IN,
        DIRECTORY_FLUSH,
        DESERIALIZE_CHUNK;

    }

    @FunctionalInterface
    public static interface RemovePage {
        public void call(PageElement var1) throws WriteProcessException, IOException, IllegalPathException;
    }

    protected static enum ModifiedStatus {
        ALL_DELETED,
        PARTIAL_DELETED,
        NONE_DELETED;

    }
}

